/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.etc.action;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.SelectPerspectiveDialog;

public class OpenPerspectiveAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        SelectPerspectiveDialog dlg = new SelectPerspectiveDialog(this.window.getShell(), reg);
        dlg.open();
        if (dlg.getReturnCode() == 1) {
            return;
        }
        IPerspectiveDescriptor desc = dlg.getSelection();
        if (desc != null) {
            this.run(desc);
        }
    }

    private void run(IPerspectiveDescriptor desc) {
        IPreferenceStore store = PlatformUI.getWorkbench().getPreferenceStore();
        int mode = store.getInt("OPEN_PERSPECTIVE_MODE");
        IWorkbenchPage page = this.window.getActivePage();
        IPerspectiveDescriptor persp = null;
        if (page != null) {
            persp = page.getPerspective();
        }
        if (2 == mode && persp != null) {
            try {
                IWorkbench workbench = this.window.getWorkbench();
                IAdaptable input = ((Workbench)workbench).getDefaultPageInput();
                workbench.openWorkbenchWindow(desc.getId(), input);
            }
            catch (WorkbenchException e) {
                this.handleWorkbenchException(e);
            }
        } else if (page != null) {
            page.setPerspective(desc);
        } else {
            try {
                IWorkbench workbench = this.window.getWorkbench();
                IAdaptable input = ((Workbench)workbench).getDefaultPageInput();
                this.window.openPage(desc.getId(), input);
            }
            catch (WorkbenchException e) {
                this.handleWorkbenchException(e);
            }
        }
    }

    private void handleWorkbenchException(WorkbenchException e) {
        ErrorDialog.openError((Shell)this.window.getShell(), (String)WorkbenchMessages.ChangeToPerspectiveMenu_errorTitle, (String)e.getMessage(), (IStatus)e.getStatus());
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

