/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.editor;

import com.clustercontrol.bean.Property;
import com.clustercontrol.editor.PropertyDefine;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.TimeTo48hConverter;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TextCellEditor;

public class TimePropertyDefine
extends PropertyDefine
implements Serializable {
    private static final long serialVersionUID = 4970684702759585048L;

    public TimePropertyDefine() {
        this.m_cellEditor = new TextCellEditor();
    }

    @Override
    public String getColumnText(Object value) {
        if (value instanceof Date) {
            Date dateValue = (Date)value;
            return TimeTo48hConverter.dateTo48hms(dateValue);
        }
        return "";
    }

    @Override
    public Object getValue(Property element) {
        Object value = element.getValue();
        if (value instanceof Date) {
            Date dateValue = (Date)value;
            return TimeTo48hConverter.dateTo48hms(dateValue);
        }
        return "";
    }

    @Override
    public void modify(Property element, Object value) {
        boolean check = false;
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date date = null;
        try {
            date = formatter.parse((String)value);
            check = true;
        }
        catch (ParseException parseException) {
            formatter = new SimpleDateFormat("HH:mm:ss");
            try {
                date = formatter.parse((String)value);
                check = true;
            }
            catch (ParseException parseException2) {}
        }
        if (check) {
            element.setValue(date);
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.hinemos.6"));
        }
    }

    @Override
    public void initEditer() {
    }
}

