/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.custom.dialog;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.composite.TextWithParameterComposite;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.monitor.run.dialog.CommonMonitorNumericDialog;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.repository.FacilityPath;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.CommandExecType;
import com.clustercontrol.ws.monitor.CustomCheckInfo;
import com.clustercontrol.ws.monitor.MonitorDuplicate_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MonitorCustomDialog
extends CommonMonitorNumericDialog {
    private static Log m_log = LogFactory.getLog(MonitorCustomDialog.class);
    private Text m_textTimeout = null;
    private Button checkSelected = null;
    private Text textNode = null;
    private Button buttonNode = null;
    private Button buttonAgentUser = null;
    private Button buttonSpecifyUser = null;
    private Text textEffectiveUser = null;
    private TextWithParameterComposite textCommand = null;
    private String nodeFacilityId = null;
    public static final int TIMEOUT_SEC_COMMAND = 15000;

    public MonitorCustomDialog(Shell parent) {
        super(parent);
    }

    public MonitorCustomDialog(Shell parent, String monitorId, boolean updateFlg) {
        super(parent);
        this.monitorId = monitorId;
        this.updateFlg = updateFlg;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Label label = null;
        GridData gridData = null;
        this.item1 = Messages.getString((String)"select.value");
        this.item2 = Messages.getString((String)"select.value");
        super.customizeDialog(parent);
        this.shell.setText(Messages.getString((String)"dialog.monitor.custom.edit"));
        Group groupCheckRule = new Group((Composite)this.groupRule, 0);
        groupCheckRule.setText(Messages.getString((String)"check.rule"));
        GridLayout layout = new GridLayout(15, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 15;
        groupCheckRule.setLayoutData((Object)gridData);
        this.checkSelected = new Button((Composite)groupCheckRule, 32);
        this.checkSelected.setText(Messages.getString((String)"monitor.custom.type.selected"));
        this.checkSelected.setToolTipText(Messages.getString((String)"monitor.custom.type.selected.tips"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 8;
        this.checkSelected.setLayoutData((Object)gridData);
        this.checkSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    MonitorCustomDialog.this.textNode.setEnabled(true);
                    MonitorCustomDialog.this.buttonNode.setEnabled(true);
                } else {
                    MonitorCustomDialog.this.textNode.setEnabled(false);
                    MonitorCustomDialog.this.buttonNode.setEnabled(false);
                }
                MonitorCustomDialog.this.update();
            }
        });
        this.textNode = new Text((Composite)groupCheckRule, 0x1000808);
        this.textNode.setText("");
        this.textNode.setMessage(Messages.getString((String)"monitor.custom.node.selected"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        this.textNode.setLayoutData((Object)gridData);
        this.textNode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MonitorCustomDialog.this.update();
            }
        });
        this.buttonNode = new Button((Composite)groupCheckRule, 0);
        this.buttonNode.setText(Messages.getString((String)"refer"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.buttonNode.setLayoutData((Object)gridData);
        this.buttonNode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ScopeTreeDialog dialog = new ScopeTreeDialog(shell, MonitorCustomDialog.this.getMonitorBasicScope().getOwnerRoleId(), false, false);
                dialog.setSelectNodeOnly(true);
                if (dialog.open() == 0) {
                    FacilityTreeItem item = dialog.getSelectItem();
                    FacilityInfo info = item.getData();
                    MonitorCustomDialog.this.nodeFacilityId = info.getFacilityId();
                    if (info.getFacilityType() == 1) {
                        MonitorCustomDialog.this.textNode.setText(info.getFacilityName());
                    } else {
                        FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                        MonitorCustomDialog.this.textNode.setText(path.getPath(item));
                    }
                }
            }
        });
        Group groupEffectiveUser = new Group((Composite)groupCheckRule, 0);
        groupEffectiveUser.setText(Messages.getString((String)"effective.user"));
        layout = new GridLayout(15, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        groupEffectiveUser.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 15;
        groupEffectiveUser.setLayoutData((Object)gridData);
        this.buttonAgentUser = new Button((Composite)groupEffectiveUser, 16);
        this.buttonAgentUser.setText(Messages.getString((String)"agent.user"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 15;
        this.buttonAgentUser.setLayoutData((Object)gridData);
        this.buttonAgentUser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    MonitorCustomDialog.this.buttonSpecifyUser.setSelection(false);
                    MonitorCustomDialog.this.textEffectiveUser.setEnabled(false);
                }
                MonitorCustomDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.buttonSpecifyUser = new Button((Composite)groupEffectiveUser, 16);
        this.buttonSpecifyUser.setText(Messages.getString((String)"specified.user"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.buttonSpecifyUser.setLayoutData((Object)gridData);
        this.buttonSpecifyUser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    MonitorCustomDialog.this.buttonAgentUser.setSelection(false);
                    MonitorCustomDialog.this.textEffectiveUser.setEnabled(true);
                }
                MonitorCustomDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.textEffectiveUser = new Text((Composite)groupEffectiveUser, 18432);
        this.textEffectiveUser.setText("");
        gridData = new GridData(768);
        gridData.horizontalSpan = 11;
        this.textEffectiveUser.setLayoutData((Object)gridData);
        this.textEffectiveUser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MonitorCustomDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData(768);
        label.setText(String.valueOf(Messages.getString((String)"monitor.custom.command")) + " : ");
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.textCommand = new TextWithParameterComposite((Composite)groupCheckRule, 18436);
        this.textCommand.setText("");
        this.textCommand.setToolTipText(Messages.getString((String)"monitor.custom.commandline.tips"));
        this.textCommand.setColor(new Color((Device)parent.getDisplay(), new RGB(0, 0, 255)));
        gridData = new GridData(768);
        gridData.horizontalSpan = 11;
        this.textCommand.setLayoutData(gridData);
        this.textCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MonitorCustomDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"time.out")) + " : ");
        this.m_textTimeout = new Text((Composite)groupCheckRule, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textTimeout.setLayoutData((Object)gridData);
        this.m_textTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MonitorCustomDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"milli.sec"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.adjustDialog();
        MonitorInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorInfo();
            this.setInfoInitialValue(info);
        } else {
            try {
                info = MonitorSettingEndpointWrapper.getMonitor(this.monitorId, "MON_CUSTOM");
            }
            catch (com.clustercontrol.ws.monitor.InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("customizeDialog() getMonitor, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        this.setInputData(info);
        this.update();
    }

    @Override
    public void update() {
        super.update();
        if (this.checkSelected.getSelection() && "".equals(this.textNode.getText())) {
            this.textNode.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textNode.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.buttonSpecifyUser.getSelection() && "".equals(this.textEffectiveUser.getText())) {
            this.textEffectiveUser.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textEffectiveUser.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.textCommand.getText())) {
            this.textCommand.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_textTimeout.getEnabled() && "".equals(this.m_textTimeout.getText())) {
            this.m_textTimeout.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textTimeout.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    protected void setInputData(MonitorInfo monitor) {
        super.setInputData(monitor);
        this.inputData = monitor;
        CustomCheckInfo customInfo = monitor.getCustomCheckInfo();
        if (customInfo == null) {
            customInfo = new CustomCheckInfo();
            customInfo.setTimeout(Integer.valueOf(15000));
            this.checkSelected.setSelection(false);
            this.textNode.setEnabled(false);
            this.buttonNode.setEnabled(false);
            this.buttonAgentUser.setSelection(true);
            this.buttonSpecifyUser.setSelection(false);
            this.textEffectiveUser.setEnabled(false);
        } else {
            if (customInfo.getCommandExecType() == CommandExecType.INDIVIDUAL) {
                this.checkSelected.setSelection(false);
            } else {
                this.checkSelected.setSelection(true);
                this.nodeFacilityId = customInfo.getSelectedFacilityId();
                String facilityPath = null;
                try {
                    facilityPath = RepositoryEndpointWrapper.getFacilityPath(this.nodeFacilityId, null);
                }
                catch (InvalidRole_Exception invalidRole_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
                catch (Exception e) {
                    m_log.warn((Object)("setInputData() getFacilityPath, " + e.getMessage()), (Throwable)e);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
                this.textNode.setText(facilityPath);
            }
            if (customInfo.getSpecifyUser() == 1) {
                this.buttonAgentUser.setSelection(false);
                this.buttonSpecifyUser.setSelection(true);
                this.textEffectiveUser.setEnabled(true);
            } else {
                this.buttonAgentUser.setSelection(true);
                this.buttonSpecifyUser.setSelection(false);
                this.textEffectiveUser.setEnabled(false);
            }
            this.textEffectiveUser.setText(customInfo.getEffectiveUser());
            this.textCommand.setText(customInfo.getCommand());
        }
        this.m_textTimeout.setText(Integer.toString(customInfo.getTimeout()));
        this.m_numericValueInfo.setInputData(monitor);
    }

    @Override
    protected MonitorInfo createInputData() {
        CustomCheckInfo customInfo = null;
        super.createInputData();
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setMonitorTypeId("MON_CUSTOM");
        customInfo = new CustomCheckInfo();
        customInfo.setTimeout(Integer.valueOf(15000));
        customInfo.setMonitorTypeId("MON_CUSTOM");
        customInfo.setMonitorId(this.monitorInfo.getMonitorId());
        this.monitorInfo.setCustomCheckInfo(customInfo);
        if (!this.checkSelected.getSelection()) {
            customInfo.setCommandExecType(CommandExecType.INDIVIDUAL);
        } else {
            customInfo.setCommandExecType(CommandExecType.SELECTED);
            customInfo.setSelectedFacilityId(this.nodeFacilityId);
        }
        if (this.buttonSpecifyUser.getSelection()) {
            customInfo.setSpecifyUser(Integer.valueOf(1));
        } else {
            customInfo.setSpecifyUser(Integer.valueOf(0));
        }
        customInfo.setEffectiveUser(this.textEffectiveUser.getText());
        customInfo.setCommand(this.textCommand.getText());
        try {
            customInfo.setTimeout(Integer.valueOf(Integer.parseInt(this.m_textTimeout.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.custom.msg.timeout.invalid"));
            return null;
        }
        this.validateResult = this.m_numericValueInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_CUSTOM", (String)this.monitorInfo.getMonitorId()));
        this.validateResult = this.m_notifyInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            if (this.validateResult.getID() == null) {
                if (!this.displayQuestion(this.validateResult)) {
                    this.validateResult = null;
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.monitorInfo;
    }

    @Override
    protected boolean action() {
        boolean result;
        block14: {
            result = false;
            MonitorInfo info = this.inputData;
            if (info != null) {
                Object[] args = new String[]{info.getMonitorId()};
                if (!this.updateFlg) {
                    try {
                        result = MonitorSettingEndpointWrapper.addMonitor(info);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.33", (Object[])args));
                            break block14;
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.34", (Object[])args));
                    }
                    catch (MonitorDuplicate_Exception monitorDuplicate_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.53", (Object[])args));
                    }
                    catch (Exception e) {
                        String errMessage = "";
                        if (e instanceof com.clustercontrol.ws.monitor.InvalidRole_Exception) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        } else {
                            errMessage = ", " + e.getMessage();
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.34", (Object[])args)) + errMessage));
                    }
                } else {
                    String errMessage = "";
                    try {
                        result = MonitorSettingEndpointWrapper.modifyMonitor(info);
                    }
                    catch (com.clustercontrol.ws.monitor.InvalidRole_Exception invalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    catch (Exception e) {
                        errMessage = ", " + e.getMessage();
                    }
                    if (result) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.35", (Object[])args));
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.36", (Object[])args)) + errMessage));
                    }
                }
            }
        }
        return result;
    }
}

