/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class StyledTextComposite
extends Composite {
    private StyledText textCanvas;
    private String[] keywords;
    private Color color;
    private Color okColor;
    private Color ngColor;

    public StyledTextComposite(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.textCanvas = new StyledText((Composite)this, style);
        this.okColor = new Color((Device)parent.getDisplay(), new RGB(255, 255, 255));
        this.ngColor = parent.getBackground();
        this.textCanvas.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                if (StyledTextComposite.this.keywords == null) {
                    return;
                }
                String lineText = event.lineText;
                ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
                TreeMap<Integer, Integer> paramPtr = new TreeMap<Integer, Integer>();
                int i = 0;
                while (i < StyledTextComposite.this.keywords.length) {
                    int index = 0;
                    int fromIndex = 0;
                    String keyword = StyledTextComposite.this.keywords[i];
                    while ((index = lineText.indexOf(keyword, fromIndex)) != -1) {
                        paramPtr.put(event.lineOffset + index, keyword.length());
                        fromIndex = index + keyword.length();
                    }
                    ++i;
                }
                for (Integer key : paramPtr.keySet()) {
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = key;
                    styleRange.length = (Integer)paramPtr.get(key);
                    styleRange.foreground = StyledTextComposite.this.color;
                    styleRanges.add(styleRange);
                }
                event.styles = styleRanges.toArray(new StyleRange[styleRanges.size()]);
            }
        });
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public String getText() {
        return this.textCanvas.getText();
    }

    public void setText(String text) {
        this.textCanvas.setText(text);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void addVerifyListener(VerifyListener listener) {
        this.textCanvas.addVerifyListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.textCanvas.addModifyListener(listener);
    }

    public void setInputUpper(int upper) {
        this.textCanvas.addVerifyListener((VerifyListener)new StringVerifyListener(upper));
    }

    public void setEnabled(boolean enable) {
        this.textCanvas.setEditable(enable);
        if (enable) {
            this.textCanvas.setBackground(this.okColor);
        } else {
            this.textCanvas.setBackground(this.ngColor);
        }
    }

    public void setBackground(Color color) {
        this.textCanvas.setBackground(color);
    }

    private class StringVerifyListener
    implements VerifyListener {
        private Integer length;

        public StringVerifyListener(int length) {
            this.length = new Integer(length);
        }

        public void verifyText(VerifyEvent e) {
            StyledText text = (StyledText)e.getSource();
            StringBuilder input = new StringBuilder(text.getText());
            if (e.keyCode == 0) {
                input.replace(e.start, e.end, e.text);
            } else if (e.character == '\b' || e.character == '\u007f') {
                input.delete(e.start, e.end);
            } else {
                input.replace(e.start, e.end, e.text);
            }
            if (input.toString().indexOf(10) != -1) {
                e.doit = false;
                return;
            }
            this.checkLength(e, input.toString());
        }

        private void checkLength(VerifyEvent e, String inputText) {
            if (inputText.length() > this.length) {
                e.doit = false;
                Object[] args = new String[]{this.length.toString()};
                MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.hinemos.7", (Object[])args));
            }
        }
    }
}

