/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RoleIdListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(RoleIdListComposite.class);
    private Combo comboRoleId = null;
    private Text txtRoleId = null;
    private boolean m_enabledFlg = false;
    private Mode m_mode = Mode.OWNER_ROLE;

    public RoleIdListComposite(Composite parent, int style, boolean enabledFlg, Mode mode) {
        super(parent, style);
        this.m_enabledFlg = enabledFlg;
        this.m_mode = mode;
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        if (this.m_enabledFlg) {
            this.comboRoleId = new Combo((Composite)this, 12);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.comboRoleId.setLayoutData((Object)gridData);
        } else {
            this.txtRoleId = new Text((Composite)this, 18432);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.txtRoleId.setLayoutData((Object)gridData);
            this.txtRoleId.setEnabled(false);
        }
        if (this.m_enabledFlg) {
            this.createRoleIdList();
            this.update();
            if (this.m_mode.equals((Object)Mode.OWNER_ROLE)) {
                this.comboRoleId.select(this.comboRoleId.indexOf("ALL_USERS"));
            }
        }
    }

    private void createRoleIdList() {
        List<String> list = null;
        try {
            list = AccessEndpointWrapper.getOwnerRoleIdList();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (list != null) {
            this.comboRoleId.removeAll();
            if (this.m_mode.equals((Object)Mode.ROLE)) {
                this.comboRoleId.add("");
            }
            for (String calendarId : list) {
                this.comboRoleId.add(calendarId);
            }
        }
    }

    public void update() {
        this.comboRoleId.select(0);
    }

    public void setEnabled(boolean enabled) {
        if (this.m_enabledFlg) {
            this.comboRoleId.setEnabled(enabled);
        }
    }

    public String getText() {
        if (this.m_enabledFlg) {
            return this.comboRoleId.getText();
        }
        return this.txtRoleId.getText();
    }

    public void setText(String string) {
        if (this.m_enabledFlg) {
            this.comboRoleId.setText(string);
        } else {
            this.txtRoleId.setText(string);
        }
    }

    public Combo getComboRoleId() {
        return this.comboRoleId;
    }

    public void add(String roleId) {
        this.comboRoleId.add(roleId);
        this.update();
    }

    public void delete(String roleId) {
        if (this.comboRoleId.indexOf(roleId) > -1) {
            this.comboRoleId.remove(roleId);
            this.update();
        }
    }

    public static enum Mode {
        OWNER_ROLE,
        ROLE;

    }
}

