/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite.action;

import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class BaseTreeItemSelectionListener
implements SelectionListener {
    protected TreeComposite composite;

    public BaseTreeItemSelectionListener(TreeComposite composite) {
        this.composite = composite;
    }

    public void widgetSelected(SelectionEvent event) {
    }

    protected boolean checkCreateItem() {
        if (this.composite.getCreateItem() != null) {
            TreeItem createItem = this.composite.getCreateItem();
            TreeItem parent = createItem.getParent();
            Object[] args = new Object[]{this.getInfo(createItem).getName()};
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.collective.run.8", (Object[])args))) {
                TreeItemUtil.removeChildren(parent, createItem);
                this.composite.setCreateItem(null);
                this.composite.setUpdateItem(null);
                this.composite.getTreeViewer().refresh((Object)parent);
            }
            return false;
        }
        return true;
    }

    protected boolean checkUpdateItem() {
        TreeItem selectItem = this.composite.getSelectItem();
        if (this.composite.getUpdateItem() != null) {
            TreeItem updateItem = this.composite.getUpdateItem();
            Object[] args = new Object[]{this.getInfo(updateItem).getName()};
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.collective.run.9", (Object[])args))) {
                this.composite.setUpdateItem(null);
                this.composite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)selectItem), true);
            }
            return false;
        }
        return true;
    }

    private ItemInfo getInfo(TreeItem item) {
        if (item.getCommandInfo() != null) {
            return item.getCommandInfo();
        }
        if (item.getCommandParameterInfo() != null) {
            return item.getCommandParameterInfo();
        }
        if (item.getParameterInfo() != null) {
            return item.getParameterInfo();
        }
        if (item.getParameterSelectInfo() != null) {
            return item.getParameterSelectInfo();
        }
        if (item.getTypeInfo() != null) {
            return item.getTypeInfo();
        }
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

