/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.collectiverun.action.GetDetailTableDefine;
import com.clustercontrol.collectiverun.util.CollectiveRunEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.collectiverun.DetailInfo;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DetailComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(DetailComposite.class);
    private CommonTableViewer m_viewer = null;
    private String m_sessionId = null;
    private Label m_sessionIdLabel = null;

    public DetailComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_sessionIdLabel = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.m_sessionIdLabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetDetailTableDefine.get(), GetDetailTableDefine.SORT_COLUMN_INDEX, GetDetailTableDefine.SORT_ORDER);
        this.update(null);
    }

    public void update(String sessionId) {
        List<Object> list = null;
        if (sessionId != null && sessionId.length() > 0) {
            try {
                list = CollectiveRunEndpointWrapper.getDetailList(sessionId);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList listInput = new ArrayList();
        for (DetailInfo detailInfo : list) {
            ArrayList<Object> obj = new ArrayList<Object>();
            obj.add(detailInfo.getStatus());
            obj.add(detailInfo.getEndStatus());
            obj.add(detailInfo.getEndValue());
            obj.add(detailInfo.getFacilityId());
            obj.add(detailInfo.getFacilityName());
            if (detailInfo.getStartDate() != null) {
                obj.add(new Date(detailInfo.getStartDate()));
            } else {
                obj.add("");
            }
            if (detailInfo.getEndDate() != null) {
                obj.add(new Date(detailInfo.getEndDate()));
            } else {
                obj.add("");
            }
            obj.add(detailInfo.getMessage());
            listInput.add(obj);
        }
        this.m_viewer.setInput(listInput);
        this.m_sessionId = sessionId;
        if (this.m_sessionId != null) {
            this.m_sessionIdLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : " + this.m_sessionId);
        } else {
            this.m_sessionIdLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : ");
        }
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }
}

