/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.util;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.ws.calendar.CalendarDetailInfo;
import com.clustercontrol.ws.calendar.CalendarDuplicate_Exception;
import com.clustercontrol.ws.calendar.CalendarEndpoint;
import com.clustercontrol.ws.calendar.CalendarInfo;
import com.clustercontrol.ws.calendar.CalendarNotFound_Exception;
import com.clustercontrol.ws.calendar.CalendarPatternInfo;
import com.clustercontrol.ws.calendar.HinemosUnknown_Exception;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;
import com.clustercontrol.ws.calendar.InvalidSetting_Exception;
import com.clustercontrol.ws.calendar.InvalidUserPass_Exception;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarEndpointWrapper {
    private static Log m_log = LogFactory.getLog(CalendarEndpointWrapper.class);

    public static CalendarInfo getCalendar(String id) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                return endpoint.getCalendar(id);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCalendar(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void addCalendar(CalendarInfo calendarInfo) throws CalendarDuplicate_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                endpoint.addCalendar(calendarInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("addCalendar(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void modifyCalendar(CalendarInfo calendarInfo) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                endpoint.modifyCalendar(calendarInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("modifyCalendar(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void deleteCalendar(String uid) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                endpoint.deleteCalendar(uid);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("deleteCalendar(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<CalendarInfo> getAllCalendarList() throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                return endpoint.getAllCalendarList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getAllCalendarList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<CalendarInfo> getCalendarList(String ownerRoleId) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                return endpoint.getCalendarList(ownerRoleId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCalendarListByOwnerRole(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<Integer> getCalendarMonth(String id, Integer year, Integer month) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                return endpoint.getCalendarMonth(id, year, month);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCalendarMonth(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<CalendarDetailInfo> getCalendarWeek(String id, Integer year, Integer month, Integer day) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                List list = endpoint.getCalendarWeek(id, year, month, day);
                return list;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCalendarWeek(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<CalendarPatternInfo> getCalendarPatternList(String ownerRoleId) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                return endpoint.getCalendarPatternList(ownerRoleId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCalendarPatternList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static CalendarPatternInfo getCalendarPattern(String id) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                return endpoint.getCalendarPattern(id);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCalendarPattern(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void addCalendarPattern(CalendarPatternInfo info) throws CalendarDuplicate_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception, CalendarNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                endpoint.addCalendarPattern(info);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("addCalendarPattern(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void modifyCalendarPattern(CalendarPatternInfo info) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                endpoint.modifyCalendarPattern(info);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("modifyCalendarPattern(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void deleteCalendarPattern(String id) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
            try {
                CalendarEndpoint endpoint = (CalendarEndpoint)endpointSetting.getEndpoint();
                endpoint.deleteCalendarPattern(id);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("deleteCalendarPattern(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }
}

