/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.calendar.action.AddCalendar;
import com.clustercontrol.calendar.action.GetCalendar;
import com.clustercontrol.calendar.action.ModifyCalendar;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.CalendarPatternInfo;
import com.clustercontrol.ws.calendar.Ymd;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.vafada.swtcalendar.SWTCalendar;
import org.vafada.swtcalendar.SWTCalendarEvent;
import org.vafada.swtcalendar.SWTCalendarListener;

public class CalendarPatternDialog
extends CommonDialog {
    private Shell shell = null;
    private SWTCalendar swtcal = null;
    private Text txtID = null;
    private Text txtName = null;
    private List dateViewSWTList = null;
    private ArrayList<Ymd> m_ymdList;
    private CalendarPatternInfo inputData = null;
    private String id = "";
    private int mode;
    private Date dateBefore;
    private Date date;
    private RoleIdListComposite m_ownerRoleId = null;

    public CalendarPatternDialog(Shell parent) {
        super(parent);
    }

    public CalendarPatternDialog(Shell parent, String id, int mode) {
        super(parent);
        this.id = id;
        this.mode = mode;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.shell = this.getShell();
        this.shell.setText(Messages.getString((String)"dialog.calendar.pattern.create.modify"));
        GridData gridData = new GridData();
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 20;
        layout.marginHeight = 10;
        layout.numColumns = 12;
        parent.setLayout((Layout)layout);
        Label lblId = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblId.setLayoutData((Object)gridData);
        lblId.setText(String.valueOf(Messages.getString((String)"calendar.pattern.id")) + " : ");
        this.txtID = new Text(parent, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtID.setLayoutData((Object)gridData);
        this.txtID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarPatternDialog.this.update();
            }
        });
        Label label = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText("");
        Label lblName = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblName.setLayoutData((Object)gridData);
        lblName.setText(String.valueOf(Messages.getString((String)"calendar.pattern.name")) + " : ");
        this.txtName = new Text(parent, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtName.setLayoutData((Object)gridData);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarPatternDialog.this.update();
            }
        });
        label = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText("");
        Label labelRoleId = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelRoleId.setLayoutData((Object)gridData);
        labelRoleId.setText(String.valueOf(Messages.getString((String)"owner.role.id")) + " : ");
        this.m_ownerRoleId = this.mode == 0 || this.mode == 3 ? new RoleIdListComposite(parent, 0, true, RoleIdListComposite.Mode.OWNER_ROLE) : new RoleIdListComposite(parent, 0, false, RoleIdListComposite.Mode.OWNER_ROLE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_ownerRoleId.setLayoutData(gridData);
        Group groupEtc = new Group(parent, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 12;
        layout = new GridLayout(12, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        groupEtc.setLayout((Layout)layout);
        groupEtc.setLayoutData((Object)gridData);
        groupEtc.setText(Messages.getString((String)"calendar.pattern.setting"));
        this.swtcal = new SWTCalendar((Composite)groupEtc);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        gridData.verticalSpan = 2;
        this.swtcal.setLayoutData(gridData);
        this.swtcal.addSWTCalendarListener(new SWTCalendarListener(){

            @Override
            public void dateChanged(SWTCalendarEvent event) {
                Date dateBuffer = event.getCalendar().getTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                String selectDate = sdf.format(dateBuffer);
                String[] selectYmd = selectDate.split("/");
                Ymd selectDay = new Ymd();
                selectDay.setYear(Integer.valueOf(Integer.parseInt(selectYmd[0])));
                selectDay.setMonth(Integer.valueOf(Integer.parseInt(selectYmd[1])));
                selectDay.setDay(Integer.valueOf(Integer.parseInt(selectYmd[2])));
                Boolean flag = false;
                Ymd delYMD = new Ymd();
                for (Ymd ymd : CalendarPatternDialog.this.m_ymdList) {
                    if (!CalendarPatternDialog.this.equalsYmd(ymd, selectDay)) continue;
                    flag = true;
                    delYMD = ymd;
                    break;
                }
                if (flag.booleanValue()) {
                    CalendarPatternDialog.this.m_ymdList.remove(delYMD);
                } else {
                    CalendarPatternDialog.this.m_ymdList.add(selectDay);
                }
                Collections.sort(CalendarPatternDialog.this.m_ymdList, new Comparator<Ymd>(){

                    @Override
                    public int compare(Ymd y1, Ymd y2) {
                        int ymd1 = y1.getYear() * 10000 + y1.getMonth() * 100 + y1.getDay();
                        int ymd2 = y2.getYear() * 10000 + y2.getMonth() * 100 + y2.getDay();
                        return ymd1 - ymd2;
                    }
                });
                CalendarPatternDialog.this.dateViewSWTList.removeAll();
                for (Ymd ymd : CalendarPatternDialog.this.m_ymdList) {
                    CalendarPatternDialog.this.dateViewSWTList.add(CalendarPatternDialog.this.yyyyMMdd(ymd));
                }
                CalendarPatternDialog.this.update();
            }
        });
        this.swtcal.updateCalendar(this.m_ymdList);
        Label lbl = new Label((Composite)groupEtc, 0x1000000);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.verticalSpan = 1;
        lbl.setLayoutData((Object)gridData);
        lbl.setText(" " + Messages.getString((String)"calendar.pattern.record.date"));
        this.dateViewSWTList = new List((Composite)groupEtc, 2562);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        gridData.verticalSpan = 1;
        this.dateViewSWTList.setLayoutData((Object)gridData);
        this.adjustDialog();
        this.reflectCalendar();
        this.update();
    }

    private void adjustDialog() {
        this.shell.pack();
        this.shell.setSize(new Point(420, this.shell.getSize().y));
        Display display = this.shell.getDisplay();
        this.shell.setLocation((display.getBounds().width - this.shell.getSize().x) / 2, (display.getBounds().height - this.shell.getSize().y) / 2);
    }

    private boolean equalsYmd(Ymd y1, Ymd y2) {
        return y1.getYear().equals(y2.getYear()) && y1.getMonth().equals(y2.getMonth()) && y1.getDay().equals(y2.getDay());
    }

    private String yyyyMMdd(Ymd ymd) {
        return ymd.getYear() + "/" + ymd.getMonth() + "/" + ymd.getDay();
    }

    private void update() {
        if ("".equals(this.txtID.getText())) {
            this.txtID.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtID.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtName.getText())) {
            this.txtName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        this.swtcal.updateCalendar(this.m_ymdList);
    }

    private void reflectCalendar() {
        CalendarPatternInfo info = null;
        info = this.mode == 1 || this.mode == 3 ? new GetCalendar().getCalendarPattern(this.id) : new CalendarPatternInfo();
        this.inputData = info;
        this.m_ymdList = new ArrayList();
        if (info != null) {
            if (info.getId() != null) {
                this.id = info.getId();
                this.txtID.setText(info.getId());
                if (this.mode == 1) {
                    this.txtID.setEnabled(false);
                }
            }
            if (info.getName() != null) {
                this.txtName.setText(info.getName());
            }
            if (info.getYmd() != null) {
                for (Ymd ymd : info.getYmd()) {
                    this.m_ymdList = (ArrayList)info.getYmd();
                    this.dateViewSWTList.add(this.yyyyMMdd(ymd));
                }
            } else {
                this.m_ymdList = new ArrayList();
            }
        }
        if (this.inputData.getOwnerRoleId() != null) {
            this.m_ownerRoleId.setText(this.inputData.getOwnerRoleId());
        }
        this.update();
    }

    private ValidateResult createCalendarIrregularInfo() {
        ValidateResult result = null;
        Long regDate = this.inputData.getRegDate();
        String regUser = this.inputData.getRegUser();
        this.inputData = new CalendarPatternInfo();
        if (this.txtID.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"calendar.pattern.id"));
            return result;
        }
        this.inputData.setId(this.txtID.getText());
        if (this.txtName.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"calendar.pattern.name"));
            return result;
        }
        this.inputData.setName(this.txtName.getText());
        if (this.m_ymdList == null) {
            this.m_ymdList = new ArrayList();
        }
        for (Ymd ymd : this.m_ymdList) {
            this.inputData.getYmd().add(ymd);
        }
        this.inputData.setRegDate(regDate);
        this.inputData.setRegUser(regUser);
        if (this.m_ownerRoleId.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"owner.role.id"));
            return result;
        }
        this.inputData.setOwnerRoleId(this.m_ownerRoleId.getText());
        return result;
    }

    protected void cancelPressed() {
        this.date = this.dateBefore;
        super.cancelPressed();
    }

    @Override
    protected void okPressed() {
        this.date = this.swtcal.getCalendar().getTime();
        Calendar work = Calendar.getInstance();
        work.setTime(this.date);
        work.set(14, 0);
        this.date = work.getTime();
        super.okPressed();
    }

    @Override
    protected ValidateResult validate() {
        return null;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        this.createCalendarIrregularInfo();
        CalendarPatternInfo info = this.inputData;
        if (info != null) {
            if (this.mode == 0) {
                info = this.inputData;
                result = new AddCalendar().addCalendarPatternInfo(info);
            } else if (this.mode == 1) {
                info.setId(this.txtID.getText());
                result = new ModifyCalendar().modifyPatternInfo(info);
            } else if (this.mode == 3) {
                info.setId(this.txtID.getText());
                result = new AddCalendar().addCalendarPatternInfo(info);
            }
        }
        return result;
    }
}

