/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.composite;

import com.clustercontrol.calendar.composite.CalendarDetailListComposite;
import com.clustercontrol.calendar.dialog.CalendarDetailDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.CalendarDetailInfo;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CalendarDetailInfoComposite
extends Composite {
    private CalendarDetailListComposite m_infoListComposite = null;
    private Button m_buttonAdd = null;
    private Button m_buttonModify = null;
    private Button m_buttonDelete = null;
    private Button m_buttonUp = null;
    private Button m_buttonDown = null;

    public CalendarDetailInfoComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        this.m_infoListComposite = new CalendarDetailListComposite(this, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 13;
        this.m_infoListComposite.setLayoutData(gridData);
        Composite composite = new Composite((Composite)this, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        this.m_buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.m_buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                CalendarDetailDialog dialog = new CalendarDetailDialog(shell, CalendarDetailInfoComposite.this.m_infoListComposite.getOwnerRoleId());
                if (dialog.open() == 0) {
                    CalendarDetailInfoComposite.this.m_infoListComposite.getDetailList().add(dialog.getInputData());
                    CalendarDetailInfoComposite.this.m_infoListComposite.update();
                }
            }
        });
        this.m_buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.m_buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Integer order = CalendarDetailInfoComposite.this.m_infoListComposite.getSelection();
                if (order != null) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    CalendarDetailDialog dialog = new CalendarDetailDialog(shell, CalendarDetailInfoComposite.this.m_infoListComposite.getDetailList().get(order - 1), CalendarDetailInfoComposite.this.m_infoListComposite.getOwnerRoleId());
                    if (dialog.open() == 0) {
                        CalendarDetailInfoComposite.this.m_infoListComposite.getDetailList().remove(CalendarDetailInfoComposite.this.m_infoListComposite.getDetailList().get(order - 1));
                        CalendarDetailInfoComposite.this.m_infoListComposite.getDetailList().add(order - 1, dialog.getInputData());
                        CalendarDetailInfoComposite.this.m_infoListComposite.setSelection();
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.monitor.30"));
                }
            }
        });
        this.m_buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.m_buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Integer order = CalendarDetailInfoComposite.this.m_infoListComposite.getSelection();
                if (order != null) {
                    CalendarDetailInfoComposite.this.m_infoListComposite.getDetailList().remove(order - 1);
                    CalendarDetailInfoComposite.this.m_infoListComposite.update();
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.monitor.30"));
                }
            }
        });
        this.m_buttonUp = this.createButton(composite, Messages.getString((String)"up"));
        this.m_buttonUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Integer order = CalendarDetailInfoComposite.this.m_infoListComposite.getSelection();
                if (order != null) {
                    CalendarDetailInfoComposite.this.m_infoListComposite.up();
                    CalendarDetailInfoComposite.this.m_infoListComposite.update();
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.monitor.30"));
                }
            }
        });
        this.m_buttonDown = this.createButton(composite, Messages.getString((String)"down"));
        this.m_buttonDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Integer order = CalendarDetailInfoComposite.this.m_infoListComposite.getSelection();
                if (order != null) {
                    CalendarDetailInfoComposite.this.m_infoListComposite.down();
                    CalendarDetailInfoComposite.this.m_infoListComposite.update();
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.monitor.30"));
                }
            }
        });
    }

    public ArrayList<CalendarDetailInfo> getDetailList() {
        return this.m_infoListComposite.getDetailList();
    }

    public void setDetailList(ArrayList<CalendarDetailInfo> detailList) {
        if (detailList != null) {
            this.m_infoListComposite.setDetailList(detailList);
        }
        this.update();
    }

    public void setEnabled(boolean enabled) {
        this.m_infoListComposite.setEnabled(enabled);
        this.m_buttonAdd.setEnabled(enabled);
        this.m_buttonModify.setEnabled(enabled);
        this.m_buttonDelete.setEnabled(enabled);
        this.m_buttonUp.setEnabled(enabled);
        this.m_buttonDown.setEnabled(enabled);
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }

    public void setOwnerRoleId(String ownerRoleId) {
        this.m_infoListComposite.setOwnerRoleId(ownerRoleId);
    }

    public void changeOwnerRoleId(String ownerRoleId) {
        if (ownerRoleId == null || !ownerRoleId.equals(this.m_infoListComposite.getOwnerRoleId())) {
            for (CalendarDetailInfo composite : this.m_infoListComposite.getDetailList()) {
                composite.setCalPatternId(null);
                composite.setCalPatternInfo(null);
            }
        }
        this.setOwnerRoleId(ownerRoleId);
    }
}

