/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.view.action;

import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.accesscontrol.view.RoleListView;
import com.clustercontrol.accesscontrol.view.RoleSettingTreeView;
import com.clustercontrol.bean.PluginConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.UnEditableRole_Exception;
import com.clustercontrol.ws.access.UsedFacility_Exception;
import com.clustercontrol.ws.access.UsedOwnerRole_Exception;
import com.clustercontrol.ws.access.UsedRole_Exception;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class RoleDeleteAction
implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.accesscontrol.view.action.RoleDeleteAction";
    private IViewPart viewPart;

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public void run(IAction action) {
        RoleListView roleListView = (RoleListView)((Object)this.viewPart.getAdapter(RoleListView.class));
        StructuredSelection selection = (StructuredSelection)roleListView.getComposite().getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String roleId = null;
        if (list != null) {
            roleId = (String)list.get(0);
        }
        if (roleId != null) {
            Object[] args = new String[]{roleId};
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.accesscontrol.32", (Object[])args))) {
                Object[] errorArgs;
                try {
                    AccessEndpointWrapper.deleteRoleInfo(roleId);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.30"));
                }
                catch (UsedFacility_Exception e) {
                    errorArgs = new Object[]{roleId, PluginConstant.typeToString((int)e.getFaultInfo().getPlugin())};
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.repository.27", (Object[])errorArgs));
                }
                catch (UsedOwnerRole_Exception e) {
                    errorArgs = new Object[]{roleId, PluginConstant.typeToString((int)e.getFaultInfo().getPlugin())};
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.52", (Object[])errorArgs));
                }
                catch (Exception e) {
                    String errMessage = "";
                    if (e instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else if (e instanceof UsedRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.42"));
                    } else if (e instanceof UnEditableRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.41"));
                    } else {
                        errMessage = ", " + e.getMessage();
                    }
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.accesscontrol.31")) + errMessage));
                }
                roleListView.update();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart roleTreeViewPart = page.findView("com.clustercontrol.accesscontrol.view.RoleSettingTreeView");
                if (roleTreeViewPart != null) {
                    RoleSettingTreeView treeView = (RoleSettingTreeView)((Object)roleTreeViewPart.getAdapter(RoleSettingTreeView.class));
                    treeView.update();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

