/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.view;

import com.clustercontrol.accesscontrol.composite.RoleSettingTreeComposite;
import com.clustercontrol.accesscontrol.composite.action.RoleSettingTreeSelectionChangedListener;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.ws.access.RoleInfo;
import com.clustercontrol.ws.accesscontrol.RoleTreeItem;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class RoleSettingTreeView
extends CommonViewPart {
    public static final String ID = "com.clustercontrol.accesscontrol.view.RoleSettingTreeView";
    private RoleSettingTreeComposite m_tree = null;
    private RoleTreeItem m_copyTreeItem = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_tree = new RoleSettingTreeComposite(this, parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_tree.setLayoutData(gridData);
        this.m_tree.getTreeViewer().addSelectionChangedListener(new RoleSettingTreeSelectionChangedListener(this.m_tree));
        this.createContextMenu();
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RoleSettingTreeView.this.fillContextMenu(manager);
            }
        });
        Menu treeMenu = menuManager.createContextMenu((Control)this.m_tree.getTree());
        this.m_tree.getTree().setMenu(treeMenu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem assignUserAction = (ActionContributionItem)toolbar.find("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignUserAction");
        ActionContributionItem assignSystemPrivilegeAction = (ActionContributionItem)toolbar.find("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignSystemPrivilegeAction");
        manager.add(assignUserAction.getAction());
        manager.add(assignSystemPrivilegeAction.getAction());
    }

    public void update() {
        this.m_tree.update();
    }

    public void setEnabledAction(Object selectedInfo, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignUserAction", selection);
        super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignSystemPrivilegeAction", selection);
        if (selectedInfo instanceof RoleInfo && !((RoleInfo)selectedInfo).getId().equals("root")) {
            if (((RoleInfo)selectedInfo).getId().equals("ADMINISTRATORS")) {
                super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignUserAction", true);
                super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignSystemPrivilegeAction", false);
            } else if (((RoleInfo)selectedInfo).getId().equals("ALL_USERS")) {
                super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignUserAction", false);
                super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignSystemPrivilegeAction", true);
            } else {
                super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignUserAction", true);
                super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignSystemPrivilegeAction", true);
            }
        } else {
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignUserAction", false);
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleSettingAssignSystemPrivilegeAction", false);
        }
    }

    public RoleSettingTreeComposite getTreeComposite() {
        return this.m_tree;
    }

    public RoleTreeItem getSelectJobTreeItem() {
        return this.m_tree.getSelectItem();
    }
}

