/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.util;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.access.RoleInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RolePropertyUtil {
    private static Log m_log = LogFactory.getLog(RolePropertyUtil.class);
    public static final String ROLE_ID = "roleId";
    public static final String NAME = "namae";
    public static final String DESCRIPTION = "description";
    public static final String CREATE_TIME = "createTimestamp";
    public static final String CREATOR_NAME = "creatorName";
    public static final String MODIFIER_NAME = "modifierName";
    public static final String MODIFY_TIME = "modifyTime";
    private static final List<String> m_users = new ArrayList<String>();

    public static RoleInfo property2dto(Property property) {
        RoleInfo info = new RoleInfo();
        info.setCreateDate(Long.valueOf(0L));
        info.setModifyDate(Long.valueOf(0L));
        ArrayList object = null;
        object = PropertyUtil.getPropertyValue(property, ROLE_ID);
        if (object.size() > 0) {
            info.setId((String)object.get(0));
        }
        if ((object = PropertyUtil.getPropertyValue(property, NAME)).size() > 0) {
            info.setName((String)object.get(0));
        }
        if ((object = PropertyUtil.getPropertyValue(property, DESCRIPTION)).size() > 0) {
            info.setDescription((String)object.get(0));
        }
        if ((object = PropertyUtil.getPropertyValue(property, CREATOR_NAME)).size() > 0) {
            info.setCreateUserId((String)object.get(0));
        }
        if ((object = PropertyUtil.getPropertyValue(property, CREATE_TIME)).size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
            info.setCreateDate(Long.valueOf(((Date)object.get(0)).getTime()));
        }
        if ((object = PropertyUtil.getPropertyValue(property, MODIFIER_NAME)).size() > 0) {
            info.setModifyUserId((String)object.get(0));
        }
        if ((object = PropertyUtil.getPropertyValue(property, MODIFY_TIME)).size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
            info.setModifyDate(Long.valueOf(((Date)object.get(0)).getTime()));
        }
        return info;
    }

    public static Property dto2property(RoleInfo info, int mode, Locale locale) {
        Property property = RolePropertyUtil.getProperty(mode, locale);
        ArrayList<Property> propertyList = null;
        if (info != null) {
            propertyList = PropertyUtil.getProperty(property, ROLE_ID);
            propertyList.get(0).setValue(info.getId());
            propertyList = PropertyUtil.getProperty(property, NAME);
            if (info.getName() != null && info.getName().compareTo("") != 0) {
                propertyList.get(0).setValue(info.getName());
            }
            propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
            if (info.getDescription() != null && info.getDescription().compareTo("") != 0) {
                propertyList.get(0).setValue(info.getDescription());
            }
            propertyList = PropertyUtil.getProperty(property, CREATOR_NAME);
            if (info.getCreateUserId() != null && info.getCreateUserId().compareTo("") != 0) {
                propertyList.get(0).setValue(info.getCreateUserId());
            }
            propertyList = PropertyUtil.getProperty(property, CREATE_TIME);
            if (info.getCreateDate() != null) {
                propertyList.get(0).setValue(new Date(info.getCreateDate()));
            }
            propertyList = PropertyUtil.getProperty(property, MODIFIER_NAME);
            if (info.getModifyUserId() != null && info.getModifyUserId().compareTo("") != 0) {
                propertyList.get(0).setValue(info.getModifyUserId());
            }
            propertyList = PropertyUtil.getProperty(property, MODIFY_TIME);
            if (info.getModifyDate() != null) {
                propertyList.get(0).setValue(new Date(info.getModifyDate()));
            }
        }
        return property;
    }

    private static Property getProperty(int mode, Locale locale) {
        Property roleId = new Property(ROLE_ID, Messages.getString((String)"role.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT, 64);
        Property name = new Property(NAME, Messages.getString((String)"name", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT, 128);
        Property description = new Property(DESCRIPTION, Messages.getString((String)DESCRIPTION, (Locale)locale), PropertyDefineConstant.EDITOR_TEXT, 256);
        Property createTime = new Property(CREATE_TIME, Messages.getString((String)"create.time", (Locale)locale), PropertyDefineConstant.EDITOR_DATETIME);
        Property creatorName = new Property(CREATOR_NAME, Messages.getString((String)"creator.name", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        Property modifyTime = new Property(MODIFY_TIME, Messages.getString((String)"update.time", (Locale)locale), PropertyDefineConstant.EDITOR_DATETIME);
        Property modifierName = new Property(MODIFIER_NAME, Messages.getString((String)"modifier.name", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        roleId.setValue("");
        name.setValue("");
        description.setValue("");
        createTime.setValue("");
        creatorName.setValue("");
        modifyTime.setValue("");
        modifierName.setValue("");
        if (mode == 0) {
            roleId.setModify(1);
            name.setModify(1);
            description.setModify(1);
        } else if (mode == 1) {
            name.setModify(1);
            description.setModify(1);
        }
        Property property = new Property(null, null, "");
        property.removeChildren();
        property.addChildren(roleId);
        property.addChildren(name);
        property.addChildren(description);
        property.addChildren(createTime);
        property.addChildren(creatorName);
        property.addChildren(modifyTime);
        property.addChildren(modifierName);
        return property;
    }
}

