/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.util;

import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.accesscontrol.util.ObjectPrivilegeBean;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.ObjectPrivilegeFilterInfo;
import com.clustercontrol.ws.access.ObjectPrivilegeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

public class RoleObjectPrivilegeUtil {
    private static Log m_log = LogFactory.getLog(RoleObjectPrivilegeUtil.class);
    public static final String OBJECT_TYPE = "objectType";
    public static final String OBJECT_ID = "objectId";
    public static final String ROLE_ID = "roleId";
    public static final String OBJECT_PRIVILEGE = "objectPrivilege";
    public static final String CREATE_TIME = "createTime";
    public static final String CREATE_USER = "createUser";
    public static final String MODIFY_USER = "modifyUSER";
    public static final String MODIFY_TIME = "modifyTime";
    private static final List<String> m_users = new ArrayList<String>();

    public static List<ObjectPrivilegeInfo> beanList2dtoList(List<ObjectPrivilegeBean> beanList) {
        ArrayList<ObjectPrivilegeInfo> resultList = new ArrayList<ObjectPrivilegeInfo>();
        for (ObjectPrivilegeBean bean : beanList) {
            ObjectPrivilegeInfo info = null;
            if (bean.getReadPrivilege() || bean.getOwnerFlag()) {
                info = RoleObjectPrivilegeUtil.getCommon(bean);
                info.setObjectPrivilege(PrivilegeConstant.ObjectPrivilegeMode.READ.toString());
                resultList.add(info);
            }
            if (bean.getWritePrivilege()) {
                info = RoleObjectPrivilegeUtil.getCommon(bean);
                info.setObjectPrivilege(PrivilegeConstant.ObjectPrivilegeMode.WRITE.toString());
                resultList.add(info);
            }
            if (!bean.getExecPrivilege()) continue;
            info = RoleObjectPrivilegeUtil.getCommon(bean);
            info.setObjectPrivilege(PrivilegeConstant.ObjectPrivilegeMode.EXEC.toString());
            resultList.add(info);
        }
        return resultList;
    }

    public static List<ObjectPrivilegeInfo> beanMap2dtoList(HashMap<String, ObjectPrivilegeBean> beanMap) {
        ArrayList<ObjectPrivilegeInfo> resultList = new ArrayList<ObjectPrivilegeInfo>();
        ObjectPrivilegeBean bean = null;
        for (Map.Entry<String, ObjectPrivilegeBean> keyValue : beanMap.entrySet()) {
            ObjectPrivilegeInfo info;
            bean = keyValue.getValue();
            if (bean.getReadPrivilege()) {
                info = RoleObjectPrivilegeUtil.getCommon(bean);
                info.setObjectPrivilege(PrivilegeConstant.ObjectPrivilegeMode.READ.toString());
                resultList.add(info);
            }
            if (bean.getWritePrivilege()) {
                info = RoleObjectPrivilegeUtil.getCommon(bean);
                info.setObjectPrivilege(PrivilegeConstant.ObjectPrivilegeMode.WRITE.toString());
                resultList.add(info);
            }
            if (!bean.getExecPrivilege()) continue;
            info = RoleObjectPrivilegeUtil.getCommon(bean);
            info.setObjectPrivilege(PrivilegeConstant.ObjectPrivilegeMode.EXEC.toString());
            resultList.add(info);
        }
        return resultList;
    }

    private static ObjectPrivilegeInfo getCommon(ObjectPrivilegeBean bean) {
        ObjectPrivilegeInfo info = new ObjectPrivilegeInfo();
        info.setRoleId(bean.getRoleId());
        return info;
    }

    public static HashMap<String, ObjectPrivilegeBean> dto2beanMap(List<ObjectPrivilegeInfo> infoList) {
        HashMap<String, ObjectPrivilegeBean> resultMap = new HashMap<String, ObjectPrivilegeBean>();
        ObjectPrivilegeBean bean = null;
        if (infoList == null) {
            return null;
        }
        for (ObjectPrivilegeInfo info : infoList) {
            if (resultMap.get(info.getRoleId()) == null) {
                bean = new ObjectPrivilegeBean();
                bean.setRoleId(info.getRoleId());
                resultMap.put(info.getRoleId(), bean);
            } else {
                bean = resultMap.get(info.getRoleId());
            }
            if (info.getObjectPrivilege().equals(PrivilegeConstant.ObjectPrivilegeMode.READ.toString())) {
                bean.setReadPrivilege(true);
                continue;
            }
            if (info.getObjectPrivilege().equals(PrivilegeConstant.ObjectPrivilegeMode.WRITE.toString())) {
                bean.setWritePrivilege(true);
                continue;
            }
            if (!info.getObjectPrivilege().equals(PrivilegeConstant.ObjectPrivilegeMode.EXEC.toString())) continue;
            bean.setExecPrivilege(true);
        }
        return resultMap;
    }

    public static HashMap<String, ObjectPrivilegeBean> dto2beanMap(String objectId, String objectType) {
        List<ObjectPrivilegeInfo> objectPrivilegeList = null;
        ObjectPrivilegeFilterInfo filter = new ObjectPrivilegeFilterInfo();
        filter.setObjectId(objectId);
        filter.setObjectType(objectType);
        try {
            objectPrivilegeList = AccessEndpointWrapper.getObjectPrivilegeInfoList(filter);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("getOwnUserList(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return RoleObjectPrivilegeUtil.dto2beanMap(objectPrivilegeList);
    }
}

