/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.util;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.LoginManager;
import com.sun.xml.internal.ws.client.ClientTransportException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalSession {
    private static Log m_log = LogFactory.getLog(LoginManager.class);
    private static Timer m_timer = null;
    private static Date clientLastUpdate = null;
    public static int m_managerPollingInterval = 1;
    private static LocalSession m_instance = null;
    private static boolean dialogFlag = true;
    private static Object o = new Object();

    public static LocalSession getLocalSession() {
        if (m_instance == null) {
            m_instance = new LocalSession();
        }
        return m_instance;
    }

    private LocalSession() {
        clientLastUpdate = new Date(System.currentTimeMillis());
    }

    public static void clearSessionData() {
        FacilityTree.clearCache();
    }

    private static Date getClientLastUpdate() {
        return clientLastUpdate;
    }

    private static void setClientLastUpdate(Date lastUpdate) {
        clientLastUpdate = lastUpdate;
    }

    public void startChecktask(int interval) {
        if (m_timer == null && interval > 0) {
            m_timer = new Timer(true);
            m_timer.schedule((TimerTask)new SessionCheckTask(), interval * 60 * 1000, (long)(interval * 60 * 1000));
        }
    }

    public void restartChecktask(int interval) {
        this.stopChecktask();
        this.startChecktask(interval);
    }

    public void stopChecktask() {
        if (m_timer != null) {
            m_timer.cancel();
            m_timer = null;
        }
    }

    public static void doCheck() {
        if (!LoginManager.isLogin()) {
            return;
        }
        Date lastUpdate = null;
        try {
            lastUpdate = new Date(RepositoryEndpointWrapper.getLastUpdate());
        }
        catch (Exception e) {
            if (e instanceof ClientTransportException || e instanceof WebServiceException) {
                m_log.warn((Object)("LocalSession.doCheck() Manager is dead ! , " + e.getMessage()), (Throwable)e);
            } else {
                m_log.warn((Object)("LocalSession.doCheck() Manager is dead !! , " + e.getMessage()), (Throwable)e);
            }
            LoginManager.disconnectManager();
            return;
        }
        if (lastUpdate != null && LocalSession.getClientLastUpdate() != null && LocalSession.getClientLastUpdate().compareTo(lastUpdate) != 0) {
            m_log.debug((Object)"LocalSession.doCheck() update");
            LocalSession.setClientLastUpdate(lastUpdate);
            FacilityTree.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDialogFlag(boolean flag) {
        Object object = o;
        synchronized (object) {
            dialogFlag = flag;
        }
    }

    public static boolean isDialogFlag() {
        return dialogFlag;
    }

    private class SessionCheckTask
    extends TimerTask {
        private SessionCheckTask() {
        }

        @Override
        public void run() {
            LocalSession.doCheck();
        }
    }
}

