/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.util;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.ws.access.AccessEndpoint;
import com.clustercontrol.ws.access.FacilityDuplicate_Exception;
import com.clustercontrol.ws.access.FacilityNotFound_Exception;
import com.clustercontrol.ws.access.HinemosUnknown_Exception;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.InvalidSetting_Exception;
import com.clustercontrol.ws.access.InvalidUserPass_Exception;
import com.clustercontrol.ws.access.JobMasterNotFound_Exception;
import com.clustercontrol.ws.access.ObjectPrivilegeFilterInfo;
import com.clustercontrol.ws.access.ObjectPrivilegeInfo;
import com.clustercontrol.ws.access.PrivilegeDuplicate_Exception;
import com.clustercontrol.ws.access.RoleDuplicate_Exception;
import com.clustercontrol.ws.access.RoleInfo;
import com.clustercontrol.ws.access.RoleNotFound_Exception;
import com.clustercontrol.ws.access.SystemPrivilegeInfo;
import com.clustercontrol.ws.access.UnEditableRole_Exception;
import com.clustercontrol.ws.access.UnEditableUser_Exception;
import com.clustercontrol.ws.access.UsedFacility_Exception;
import com.clustercontrol.ws.access.UsedObjectPrivilege_Exception;
import com.clustercontrol.ws.access.UsedOwnerRole_Exception;
import com.clustercontrol.ws.access.UsedRole_Exception;
import com.clustercontrol.ws.access.UsedUser_Exception;
import com.clustercontrol.ws.access.UserDuplicate_Exception;
import com.clustercontrol.ws.access.UserInfo;
import com.clustercontrol.ws.access.UserNotFound_Exception;
import com.clustercontrol.ws.accesscontrol.RoleTreeItem;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessEndpointWrapper {
    private static Log m_log = LogFactory.getLog(AccessEndpointWrapper.class);

    public static void checkLogin() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            m_log.info((Object)("endpointSetting " + EndpointManager.getAccessEndpoint().size()));
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.checkLogin();
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("checkLogin(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static String getUserName() throws HinemosUnknown_Exception, UserNotFound_Exception, InvalidUserPass_Exception, InvalidRole_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getUserName();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getUserName(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static UserInfo getUserInfo(String userId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getUserInfo(userId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getUserInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static UserInfo getOwnUserInfo() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getOwnUserInfo();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getOwnUserInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<UserInfo> getUserInfoList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getUserInfoList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getUserInfoList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void addUserInfo(UserInfo userInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserDuplicate_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.addUserInfo(userInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("addUserInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void modifyUserInfo(UserInfo userInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception, InvalidSetting_Exception, UnEditableUser_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.modifyUserInfo(userInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("modifyUserInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void deleteUserInfo(String userId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception, UsedUser_Exception, UnEditableUser_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.deleteUserInfo(userId);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("deleteUserInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static boolean isPermission(SystemPrivilegeInfo systemPrivilegeInfo) throws HinemosUnknown_Exception, InvalidUserPass_Exception, InvalidRole_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.isPermission(systemPrivilegeInfo);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("isPermission(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void changeOwnPassword(String passwordHash) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.changeOwnPassword(passwordHash);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("changeOwnPassword(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void changePassword(String userId, String passwordHash) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.changePassword(userId, passwordHash);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("changePassword(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static String getVersion() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getVersion();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getVersion(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<RoleInfo> getRoleInfoList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getRoleInfoList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getRoleInfoList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static RoleInfo getRoleInfo(String roleId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getRoleInfo(roleId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getRoleInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void addRoleInfo(RoleInfo roleInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, RoleDuplicate_Exception, FacilityDuplicate_Exception, InvalidSetting_Exception, UnEditableRole_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.addRoleInfo(roleInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("addRoleInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void modifyRoleInfo(RoleInfo roleInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, RoleNotFound_Exception, FacilityNotFound_Exception, InvalidSetting_Exception, UnEditableRole_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.modifyRoleInfo(roleInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("modifyRoleInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void deleteRoleInfo(String roleId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, RoleNotFound_Exception, UsedFacility_Exception, FacilityNotFound_Exception, UnEditableRole_Exception, UsedRole_Exception, UsedOwnerRole_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.deleteRoleInfo(roleId);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("deleteRoleInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static RoleTreeItem getRoleTree() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                RoleTreeItem top = endpoint.getRoleTree();
                RoleTreeItem root = (RoleTreeItem)top.getChildren().get(0);
                root.setParent(top);
                List roleList = root.getChildren();
                for (RoleTreeItem role : roleList) {
                    role.setParent(root);
                    List userList = role.getChildren();
                    for (RoleTreeItem user : userList) {
                        user.setParent(role);
                    }
                }
                return top;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getJobTree(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<String> getOwnerRoleIdList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getOwnerRoleIdList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getOwnUserInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void assignUserRole(String roleId, List<String> userIds) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserDuplicate_Exception, InvalidSetting_Exception, UnEditableRole_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.assignUserRole(roleId, userIds);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("assignUserRole(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<SystemPrivilegeInfo> getSystemPrivilegeInfoList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getSystemPrivilegeInfoList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getSystemPrivilegeInfoList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<SystemPrivilegeInfo> getSystemPrivilegeInfoListByRoleId(String roleId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getSystemPrivilegeInfoListByRoleId(roleId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getSystemPrivilegeInfoListByRoleId(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<SystemPrivilegeInfo> getSystemPrivilegeInfoListByUserId(String userId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getSystemPrivilegeInfoListByUserId(userId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getSystemPrivilegeInfoListByUserId(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void replaceSystemPrivilegeRole(String roleId, List<SystemPrivilegeInfo> systemPrivileges) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UserDuplicate_Exception, InvalidSetting_Exception, UnEditableRole_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.replaceSystemPrivilegeRole(roleId, systemPrivileges);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("assignUserRole(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<ObjectPrivilegeInfo> getObjectPrivilegeInfoList(ObjectPrivilegeFilterInfo objectPrivilegeFilterInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getObjectPrivilegeInfoList(objectPrivilegeFilterInfo);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getObjectPrivilegeInfoList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static ObjectPrivilegeInfo getObjectPrivilegeInfo(String objectType, String objectId, String roleId, String objectPrivilege) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                return endpoint.getObjectPrivilegeInfo(objectType, objectId, roleId, objectPrivilege);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getObjectPrivilegeInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void replaceObjectPrivilegeInfo(String objectType, String objectId, List<ObjectPrivilegeInfo> objectPrivilegeInfoList) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception, PrivilegeDuplicate_Exception, UsedObjectPrivilege_Exception, JobMasterNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getAccessEndpoint()) {
            try {
                AccessEndpoint endpoint = (AccessEndpoint)endpointSetting.getEndpoint();
                endpoint.replaceObjectPrivilegeInfo(objectType, objectId, objectPrivilegeInfoList);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("replaceObjectPrivilegeInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }
}

