/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dialog;

import com.clustercontrol.accesscontrol.action.CheckPermission;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.UnEditableUser_Exception;
import com.clustercontrol.ws.access.UserDuplicate_Exception;
import com.clustercontrol.ws.access.UserInfo;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(UserDialog.class);
    private String userId = "";
    private int mode = 0;
    private boolean isModifyDialog = false;
    private Text textUserId = null;
    private Text textUserName = null;
    private Text textDescription = null;
    public static final int WIDTH = 15;
    public static final int WIDTH_LABEL = 4;
    public static final int WIDTH_TEXT = 10;
    private UserInfo inputData = null;
    private boolean permission = false;

    public UserDialog(Shell parent, String userId, boolean isModifyDialog) {
        super(parent);
        this.userId = userId;
        this.isModifyDialog = isModifyDialog;
        this.permission = new CheckPermission().check("AccessControl", PrivilegeConstant.SystemPrivilegeMode.WRITE);
    }

    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.accesscontrol.user.create.modify"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"user.id")) + " : ");
        this.textUserId = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textUserId.setLayoutData((Object)gridData);
        this.textUserId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                UserDialog.this.update();
            }
        });
        this.mode = this.isModifyDialog ? (this.permission ? 1 : 2) : 0;
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"user.name")) + " : ");
        this.textUserName = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textUserName.setLayoutData((Object)gridData);
        this.textUserName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                UserDialog.this.update();
            }
        });
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gridData);
        this.textDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                UserDialog.this.update();
            }
        });
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        UserInfo info = null;
        if (this.userId != null) {
            try {
                info = AccessEndpointWrapper.getUserInfo(this.userId);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("customizeDialog(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        } else {
            info = new UserInfo();
        }
        this.setInputData(info);
    }

    @Override
    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return null;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        UserInfo userInfo = this.inputData;
        if (userInfo == null) {
            return result;
        }
        if (!this.isModifyDialog) {
            try {
                AccessEndpointWrapper.addUserInfo(userInfo);
                result = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.7"));
            }
            catch (UserDuplicate_Exception userDuplicate_Exception) {
                Object[] args = new String[]{userInfo.getId()};
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.20", (Object[])args));
            }
            catch (Exception e) {
                String errMessage = "";
                if (e instanceof InvalidRole_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                } else {
                    errMessage = ", " + e.getMessage();
                }
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.accesscontrol.8")) + errMessage));
            }
        } else {
            try {
                AccessEndpointWrapper.modifyUserInfo(userInfo);
                result = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.9"));
            }
            catch (Exception e) {
                String errMessage = "";
                if (e instanceof InvalidRole_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                } else if (e instanceof UnEditableUser_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.38"));
                } else {
                    errMessage = ", " + e.getMessage();
                }
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.accesscontrol.10")) + errMessage));
            }
        }
        return result;
    }

    public void update() {
        if ("".equals(this.textUserId.getText())) {
            this.textUserId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textUserId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.textUserName.getText())) {
            this.textUserName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textUserName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    protected void setInputData(UserInfo userInfo) {
        this.inputData = userInfo;
        if (userInfo.getId() != null) {
            this.textUserId.setText(userInfo.getId());
        }
        if (userInfo.getName() != null) {
            this.textUserName.setText(userInfo.getName());
        }
        if (userInfo.getDescription() != null) {
            this.textDescription.setText(userInfo.getDescription());
        }
        if (this.mode == 2 || this.mode == 1) {
            this.textUserId.setEnabled(false);
        } else {
            this.textUserId.setEnabled(true);
        }
        ArrayList<String> roleList = new ArrayList<String>();
        roleList.add("AccessControlRead");
        roleList.add("AccessControlWrite");
        roleList.add("CalendarRead");
        roleList.add("CalendarWrite");
        roleList.add("CollectiveRunExecute");
        roleList.add("CollectiveRunRead");
        roleList.add("CollectiveRunWrite");
        roleList.add("HinemosUser");
        roleList.add("JobManagementExecute");
        roleList.add("JobManagementRead");
        roleList.add("JobManagementWrite");
        roleList.add("MaintenanceRead");
        roleList.add("MaintenanceWrite");
        roleList.add("MonitorResultRead");
        roleList.add("MonitorResultWrite");
        roleList.add("MonitorSettingRead");
        roleList.add("MonitorSettingWrite");
        roleList.add("NotifyRead");
        roleList.add("NotifyWrite");
        roleList.add("PerformanceExecute");
        roleList.add("PerformanceRead");
        roleList.add("RepositoryExecute");
        roleList.add("RepositoryRead");
        roleList.add("RepositoryWrite");
        roleList.add("VmManagementExecute");
        roleList.add("VmManagementRead");
        roleList.add("VmManagementWrite");
        this.update();
    }

    private UserInfo createInputData() {
        UserInfo info = new UserInfo();
        info.setId(this.textUserId.getText());
        info.setName(this.textUserName.getText());
        info.setDescription(this.textDescription.getText());
        return info;
    }

    @Override
    protected String getOkButtonText() {
        if (this.isModifyDialog) {
            return Messages.getString((String)"modify");
        }
        return Messages.getString((String)"register");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }
}

