/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dialog;

import com.clustercontrol.accesscontrol.action.CheckPermission;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.accesscontrol.util.SystemPrivilegePropertyUtil;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.InvalidSetting_Exception;
import com.clustercontrol.ws.access.RoleInfo;
import com.clustercontrol.ws.access.SystemPrivilegeInfo;
import com.clustercontrol.ws.access.UnEditableRole_Exception;
import com.clustercontrol.ws.access.UserDuplicate_Exception;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SystemPrivilegeDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(SystemPrivilegeDialog.class);
    private String roleId = "";
    private int mode = 0;
    private org.eclipse.swt.widgets.List listNotRoleSystemPrivilege = null;
    private org.eclipse.swt.widgets.List listRoleSystemPrivilege = null;
    private Button buttonRoleSystemPrivilege = null;
    private Button buttonNotRoleSystemPrivilege = null;
    public static final int WIDTH = 15;
    public static final int WIDTH_LABEL = 4;
    public static final int WIDTH_TEXT = 10;
    private RoleInfo inputData = null;
    private boolean permission = false;

    public SystemPrivilegeDialog(Shell parent, String roleId) {
        super(parent);
        this.roleId = roleId;
        this.permission = new CheckPermission().check("AccessControl", PrivilegeConstant.SystemPrivilegeMode.WRITE);
    }

    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.accesscontrol.system.privilege.setting"));
        this.mode = this.permission ? 1 : 2;
        RoleInfo info = null;
        try {
            info = AccessEndpointWrapper.getRoleInfo(this.roleId);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("customizeDialog(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"role.name")) + " : " + info.getName());
        Composite compositeNotRole = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        compositeNotRole.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 6;
        gridData.verticalSpan = 2;
        compositeNotRole.setLayoutData((Object)gridData);
        label = new Label(compositeNotRole, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"SystemPrivilegeDialog.not_role_system_privilege"));
        this.listNotRoleSystemPrivilege = new org.eclipse.swt.widgets.List(compositeNotRole, 2562);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.listNotRoleSystemPrivilege.getItemHeight() * 12;
        this.listNotRoleSystemPrivilege.setLayoutData((Object)gridData);
        Composite compositeButton = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        compositeButton.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        compositeButton.setLayoutData((Object)gridData);
        label = new Label(compositeButton, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        new Label(compositeButton, 0);
        this.buttonRoleSystemPrivilege = this.createButton(compositeButton, Messages.getString((String)"SystemPrivilegeDialog.role_system_privilege_button"));
        this.buttonRoleSystemPrivilege.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] items;
                String[] stringArray = items = SystemPrivilegeDialog.this.listNotRoleSystemPrivilege.getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    SystemPrivilegeDialog.this.listNotRoleSystemPrivilege.remove(item);
                    SystemPrivilegeDialog.this.listRoleSystemPrivilege.add(item);
                    ++n2;
                }
            }
        });
        new Label(compositeButton, 0);
        this.buttonNotRoleSystemPrivilege = this.createButton(compositeButton, Messages.getString((String)"SystemPrivilegeDialog.not_role_system_privilege_button"));
        this.buttonNotRoleSystemPrivilege.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] items;
                String[] stringArray = items = SystemPrivilegeDialog.this.listRoleSystemPrivilege.getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    SystemPrivilegeDialog.this.listRoleSystemPrivilege.remove(item);
                    SystemPrivilegeDialog.this.listNotRoleSystemPrivilege.add(item);
                    ++n2;
                }
            }
        });
        label = new Label(compositeButton, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Composite compositeRole = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        compositeRole.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 6;
        gridData.verticalSpan = 2;
        compositeRole.setLayoutData((Object)gridData);
        label = new Label(compositeRole, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"SystemPrivilegeDialog.role_system_privilege"));
        this.listRoleSystemPrivilege = new org.eclipse.swt.widgets.List(compositeRole, 2562);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.listRoleSystemPrivilege.getItemHeight() * 12;
        this.listRoleSystemPrivilege.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        this.setInputData(info);
    }

    @Override
    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return null;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        RoleInfo roleInfo = this.inputData;
        if (roleInfo == null) {
            return result;
        }
        try {
            AccessEndpointWrapper.replaceSystemPrivilegeRole(this.roleId, roleInfo.getSystemPrivilegeList());
            result = true;
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.47"));
        }
        catch (UserDuplicate_Exception userDuplicate_Exception) {
            Object[] args = new String[]{roleInfo.getId()};
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.48", (Object[])args));
        }
        catch (InvalidSetting_Exception invalidSetting_Exception) {
            Object[] args = new String[]{Messages.getString((String)"repository.read", (Locale)Locale.getDefault())};
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.51", (Object[])args));
        }
        catch (Exception e) {
            String errMessage = "";
            if (e instanceof InvalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            } else if (e instanceof UnEditableRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.44"));
            } else {
                errMessage = ", " + e.getMessage();
            }
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.accesscontrol.48")) + errMessage));
        }
        return result;
    }

    protected void setInputData(RoleInfo roleInfo) {
        this.inputData = roleInfo;
        List<String> allSystemPrivilegeList = null;
        List<SystemPrivilegeInfo> roleSystemPrivilegeKeyList = null;
        allSystemPrivilegeList = SystemPrivilegePropertyUtil.getValueList();
        Collections.sort(allSystemPrivilegeList);
        try {
            roleSystemPrivilegeKeyList = AccessEndpointWrapper.getSystemPrivilegeInfoListByRoleId(this.roleId);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("getOwnUserList(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        List<String> roleSystemPrivilegeValueList = this.getSystemPrivilegeValueList(roleSystemPrivilegeKeyList);
        for (String SystemPrivilege : allSystemPrivilegeList) {
            if (roleSystemPrivilegeValueList.contains(SystemPrivilege)) {
                this.listRoleSystemPrivilege.add(SystemPrivilege);
                continue;
            }
            this.listNotRoleSystemPrivilege.add(SystemPrivilege);
        }
    }

    private RoleInfo createInputData() {
        RoleInfo info = this.inputData;
        ArrayList systemPrivilegeList = this.inputData.getSystemPrivilegeList();
        if (systemPrivilegeList == null) {
            systemPrivilegeList = new ArrayList();
        }
        List roleSystemPrivilegeList = info.getSystemPrivilegeList();
        roleSystemPrivilegeList.clear();
        if (this.listRoleSystemPrivilege.getItemCount() > 0) {
            roleSystemPrivilegeList.addAll(this.getSystemPrivilegeKeyList(Arrays.asList(this.listRoleSystemPrivilege.getItems())));
        }
        return info;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"setup");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    private List<SystemPrivilegeInfo> getSystemPrivilegeKeyList(List<String> beforeList) {
        ArrayList<SystemPrivilegeInfo> afterList = new ArrayList<SystemPrivilegeInfo>();
        for (String beforeStr : beforeList) {
            String key = SystemPrivilegePropertyUtil.getKey(beforeStr);
            SystemPrivilegeInfo info = new SystemPrivilegeInfo();
            String regexp = "(.+?)(" + PrivilegeConstant.SystemPrivilegeMode.READ.name() + ")";
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(key);
            if (matcher.find()) {
                info.setSystemFunction(matcher.group(1));
                info.setSystemPrivilege(PrivilegeConstant.SystemPrivilegeMode.READ.name());
                afterList.add(info);
                continue;
            }
            regexp = "(.+?)(" + PrivilegeConstant.SystemPrivilegeMode.WRITE.name() + ")";
            pattern = Pattern.compile(regexp);
            matcher = pattern.matcher(key);
            if (matcher.find()) {
                info.setSystemFunction(matcher.group(1));
                info.setSystemPrivilege(PrivilegeConstant.SystemPrivilegeMode.WRITE.name());
                afterList.add(info);
                continue;
            }
            regexp = "(.+?)(" + PrivilegeConstant.SystemPrivilegeMode.ADD.name() + ")";
            pattern = Pattern.compile(regexp);
            matcher = pattern.matcher(key);
            if (matcher.find()) {
                info.setSystemFunction(matcher.group(1));
                info.setSystemPrivilege(PrivilegeConstant.SystemPrivilegeMode.ADD.name());
                afterList.add(info);
                continue;
            }
            regexp = "(.+?)(" + PrivilegeConstant.SystemPrivilegeMode.EXEC.name() + ")";
            pattern = Pattern.compile(regexp);
            matcher = pattern.matcher(key);
            if (!matcher.find()) continue;
            info.setSystemFunction(matcher.group(1));
            info.setSystemPrivilege(PrivilegeConstant.SystemPrivilegeMode.EXEC.name());
            afterList.add(info);
        }
        return afterList;
    }

    private List<String> getSystemPrivilegeValueList(List<SystemPrivilegeInfo> beforeList) {
        ArrayList<String> afterList = new ArrayList<String>();
        for (SystemPrivilegeInfo systemPrivilegeInfo : beforeList) {
            afterList.add(SystemPrivilegePropertyUtil.getValue(systemPrivilegeInfo.getSystemFunction(), systemPrivilegeInfo.getSystemPrivilege()));
        }
        return afterList;
    }
}

