/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dialog;

import com.clustercontrol.accesscontrol.action.CheckPermission;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.RoleInfo;
import com.clustercontrol.ws.access.UnEditableRole_Exception;
import com.clustercontrol.ws.access.UserDuplicate_Exception;
import com.clustercontrol.ws.access.UserInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RoleSettingDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(RoleSettingDialog.class);
    private String roleId = "";
    private int mode = 0;
    private org.eclipse.swt.widgets.List listNotRoleUser = null;
    private org.eclipse.swt.widgets.List listRoleUser = null;
    private Button buttonRoleUser = null;
    private Button buttonNotRoleUser = null;
    public static final int WIDTH = 15;
    public static final int WIDTH_LABEL = 4;
    public static final int WIDTH_TEXT = 10;
    private RoleInfo inputData = null;
    private HashMap<String, String> mapNotRoleUser = null;
    private HashMap<String, String> mapRoleUser = null;
    private boolean permission = false;

    public RoleSettingDialog(Shell parent, String roleId) {
        super(parent);
        this.roleId = roleId;
        this.permission = new CheckPermission().check("AccessControl", PrivilegeConstant.SystemPrivilegeMode.WRITE);
    }

    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.accesscontrol.role.setting"));
        this.mode = this.permission ? 1 : 2;
        RoleInfo info = null;
        try {
            info = AccessEndpointWrapper.getRoleInfo(this.roleId);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("customizeDialog(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"role.name")) + " : " + info.getName());
        Composite compositeNotRole = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        compositeNotRole.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 6;
        gridData.verticalSpan = 2;
        compositeNotRole.setLayoutData((Object)gridData);
        label = new Label(compositeNotRole, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"RoleSettingDialog.not_role_user"));
        this.listNotRoleUser = new org.eclipse.swt.widgets.List(compositeNotRole, 2562);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.listNotRoleUser.getItemHeight() * 12;
        this.listNotRoleUser.setLayoutData((Object)gridData);
        this.mapNotRoleUser = new HashMap();
        Composite compositeButton = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        compositeButton.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        compositeButton.setLayoutData((Object)gridData);
        label = new Label(compositeButton, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        new Label(compositeButton, 0);
        this.buttonRoleUser = this.createButton(compositeButton, Messages.getString((String)"RoleSettingDialog.role_user_button"));
        this.buttonRoleUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] items;
                String[] stringArray = items = RoleSettingDialog.this.listNotRoleUser.getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    RoleSettingDialog.this.listNotRoleUser.remove(item);
                    RoleSettingDialog.this.listRoleUser.add(item);
                    RoleSettingDialog.this.mapRoleUser.put(item, (String)RoleSettingDialog.this.mapNotRoleUser.get(item));
                    RoleSettingDialog.this.mapNotRoleUser.remove(item);
                    ++n2;
                }
            }
        });
        new Label(compositeButton, 0);
        this.buttonNotRoleUser = this.createButton(compositeButton, Messages.getString((String)"RoleSettingDialog.not_role_user_button"));
        this.buttonNotRoleUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] items;
                String[] stringArray = items = RoleSettingDialog.this.listRoleUser.getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    RoleSettingDialog.this.listRoleUser.remove(item);
                    RoleSettingDialog.this.listNotRoleUser.add(item);
                    RoleSettingDialog.this.mapNotRoleUser.put(item, (String)RoleSettingDialog.this.mapRoleUser.get(item));
                    RoleSettingDialog.this.mapRoleUser.remove(item);
                    ++n2;
                }
            }
        });
        label = new Label(compositeButton, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Composite compositeRole = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        compositeRole.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 6;
        gridData.verticalSpan = 2;
        compositeRole.setLayoutData((Object)gridData);
        label = new Label(compositeRole, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"RoleSettingDialog.role_user"));
        this.listRoleUser = new org.eclipse.swt.widgets.List(compositeRole, 2562);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.listRoleUser.getItemHeight() * 12;
        this.listRoleUser.setLayoutData((Object)gridData);
        this.mapRoleUser = new HashMap();
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        this.setInputData(info);
    }

    @Override
    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return null;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        RoleInfo roleInfo = this.inputData;
        if (roleInfo == null) {
            return result;
        }
        try {
            AccessEndpointWrapper.assignUserRole(roleInfo.getId(), roleInfo.getUserList());
            result = true;
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.34"));
        }
        catch (UserDuplicate_Exception userDuplicate_Exception) {
            Object[] args = new String[]{roleInfo.getId()};
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.35", (Object[])args));
        }
        catch (Exception e) {
            String errMessage = "";
            if (e instanceof InvalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            } else if (e instanceof UnEditableRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.43"));
            } else {
                errMessage = ", " + e.getMessage();
            }
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.accesscontrol.35")) + errMessage));
        }
        return result;
    }

    protected void setInputData(RoleInfo roleInfo) {
        this.inputData = roleInfo;
        List<UserInfo> allUserList = null;
        try {
            allUserList = AccessEndpointWrapper.getUserInfoList();
            Collections.sort(allUserList, new Comparator<UserInfo>(){

                @Override
                public int compare(UserInfo o1, UserInfo o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("getOwnUserList(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        String listName = null;
        for (UserInfo userInfo : allUserList) {
            listName = String.valueOf(userInfo.getName()) + "(" + userInfo.getId() + ")";
            if (roleInfo.getUserList().contains(userInfo.getId())) {
                this.listRoleUser.add(listName);
                this.mapRoleUser.put(listName, userInfo.getId());
                continue;
            }
            this.listNotRoleUser.add(listName);
            this.mapNotRoleUser.put(listName, userInfo.getId());
        }
    }

    private RoleInfo createInputData() {
        RoleInfo info = this.inputData;
        ArrayList userList = info.getUserList();
        if (userList == null) {
            userList = new ArrayList();
        }
        List roleUserList = info.getUserList();
        roleUserList.clear();
        if (this.listRoleUser.getItemCount() > 0) {
            roleUserList.addAll(this.getUserIdList(this.mapRoleUser));
        }
        return info;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"setup");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    private List<String> getUserIdList(HashMap<String, String> userMap) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String key : userMap.keySet()) {
            resultList.add(userMap.get(key));
        }
        return resultList;
    }
}

