/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dialog;

import com.clustercontrol.accesscontrol.composite.ObjectPrivilegeEditComposite;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.accesscontrol.util.ObjectPrivilegeBean;
import com.clustercontrol.accesscontrol.util.RoleObjectPrivilegeUtil;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.calendar.dialog.CalendarDialog;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.JobMasterNotFound_Exception;
import com.clustercontrol.ws.access.ObjectPrivilegeInfo;
import com.clustercontrol.ws.access.UsedObjectPrivilege_Exception;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ObjectPrivilegeEditDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(CalendarDialog.class);
    private List<ObjectBean> m_objects = null;
    private Composite m_listRoleComposite = null;
    private org.eclipse.swt.widgets.List m_listRole = null;
    private RoleIdListComposite m_roleIdComposite = null;
    private ObjectPrivilegeEditComposite m_objectPrivEditComposite = null;
    private HashMap<String, ObjectPrivilegeBean> m_modObjPrivMap = null;
    private String m_selectRoleId = "";
    private String m_ownerRoleId = "";
    private Button m_buttonAdd = null;
    private Button m_buttonDel = null;
    private Shell shell = null;

    public ObjectPrivilegeEditDialog(Shell parent) {
        super(parent);
    }

    public ObjectPrivilegeEditDialog(Shell parent, List<ObjectBean> objects, String ownerRoleId, HashMap<String, ObjectPrivilegeBean> objPrivMap) {
        super(parent);
        this.m_objects = objects;
        this.m_ownerRoleId = ownerRoleId;
        this.m_modObjPrivMap = objPrivMap == null ? new HashMap() : objPrivMap;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.shell = this.getShell();
        String objectName = "";
        if (this.m_objects.size() == 1) {
            objectName = HinemosModuleConstant.nameToString((String)this.m_objects.get(0).getObjectType());
        }
        this.shell.setText(String.valueOf(objectName) + Messages.getString((String)"dialog.accesscontrol.object.privilege.edit"));
        GridData gridData = new GridData();
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        Label lblRoleList = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblRoleList.setLayoutData((Object)gridData);
        lblRoleList.setText(Messages.getString((String)"role.id.list"));
        this.m_listRoleComposite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 0;
        this.m_listRoleComposite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 15;
        gridData.verticalSpan = 2;
        this.m_listRoleComposite.setLayoutData((Object)gridData);
        this.m_listRole = new org.eclipse.swt.widgets.List(this.m_listRoleComposite, 2564);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.m_listRole.getItemHeight() * 6;
        this.m_listRole.setLayoutData((Object)gridData);
        this.m_listRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String roleId = ObjectPrivilegeEditDialog.this.m_listRole.getSelection()[0];
                ObjectPrivilegeEditDialog.this.m_objectPrivEditComposite.setObjectPrivilege((ObjectPrivilegeBean)ObjectPrivilegeEditDialog.this.m_modObjPrivMap.get(roleId));
                ObjectPrivilegeEditDialog.this.m_objectPrivEditComposite.getTable().setEnabled(true);
            }
        });
        Label labelRoleId = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelRoleId.setLayoutData((Object)gridData);
        labelRoleId.setText(String.valueOf(Messages.getString((String)"role.id")) + " : ");
        this.m_roleIdComposite = new RoleIdListComposite(parent, 0, true, RoleIdListComposite.Mode.ROLE);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_roleIdComposite.setLayoutData(gridData);
        Label labelSpace = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelSpace.setLayoutData((Object)gridData);
        labelSpace.setText("");
        for (Map.Entry<String, ObjectPrivilegeBean> keyValue : this.m_modObjPrivMap.entrySet()) {
            this.m_listRole.add(keyValue.getKey());
            this.m_roleIdComposite.delete(keyValue.getKey());
        }
        if (this.m_ownerRoleId != null && !this.m_ownerRoleId.isEmpty()) {
            this.m_roleIdComposite.delete(this.m_ownerRoleId);
        }
        this.m_buttonAdd = new Button(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonAdd.setLayoutData((Object)gridData);
        this.m_buttonAdd.setText(Messages.getString((String)"add"));
        this.m_buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String roleId = ObjectPrivilegeEditDialog.this.m_roleIdComposite.getText();
                if ("".equals(roleId)) {
                    return;
                }
                ObjectPrivilegeEditDialog.this.m_listRole.add(roleId);
                ObjectPrivilegeBean bean = new ObjectPrivilegeBean();
                bean.setRoleId(roleId);
                bean.setReadPrivilege(true);
                ObjectPrivilegeEditDialog.this.m_modObjPrivMap.put(roleId, bean);
                ObjectPrivilegeEditDialog.this.m_roleIdComposite.delete(roleId);
            }
        });
        Label label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_buttonDel = new Button(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonDel.setLayoutData((Object)gridData);
        this.m_buttonDel.setText(Messages.getString((String)"delete"));
        this.m_buttonDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectPrivilegeEditDialog.this.m_listRole.getSelection() == null || ObjectPrivilegeEditDialog.this.m_listRole.getSelection().length == 0) {
                    return;
                }
                String roleId = ObjectPrivilegeEditDialog.this.m_listRole.getSelection()[0];
                ObjectPrivilegeEditDialog.this.m_listRole.remove(roleId);
                ObjectPrivilegeEditDialog.this.m_objectPrivEditComposite.setObjectPrivilege(new ObjectPrivilegeBean());
                ObjectPrivilegeEditDialog.this.m_objectPrivEditComposite.getTable().setEnabled(false);
                ObjectPrivilegeEditDialog.this.m_modObjPrivMap.remove(roleId);
                ObjectPrivilegeEditDialog.this.m_roleIdComposite.add(roleId);
            }
        });
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Label lblObjectPrivilegeEdit = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblObjectPrivilegeEdit.setLayoutData((Object)gridData);
        if (this.m_selectRoleId != "") {
            lblObjectPrivilegeEdit.setText(String.valueOf(this.m_selectRoleId) + " : " + Messages.getString((String)"object.privilege.setting"));
        } else {
            lblObjectPrivilegeEdit.setText(Messages.getString((String)"object.privilege.setting"));
        }
        this.m_objectPrivEditComposite = new ObjectPrivilegeEditComposite(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 150;
        this.m_objectPrivEditComposite.setLayoutData(gridData);
        this.m_objectPrivEditComposite.getTable().setEnabled(false);
        Display display = this.shell.getDisplay();
        this.shell.setLocation((display.getBounds().width - this.shell.getSize().x) / 2, (display.getBounds().height - this.shell.getSize().y) / 2);
        this.adjustDialog();
    }

    private void adjustDialog() {
        this.shell.pack();
        this.shell.setSize(new Point(600, this.shell.getSize().y));
        Display display = this.shell.getDisplay();
        this.shell.setLocation((display.getBounds().width - this.shell.getSize().x) / 2, (display.getBounds().height - this.shell.getSize().y) / 2);
    }

    public void update() {
    }

    @Override
    protected boolean action() {
        boolean result = true;
        List<ObjectPrivilegeInfo> inputdata = this.createInputData();
        StringBuffer confirmList = new StringBuffer();
        StringBuffer successList = new StringBuffer();
        StringBuffer failureList = new StringBuffer();
        Object[] args = null;
        if (this.m_objects.size() > 1) {
            for (ObjectBean objectBean : this.m_objects) {
                confirmList.append(String.valueOf(objectBean.getObjectId()) + "\n");
            }
            args = new String[]{confirmList.toString()};
            if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.accesscontrol.53", (Object[])args))) {
                return false;
            }
        }
        for (ObjectBean objectBean : this.m_objects) {
            String objectPrivilegeParam = Messages.getString((String)"object.privilege.param", (Object[])new String[]{HinemosModuleConstant.nameToString((String)objectBean.getObjectType()), objectBean.getObjectId()});
            try {
                AccessEndpointWrapper.replaceObjectPrivilegeInfo(objectBean.getObjectType(), objectBean.getObjectId(), inputdata);
                successList.append(String.valueOf(objectPrivilegeParam) + "\n");
            }
            catch (UsedObjectPrivilege_Exception e) {
                args = new String[]{HinemosModuleConstant.nameToString((String)e.getFaultInfo().getObjectType()), e.getFaultInfo().getObjectId()};
                failureList.append(String.valueOf(objectPrivilegeParam) + " (" + Messages.getString((String)"message.accesscontrol.36", (Object[])args) + ")\n");
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                failureList.append(String.valueOf(objectPrivilegeParam) + " (" + Messages.getString((String)"message.accesscontrol.16") + ")\n");
            }
            catch (JobMasterNotFound_Exception jobMasterNotFound_Exception) {
                failureList.append(String.valueOf(objectPrivilegeParam) + " (" + Messages.getString((String)"message.accesscontrol.46") + ")\n");
            }
            catch (Exception e) {
                m_log.warn((Object)("getOwnUserList(), " + e.getMessage()), (Throwable)e);
                failureList.append(String.valueOf(objectPrivilegeParam) + " (" + Messages.getString((String)"message.hinemos.failure.unexpected") + ", " + e.getMessage() + ")\n");
            }
        }
        if (successList.length() != 0) {
            args = new String[]{successList.toString()};
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.49", (Object[])args));
        }
        if (failureList.length() != 0) {
            args = new String[]{failureList.toString()};
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.accesscontrol.50", (Object[])args));
        }
        return result;
    }

    private List<ObjectPrivilegeInfo> createInputData() {
        List<ObjectPrivilegeInfo> list = null;
        list = RoleObjectPrivilegeUtil.beanMap2dtoList(this.m_modObjPrivMap);
        return list;
    }
}

