/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dialog;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.composite.action.StringVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends Dialog {
    private static Log m_log = LogFactory.getLog(LoginDialog.class);
    private Text m_uidText = null;
    private Text m_passwordText = null;
    private String m_uid = null;
    private String m_password = null;
    private Combo m_urlText = null;
    private String m_url = null;
    private Shell m_shell = null;

    public LoginDialog(Shell parent) {
        super(parent);
    }

    protected Control createContents(Composite parent) {
        Button button;
        String cancelText;
        Button button2;
        Composite composite = (Composite)super.createContents(parent);
        this.customizeDialog((Composite)this.getDialogArea());
        String okText = this.getOkButtonText();
        if (okText != null && (button2 = this.getButton(0)) != null) {
            button2.setText(okText);
        }
        if ((cancelText = this.getCancelButtonText()) != null && (button = this.getButton(1)) != null) {
            button.setText(cancelText);
        }
        return composite;
    }

    protected void customizeDialog(Composite parent) {
        this.m_shell = this.getShell();
        this.m_shell.setText(Messages.getString((String)"dialog.accesscontrol.login"));
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 10;
        layout.marginWidth = 12;
        layout.marginHeight = 10;
        layout.fill = true;
        parent.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label uidTitle = new Label(composite, 0);
        uidTitle.setText(String.valueOf(Messages.getString((String)"user.id")) + " : ");
        uidTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_uidText = new Text(composite, 2048);
        this.m_uidText.setLayoutData((Object)new RowData(265, 15));
        this.m_uidText.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label passwordTitle = new Label(composite, 0);
        passwordTitle.setText(String.valueOf(Messages.getString((String)"password")) + " : ");
        passwordTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_passwordText = new Text(composite, 0x400800);
        this.m_passwordText.setLayoutData((Object)new RowData(265, 15));
        this.m_passwordText.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label urlTitle = new Label(composite, 0);
        urlTitle.setText(String.valueOf(Messages.getString((String)"connection.url")) + " : ");
        urlTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_urlText = new Combo(composite, 2052);
        this.m_urlText.setLayoutData((Object)new RowData(250, 15));
        this.m_urlText.addVerifyListener((VerifyListener)new StringVerifyListener(1024));
        this.m_urlText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int deleteIndex;
                if (e.character == '\u007f' && (deleteIndex = LoginDialog.this.m_urlText.getSelectionIndex()) != -1) {
                    LoginDialog.this.m_urlText.remove(deleteIndex);
                    LoginDialog.this.deleteUrl(deleteIndex);
                }
            }
        });
        new Label(parent, 258);
        Display display = this.m_shell.getDisplay();
        this.m_shell.setLocation((display.getBounds().width - this.m_shell.getSize().x) / 2, (display.getBounds().height - this.m_shell.getSize().y) / 2);
        this.reflectData();
        this.m_passwordText.setFocus();
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"login");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void reflectData() {
        for (String url : this.readPrefURLs()) {
            this.m_urlText.add(url);
        }
        this.m_uidText.setText(this.readPrefUID());
        this.m_urlText.setText(this.readPrefURL());
    }

    private void deleteUrl(int index) {
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        int numOfUrlHistory = store.getInt("numOfUrlHistory");
        int deleteIndex = numOfUrlHistory - 1 - index;
        m_log.debug((Object)("deleteIndex : " + deleteIndex));
        ArrayList<String> urls = new ArrayList<String>(numOfUrlHistory);
        int i = 0;
        while (i < numOfUrlHistory) {
            String url = store.getString("ejbUrl_" + i);
            urls.add(url);
            ++i;
        }
        i = numOfUrlHistory - 1;
        while (i >= 0) {
            if (i > deleteIndex) {
                m_log.debug((Object)(String.valueOf((String)urls.get(i)) + " is move from " + i + " to " + (i - 1)));
                store.setValue("ejbUrl_" + (i - 1), (String)urls.get(i));
            } else if (i < deleteIndex) {
                m_log.debug((Object)(String.valueOf((String)urls.get(i)) + " is move from " + i + " to " + i));
                store.setValue("ejbUrl_" + i, (String)urls.get(i));
            } else {
                m_log.debug((Object)("deleteUrl : " + (String)urls.get(i)));
            }
            --i;
        }
        store.setValue("ejbUrl_" + --numOfUrlHistory, "");
        store.setValue("numOfUrlHistory", numOfUrlHistory);
    }

    protected void okPressed() {
        ValidateResult result = this.validate();
        if (result == null || result.isValid()) {
            super.okPressed();
        } else {
            this.displayError(result);
        }
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        if (this.m_uidText.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.accesscontrol.1"));
            return result;
        }
        this.setUserid(this.m_uidText.getText());
        if (this.m_passwordText.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.accesscontrol.2"));
            return result;
        }
        this.setPassword(this.m_passwordText.getText());
        if (this.m_urlText.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.hinemos.9"));
            return result;
        }
        this.setUrl(this.m_urlText.getText());
        return null;
    }

    private void displayError(ValidateResult result) {
        MessageDialog.openWarning(null, (String)result.getID(), (String)result.getMessage());
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getUserid() {
        return this.m_uid;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUserid(String uid) {
        this.m_uid = uid;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    private String readPrefURL() {
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        String url = store.getString("ejbUrl");
        if (url.compareTo("") == 0) {
            url = "http://localhost:8080/HinemosWS/";
        }
        return url;
    }

    private ArrayList<String> readPrefURLs() {
        ArrayList<String> ret = new ArrayList<String>();
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        int numOfUrlHistory = store.getInt("numOfUrlHistory");
        int i = numOfUrlHistory - 1;
        while (i >= 0) {
            String url = store.getString("ejbUrl_" + i);
            if (!url.equals("")) {
                ret.add(url);
            }
            --i;
        }
        return ret;
    }

    private String readPrefUID() {
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        String uid = store.getString("ejbUid");
        if (uid.compareTo("") == 0) {
            uid = "hinemos";
        }
        return uid;
    }
}

