/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.util.Messages;

public class ChangeActiveCloudUserDialog extends Dialog {
		
	public interface IDialogBehavior{
		void setupAccountResource(Text txtAccountResource);
		void setupCloudUser(Combo cmbCloudUser);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		@Override
		public void setupAccountResource(Text txtAccountResource){
			txtAccountResource.setEditable(false);
		}
		
		@Override
		public void setupCloudUser(Combo cmbCloudUser){
			
		}
	}
	
	public static class DialogOutput{
		private ICloudUser cloudUser;

		public ICloudUser getCloudUser() {
			return cloudUser;
		}

		public void setCloudUser(ICloudUser cloudUser) {
			this.cloudUser = cloudUser;
		}
	}
	
	private DialogOutput output = new DialogOutput();
	
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private String strSeparator = bundle_messages.getString("caption.title_separator");
	private String strAccountResource = bundle_messages.getString("word.account_resource");
	private String strActiveUser = bundle_messages.getString("word.cloud_user");
	
	
	private Text txtAccountResource;
	@RequiredSelect("strActiveUser")
	private Combo cmbCloudUser;
	
	private IDialogBehavior behavior = new DialogBehavior();

	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public ChangeActiveCloudUserDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.FILL);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		gl_container.verticalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
		container.setLayoutData(gd_container);
		
		{
			Label lblAccountResource = new Label(container, SWT.NONE);
			lblAccountResource.setText(strAccountResource + strSeparator);
			lblAccountResource.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true));
			txtAccountResource = new Text(container, SWT.BORDER);
			txtAccountResource.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

			Label lblCloudUser = new Label(container, SWT.NONE);
			lblCloudUser.setText(strActiveUser + strSeparator);
			lblCloudUser.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true));
			cmbCloudUser = new Combo(container, SWT.READ_ONLY);
			cmbCloudUser.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true));
		}
		
		//初期化ブロック1
		{
		}
		
		{
			behavior.setupAccountResource(txtAccountResource);
			behavior.setupCloudUser(cmbCloudUser);
		}
		
		//初期化ブロック2
		{
		}

//		ControlUtil.setRequired();

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(480, 240);
	}

	@Override
	protected void okPressed() {
		try{
			ControlUtil.validate(this);
		} catch(ValidateException e){
			MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
			return;
		} catch(Exception e){
			throw new RuntimeException(e);
		}
		
		{
			output.setCloudUser((ICloudUser)cmbCloudUser.getData(cmbCloudUser.getText()));
		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_messages.getString("caption.change_active_cloud_user_dialog"));
	}

	public DialogOutput getOutput() {
		return output;
	}

	public void setBehavior(IDialogBehavior behavior){
		this.behavior = behavior;
	}
}
