/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.base.ui.dialogs;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.BlockDeviceMapping;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.util.Messages;

public class DetachStorageFromInstanceDialog extends Dialog {
	private MessageManagerExt messages =MessageManagerExt.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strAvailabilityZone = messages.getString("word.availability_zone");
	private String strInstance = messages.getString("word.instance");
	private String strDevice = messages.getString("word.device");
	private String strVolumeId = messages.getString("word.volume_id");
	private String strVolumeName = messages.getString("word.volume_name");
	private String strSnapshotId = messages.getString("word.snapshot_id");
	private String strSize = messages.getString("word.size");
	private String strVolumeType = messages.getString("word.storage_type");
	private String strDetachStorageDialog = messages.getString("caption.detach_storage_dialog");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");
	
	
	
	private ICloudInstance instance;
	private java.util.List<ICloudStorage> volumes = new ArrayList<ICloudStorage>();
	private Table table;
	private TableViewer tableViewer;
	private Text availabilityZone;
	private Text instanceName;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public DetachStorageFromInstanceDialog(Shell parentShell, ICloudInstance instance) {
		super(parentShell);
		this.instance = instance;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblAvailabilityZone = new Label(container, SWT.NONE);
		lblAvailabilityZone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblAvailabilityZone.setText(strAvailabilityZone + strSeparator);
		availabilityZone = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		availabilityZone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		availabilityZone.setText(instance.getZone());
		
		Label lblInstance = new Label(container, SWT.NONE);
		lblInstance.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblInstance.setText(strInstance);
		
		instanceName = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		instanceName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		instanceName.setText(instance.getInstanceId());
				
		table = new Table(container, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		
		TableColumn tblclmnVolumeId = new TableColumn(table, SWT.NONE);
		tblclmnVolumeId.setWidth(90);
		tblclmnVolumeId.setText(strVolumeId);

		TableColumn tableColumn_6 = new TableColumn(table, SWT.NONE);
		tableColumn_6.setWidth(70);
		tableColumn_6.setText(strVolumeName);
		
		TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);
		tableColumn_1.setWidth(70);
		tableColumn_1.setText(strDevice);
		
		TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);
		tableColumn_2.setWidth(70);
		tableColumn_2.setText(strSnapshotId);
		
		TableColumn tableColumn_3 = new TableColumn(table, SWT.NONE);
		tableColumn_3.setWidth(70);
		tableColumn_3.setText(strSize);
		
		TableColumn tableColumn_4 = new TableColumn(table, SWT.NONE);
		tableColumn_4.setWidth(70);
		tableColumn_4.setText(strVolumeType);
		
		tableViewer = new TableViewer(table);
		VolumeProvider vp = new VolumeProvider();
		tableViewer.setContentProvider(vp.getVolumeContentProvider());

		instance.getCloudInstanceManager().getCloudComputeService().getStorageManager().update();
		List<ICloudStorage> storages = new ArrayList<ICloudStorage>();
		for (ICloudStorage s: instance.getCloudInstanceManager().getCloudComputeService().getStorageManager().getCloudStorages()) {
			for (BlockDeviceMapping d: instance.getBlockDeviceMappings()) {
				if (d.getVolumeId().equals(s.getStorageId())) {
					storages.add(s);
					break;
				}
			}
		}
		tableViewer.setInput(storages);
		tableViewer.setLabelProvider(vp.getVolumeLabelProvider());
		table.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				volumes.clear();
				for(TableItem ti: table.getSelection()){
					volumes.add((ICloudStorage)ti.getData());
				}
			}
		});
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		if(this.volumes.isEmpty()){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strDetachStorageDialog);
	}

	public java.util.List<String> getVolumes(){
		List<String> storageIds = new ArrayList<String>();
		for (ICloudStorage storage: volumes) {
			storageIds.add(storage.getStorageId());
		}
		return storageIds;
	}
	

	public static class VolumeProvider {
		private VolumeContentProvider vcp;
		private VolumeLabelProvider vlp;
		
		public VolumeProvider(){
			this.vcp = new VolumeContentProvider();
			this.vlp = new VolumeLabelProvider();
		}
		
		public class VolumeContentProvider implements IStructuredContentProvider {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((java.util.List<?>)inputElement).toArray();
			}
			@Override
			public void dispose() {
			}
			@Override
			public void inputChanged(Viewer viewer,	Object oldInput, Object newInput) {
			}
		}
		
		public class VolumeLabelProvider extends LabelProvider implements ITableLabelProvider {
			@Override
			public String getColumnText(Object element, int columnIndex) {
				ICloudStorage storage = (ICloudStorage)element;
				switch(columnIndex) {
					case 0:
						return storage.getStorageId();
					case 1:
						return storage.getStorageName();
					case 2:
						return storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "";
					case 3:
						return storage.getSnapshotId() != null ? storage.getSnapshotId(): "";
					case 4:
						return storage.getSize() != null ? String.valueOf(storage.getSize()): "";
					case 5:
						return storage.getFlavor();
					}
				return null;
			}
			@Override
			public Image getColumnImage(Object element, int columnIndex) {
				return null;
			}
		}
	
		public VolumeContentProvider getVolumeContentProvider(){
			return this.vcp;
		}
	
		public VolumeLabelProvider getVolumeLabelProvider(){
			return this.vlp;
		}
	}
}
