/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.base.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.base.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceByTemplateRequest;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class CreateInstanceByTemplateAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgCreateInstanceConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.create"});
    private String msgCreateInstanceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.create"});
    private ICloudTemplateManager templateManager;
    private ICloudTemplate template;

    protected void invoke(IAction action) throws InvocationException {
        CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
        TemplatesView view = (TemplatesView)this.viewPart;
        this.template = (ICloudTemplate)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        this.templateManager = this.template.getCloudTemplateManager();
        String region = this.template.getRegion();
        CreateInstanceDialog.Model input = new CreateInstanceDialog.Model();
        input.setRegionName(region);
        dialog.setInput(input);
        dialog.setCloudTemplateManager(this.templateManager);
        dialog.setCloudInfoProvider(new CloudResourceProviderImpl(view.getAccountResource().getAccountResourceId()));
        dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){
            private Combo region;

            @Override
            public void setupRegion(Combo region) {
                for (String regionName : this.provider.getAllRegion()) {
                    String regionLocaleName = this.messages.getString(regionName);
                    region.add(regionLocaleName);
                    region.setData(regionLocaleName, (Object)regionName);
                }
                if (CreateInstanceByTemplateAction.this.template != null && CreateInstanceByTemplateAction.this.template.getRegion() != null) {
                    String regionLocaleName = this.messages.getString(this.input.getRegionName());
                    region.select(region.indexOf(regionLocaleName));
                } else {
                    region.select(0);
                }
                this.region = region;
            }

            @Override
            public void setupAvailabilityZone(Combo availabilityZone) {
                for (AvailabilityZone zone : this.provider.getAvailabilityZones((String)this.region.getData(this.region.getText()))) {
                    availabilityZone.add(zone.getZoneName());
                }
                availabilityZone.select(0);
            }

            @Override
            public void setupKeyPair(Combo keyPair) {
                for (String keyName : this.provider.getKeyNames((String)this.region.getData(this.region.getText()))) {
                    keyPair.add(keyName);
                }
                if (keyPair.getItemCount() > 0) {
                    keyPair.setEnabled(true);
                    keyPair.select(0);
                } else {
                    keyPair.setEnabled(false);
                }
            }

            @Override
            public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate) {
                rdoAmi.setSelection(false);
                rdoTemplate.setSelection(true);
            }

            @Override
            public void setupAmi(Text ami, Button selectAmi) {
                ami.setEnabled(false);
                ami.setEditable(false);
                ami.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                selectAmi.setEnabled(false);
            }

            @Override
            public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
                useTemplate.setSelection(true);
                HashMap<String, String> map = new HashMap<String, String>();
                for (ICloudTemplate tmpTemplate : CreateInstanceByTemplateAction.this.templateManager.getCloudTemplates()) {
                    if (!tmpTemplate.getRegion().equals(this.region.getData(this.region.getText()))) continue;
                    String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
                    template.add(tmpLabel);
                    template.setData(tmpLabel, (Object)tmpTemplate);
                    map.put(tmpTemplate.getTemplateId(), tmpLabel);
                }
                if (CreateInstanceByTemplateAction.this.template != null && map.containsKey(CreateInstanceByTemplateAction.this.template.getTemplateId())) {
                    template.select(template.indexOf((String)map.get(CreateInstanceByTemplateAction.this.template.getTemplateId())));
                }
                template.setEnabled(true);
                editArgument.setEnabled(true);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateInstanceConfirm)) {
                ICloudInstance instance;
                String detailJson;
                CreateInstanceDialog.Model m = dialog.getOutput();
                IAccountResource.IRegion r = this.templateManager.getAccountResource().getRegion(this.template.getRegion());
                CreateInstanceDialog.InstanceDetail detail = new CreateInstanceDialog.InstanceDetail();
                detail.subnetId = m.getSubnet() != null ? m.getSubnet().getSubnetId() : null;
                detail.keyName = m.getKeyName();
                detail.monitoring = m.getMonitoring();
                detail.disableApiTermination = m.getDisableApiTermination();
                detail.instanceInitiatedShutdownBehavior = m.getInstanceInitiatedShutdownBehavior();
                detail.ebsOptimized = m.getEbsOptimized();
                if (m.getRootBlockDevice() != null) {
                    detail.rootBlockDevice = new CreateInstanceDialog.EbsBlockDevice();
                    detail.rootBlockDevice.volumeSize = m.getRootBlockDevice().volumeSize;
                    detail.rootBlockDevice.volumeType = m.getRootBlockDevice().volumeType;
                    detail.rootBlockDevice.deleteOnTermination = m.getRootBlockDevice().deleteOnTermination;
                }
                if (m.getSecurityGroups() != null) {
                    detail.securityGroupIds = new ArrayList<String>();
                    for (GroupIdentifier securityGroup : m.getSecurityGroups()) {
                        detail.securityGroupIds.add(securityGroup.getGroupId());
                    }
                }
                ObjectMapper om = new ObjectMapper();
                ObjectWriter dw = om.writerWithType(CreateInstanceDialog.InstanceDetail.class);
                try {
                    detailJson = dw.writeValueAsString((Object)detail);
                }
                catch (Exception e) {
                    throw new CloudModelException((Throwable)e);
                }
                if (m.isTemplateUsed().booleanValue()) {
                    CreateCloudInstanceByTemplateRequest request = new CreateCloudInstanceByTemplateRequest();
                    request.setZone(m.getZone());
                    request.setTemplateId(m.getTemplateId());
                    request.setFlavor(m.getFlavor());
                    request.setFacilityId(m.getFacilityId());
                    request.setFacilityName(m.getFacilityName());
                    request.setDescription(m.getDescription());
                    request.setNodeName(m.getNodeName());
                    request.setReplaceNode(m.getReplaceNode());
                    request.setArguments(m.getArguments());
                    request.setTags(m.getTags());
                    request.setInstanceDetail(detailJson);
                    instance = ((ICloudComputeService)r.getAccountResource().getRegion(m.getRegionName()).getCloudService(ICloudComputeService.class)).getInstanceManager().createCloudInstanceByTemplate(request);
                } else {
                    CreateCloudInstanceRequest request = new CreateCloudInstanceRequest();
                    request.setZone(m.getZone());
                    if (m.getImage() != null) {
                        request.setImageId(m.getImage().getImageId());
                    }
                    request.setFlavor(m.getFlavor());
                    request.setFacilityId(m.getFacilityId());
                    request.setFacilityName(m.getFacilityName());
                    request.setDescription(m.getDescription());
                    request.setNodeName(m.getNodeName());
                    request.setReplaceNode(m.getReplaceNode());
                    request.setInstanceDetail(detailJson);
                    instance = ((ICloudComputeService)r.getAccountResource().getRegion(m.getRegionName()).getCloudService(ICloudComputeService.class)).getInstanceManager().createCloudInstance(request);
                }
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateInstanceResult);
                view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, new ICloudInstance.StateType[]{ICloudInstance.StateType.running, ICloudInstance.StateType.terminated, ICloudInstance.StateType.stopped});
                        FacilityTree.refresh();
                    }
                });
            } else {
                return;
            }
        }
    }
}

