/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.views.actions;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.ui.dialogs.AttachStorageFromStorageDialog;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AttachStorageFromStorageAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgAttachStorageConfirm = this.messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.attach"});
    private String msgAttachStorageResult = this.messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.attach"});

    protected void invoke(IAction action) throws InvocationException {
        ICloudStorage storage = (ICloudStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        AttachStorageFromStorageDialog dialog = new AttachStorageFromStorageDialog(this.viewPart.getSite().getShell(), storage);
        if (dialog.open() == 0 && MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.msgAttachStorageConfirm + "\n" + storage.getStorageId()))) {
            storage.attach(dialog.getInstanceId(), dialog.getDeviceName());
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgAttachStorageResult);
        }
    }

    protected boolean canEnabled(IStructuredSelection selection) {
        for (ICloudStorage storage : selection) {
            if (storage.getStorageAttachment() == null && !storage.getRegistState().equals(ICloudStorage.RegistStateType.deleted.name())) continue;
            return false;
        }
        return true;
    }
}

