/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.dialogs;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.BlockDeviceMapping;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class DetachStorageFromInstanceDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strAvailabilityZone = this.messages.getString("word.availability_zone");
    private String strInstance = this.messages.getString("word.instance");
    private String strDevice = this.messages.getString("word.device");
    private String strVolumeId = this.messages.getString("word.volume_id");
    private String strVolumeName = this.messages.getString("word.volume_name");
    private String strSnapshotId = this.messages.getString("word.snapshot_id");
    private String strSize = this.messages.getString("word.size");
    private String strVolumeType = this.messages.getString("word.storage_type");
    private String strDetachStorageDialog = this.messages.getString("caption.detach_storage_dialog");
    private String msgMustFullyInput = this.messages.getString("message.must_fully_input");
    private ICloudInstance instance;
    private List<ICloudStorage> volumes = new ArrayList<ICloudStorage>();
    private Table table;
    private TableViewer tableViewer;
    private Text availabilityZone;
    private Text instanceName;

    public DetachStorageFromInstanceDialog(Shell parentShell, ICloudInstance instance) {
        super(parentShell);
        this.instance = instance;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(2, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblAvailabilityZone = new Label(container, 0);
        lblAvailabilityZone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAvailabilityZone.setText(this.strAvailabilityZone + this.strSeparator);
        this.availabilityZone = new Text(container, 2056);
        this.availabilityZone.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.availabilityZone.setText(this.instance.getZone());
        Label lblInstance = new Label(container, 0);
        lblInstance.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblInstance.setText(this.strInstance);
        this.instanceName = new Text(container, 2056);
        this.instanceName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.instanceName.setText(this.instance.getInstanceId());
        this.table = new Table(container, 67586);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn tblclmnVolumeId = new TableColumn(this.table, 0);
        tblclmnVolumeId.setWidth(90);
        tblclmnVolumeId.setText(this.strVolumeId);
        TableColumn tableColumn_6 = new TableColumn(this.table, 0);
        tableColumn_6.setWidth(70);
        tableColumn_6.setText(this.strVolumeName);
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(70);
        tableColumn_1.setText(this.strDevice);
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(70);
        tableColumn_2.setText(this.strSnapshotId);
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(70);
        tableColumn_3.setText(this.strSize);
        TableColumn tableColumn_4 = new TableColumn(this.table, 0);
        tableColumn_4.setWidth(70);
        tableColumn_4.setText(this.strVolumeType);
        this.tableViewer = new TableViewer(this.table);
        VolumeProvider vp = new VolumeProvider();
        this.tableViewer.setContentProvider((IContentProvider)vp.getVolumeContentProvider());
        this.instance.getCloudInstanceManager().getCloudComputeService().getStorageManager().update();
        ArrayList<ICloudStorage> storages = new ArrayList<ICloudStorage>();
        block0: for (ICloudStorage s : this.instance.getCloudInstanceManager().getCloudComputeService().getStorageManager().getCloudStorages()) {
            for (BlockDeviceMapping d : this.instance.getBlockDeviceMappings()) {
                if (!d.getVolumeId().equals(s.getStorageId())) continue;
                storages.add(s);
                continue block0;
            }
        }
        this.tableViewer.setInput(storages);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)vp.getVolumeLabelProvider());
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetachStorageFromInstanceDialog.this.volumes.clear();
                for (TableItem ti : DetachStorageFromInstanceDialog.this.table.getSelection()) {
                    DetachStorageFromInstanceDialog.this.volumes.add((ICloudStorage)ti.getData());
                }
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if (this.volumes.isEmpty()) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgMustFullyInput);
            return;
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strDetachStorageDialog);
    }

    public List<String> getVolumes() {
        ArrayList<String> storageIds = new ArrayList<String>();
        for (ICloudStorage storage : this.volumes) {
            storageIds.add(storage.getStorageId());
        }
        return storageIds;
    }

    public static class VolumeProvider {
        private VolumeContentProvider vcp = new VolumeContentProvider();
        private VolumeLabelProvider vlp = new VolumeLabelProvider();

        public VolumeContentProvider getVolumeContentProvider() {
            return this.vcp;
        }

        public VolumeLabelProvider getVolumeLabelProvider() {
            return this.vlp;
        }

        public class VolumeLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public String getColumnText(Object element, int columnIndex) {
                ICloudStorage storage = (ICloudStorage)element;
                switch (columnIndex) {
                    case 0: {
                        return storage.getStorageId();
                    }
                    case 1: {
                        return storage.getStorageName();
                    }
                    case 2: {
                        return storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "";
                    }
                    case 3: {
                        return storage.getSnapshotId() != null ? storage.getSnapshotId() : "";
                    }
                    case 4: {
                        return storage.getSize() != null ? String.valueOf(storage.getSize()) : "";
                    }
                    case 5: {
                        return storage.getFlavor();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        }

        public class VolumeContentProvider
        implements IStructuredContentProvider {
            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

