/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.dialogs;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.Filter;
import com.clustercontrol.cloud.aws.base.resources.Snapshot;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.CreateStorageRequest;
import com.clustercontrol.util.Messages;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateStorageDialog
extends Dialog {
    private static final int minStorageSize = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.minstoragesize"));
    private static final int multiply = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.multiply"));
    private static final int minIops = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.miniops"));
    private static final int maxIops = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.maxiops"));
    private static final int skip = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.skip"));
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strStorageName = this.messages.getString("word.storage_name");
    private String strStorageSize = this.messages.getString("word.storage_size");
    private String strSnapshot = this.messages.getString("word.snapshot");
    private String strVolumeType = this.messages.getString("word.volume_type");
    private String strRegion = this.messages.getString("word.region");
    private String strIops = this.messages.getString("word.iops");
    private String strCreateStorageDialog = this.messages.getString("caption.create_storage_dialog");
    private String strAvailabilityZone = this.messages.getString("word.availability_zone");
    private String msgMustFullyInput = this.messages.getString("message.must_fully_input");
    private String msgIopsMustBeLessThanXTimesOfVolumeSize = this.messages.getString("message.must_grater_than_X", new String[]{Integer.toString(multiply), Integer.toString(minStorageSize)});
    private String msgAvailableIopsRange = this.messages.getString("message.iops_must_be_less_than_X_times_of_volume_size", new Object[]{Integer.toString(minIops), Integer.toString(maxIops)});
    private static final String IOPS_VALUE = "io1";
    private Text txtVolumeName;
    private Text txtSize;
    private Combo cmbUnitSize;
    private Combo cmbAvailabilityZone;
    private Combo cmbSnapshot;
    private Combo cmbVolumeType;
    private Combo cmbIops;
    private ControlDecoration ctdcIops;
    private ControlDecoration ctdcSize;
    private Label lblRegion;
    private Combo cmbRegion;
    private CloudResourceProvider provider;
    private DialogData input = new DialogData();
    private DialogData output = new DialogData();
    private IDialogBehavior behavior;
    private Decorator decorator;

    public CreateStorageDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(4, false);
        gl_container.horizontalSpacing = 15;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblVolumeName = new Label(container, 0);
        lblVolumeName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVolumeName.setText(this.strStorageName + this.strSeparator);
        this.txtVolumeName = new Text(container, 2048);
        this.txtVolumeName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblSize = new Label(container, 0);
        lblSize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSize.setText(this.strStorageSize + this.strSeparator);
        this.txtSize = new Text(container, 2048);
        GridData gd_size = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_size.widthHint = 146;
        this.txtSize.setLayoutData((Object)gd_size);
        this.ctdcSize = new ControlDecoration((Control)this.txtSize, 16512);
        this.ctdcSize.setImage(ResourceManager.getPluginImage((String)Activator.ID, (String)"icons/error.gif"));
        this.ctdcSize.setDescriptionText("");
        this.ctdcSize.hide();
        this.cmbUnitSize = new Combo(container, 8);
        GridData gd_unitSize = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_unitSize.widthHint = 124;
        this.cmbUnitSize.setLayoutData((Object)gd_unitSize);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        this.lblRegion = new Label(container, 0);
        this.lblRegion.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblRegion.setText(this.strRegion + this.strSeparator);
        this.cmbRegion = new Combo(container, 8);
        this.cmbRegion.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblAvailabilityzone = new Label(container, 0);
        lblAvailabilityzone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAvailabilityzone.setText(this.strAvailabilityZone + this.strSeparator);
        this.cmbAvailabilityZone = new Combo(container, 8);
        this.cmbAvailabilityZone.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblSnapshot = new Label(container, 0);
        lblSnapshot.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSnapshot.setText(this.strSnapshot + this.strSeparator);
        this.cmbSnapshot = new Combo(container, 8);
        GridData gd_snapshot = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_snapshot.widthHint = 570;
        this.cmbSnapshot.setLayoutData((Object)gd_snapshot);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblVolumeType = new Label(container, 0);
        lblVolumeType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVolumeType.setText(this.strVolumeType + this.strSeparator);
        this.cmbVolumeType = new Combo(container, 8);
        GridData gd_volumeType = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_volumeType.widthHint = 220;
        this.cmbVolumeType.setLayoutData((Object)gd_volumeType);
        Label lblIops = new Label(container, 0);
        lblIops.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblIops.setText(this.strIops + this.strSeparator);
        this.cmbIops = new Combo(container, 2048);
        GridData gd_iops = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_iops.widthHint = 208;
        this.cmbIops.setLayoutData((Object)gd_iops);
        this.ctdcIops = new ControlDecoration((Control)this.cmbIops, 16512);
        this.ctdcIops.setImage(ResourceManager.getPluginImage((String)Activator.ID, (String)"icons/error.gif"));
        this.ctdcIops.hide();
        this.cmbUnitSize.add("GiB");
        this.cmbUnitSize.add("TiB");
        this.cmbUnitSize.select(0);
        this.cmbIops.setEnabled(false);
        this.behavior.setProvider(this.provider);
        this.behavior.setupVolumeName(this.txtVolumeName);
        this.behavior.setupSize(this.txtSize, this.cmbUnitSize);
        this.behavior.setupRegion(this.cmbRegion);
        this.behavior.setupAvailabilityZone(this.cmbAvailabilityZone);
        this.behavior.setupSnapshot(this.cmbSnapshot);
        this.behavior.setupVolumeType(this.cmbVolumeType);
        this.behavior.setupIops(this.cmbIops);
        this.txtSize.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!"".equals(CreateStorageDialog.this.txtSize.getText())) {
                    String n = CreateStorageDialog.this.cmbIops.getText();
                    CreateStorageDialog.this.cmbIops.removeAll();
                    for (int iops = skip; iops <= maxIops; iops += skip) {
                        CreateStorageDialog.this.cmbIops.add(Integer.toString(iops));
                    }
                    CreateStorageDialog.this.cmbIops.setText(n);
                }
            }
        });
        this.txtSize.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    String t = CreateStorageDialog.this.txtSize.getText().substring(0, e.start) + e.text + CreateStorageDialog.this.txtSize.getText().substring(e.start);
                    if (t.length() != 0) {
                        Integer.valueOf(t);
                    }
                }
                catch (Exception e1) {
                    e.doit = false;
                }
            }
        });
        this.txtSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateStorageDialog.this.checkIops();
            }
        });
        this.cmbVolumeType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateStorageDialog.this.cmbVolumeType.getText().equals(CreateStorageDialog.this.messages.getString(CreateStorageDialog.IOPS_VALUE))) {
                    CreateStorageDialog.this.cmbIops.setEnabled(true);
                    CreateStorageDialog.this.decorator.setEnabled(true);
                } else {
                    CreateStorageDialog.this.decorator.setEnabled(false);
                    CreateStorageDialog.this.cmbIops.setEnabled(false);
                }
                CreateStorageDialog.this.checkIops();
            }
        });
        this.cmbIops.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateStorageDialog.this.checkIops();
            }
        });
        this.cmbIops.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    String t = CreateStorageDialog.this.cmbIops.getText().substring(0, e.start) + e.text + CreateStorageDialog.this.cmbIops.getText().substring(e.start);
                    if (t.length() != 0) {
                        Integer.valueOf(t);
                    }
                }
                catch (Exception e1) {
                    e.doit = false;
                }
            }
        });
        this.decorator = new Decorator(this.cmbIops);
        ControlUtil.setRequired((Control[])new Control[]{this.txtVolumeName, this.txtSize});
        if (this.input != null) {
            if (this.input.getZone() != null) {
                this.cmbAvailabilityZone.setText(this.input.getZone());
            }
            if (this.input.getStorageSize() != null) {
                this.txtSize.setText(this.input.getStorageSize().toString());
            }
            if (this.input.getIops() != null) {
                this.cmbIops.setText(this.input.getIops().toString());
            }
            if (this.input.getFlavor() != null) {
                for (int i = 0; i < this.cmbVolumeType.getItems().length; ++i) {
                    if (!this.input.getFlavor().equals(this.cmbVolumeType.getData(this.cmbVolumeType.getItems()[i]))) continue;
                    this.cmbVolumeType.select(i);
                    if (this.cmbVolumeType.getText().equals(this.messages.getString(IOPS_VALUE))) {
                        this.cmbIops.setEnabled(true);
                        this.decorator.setEnabled(true);
                    } else {
                        this.decorator.setEnabled(false);
                        this.cmbIops.setEnabled(false);
                    }
                    this.checkIops();
                    break;
                }
            }
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if ("".equals(this.txtVolumeName.getText()) || "".equals(this.txtSize.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgMustFullyInput);
            return;
        }
        this.output = new DialogData();
        this.output.setStorageName(this.txtVolumeName.getText());
        this.output.setStorageSize(Integer.parseInt(this.txtSize.getText()));
        this.output.setRegion((String)this.cmbRegion.getData(this.cmbRegion.getText()));
        this.output.setZone(this.cmbAvailabilityZone.getText());
        this.output.setSnapshotId((String)this.cmbSnapshot.getData(this.cmbSnapshot.getText()));
        this.output.setFlavor((String)this.cmbVolumeType.getData(this.cmbVolumeType.getText()));
        if (this.messages.getString(IOPS_VALUE).equals(this.cmbVolumeType.getText())) {
            this.output.setIops("".equals(this.cmbIops.getText()) || this.cmbIops.getText() == null ? null : Integer.valueOf(Integer.parseInt(this.cmbIops.getText())));
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strCreateStorageDialog);
    }

    public void checkIops() {
        if (this.messages.getString(IOPS_VALUE).equals(this.cmbVolumeType.getText()) && (this.cmbIops.getText().isEmpty() || Integer.parseInt(this.cmbIops.getText()) < minIops || Integer.parseInt(this.cmbIops.getText()) > maxIops)) {
            this.ctdcIops.show();
            this.ctdcIops.setShowHover(true);
            this.ctdcIops.setDescriptionText(this.msgAvailableIopsRange);
            this.ctdcIops.showHoverText(this.msgAvailableIopsRange);
        } else {
            this.ctdcIops.hide();
            this.ctdcIops.setDescriptionText("");
            this.ctdcIops.showHoverText("");
            this.ctdcIops.setShowHover(false);
        }
        if (this.messages.getString(IOPS_VALUE).equals(this.cmbVolumeType.getText()) && (this.txtSize.getText().isEmpty() && !this.cmbIops.getText().isEmpty() || !this.txtSize.getText().isEmpty() && !this.cmbIops.getText().isEmpty() && Integer.parseInt(this.txtSize.getText()) * multiply < Integer.parseInt(this.cmbIops.getText()) || Integer.parseInt(this.txtSize.getText()) < minStorageSize)) {
            this.ctdcSize.show();
            this.ctdcSize.setShowHover(true);
            this.ctdcSize.setDescriptionText(this.msgIopsMustBeLessThanXTimesOfVolumeSize);
            this.ctdcSize.showHoverText(this.msgIopsMustBeLessThanXTimesOfVolumeSize);
        } else {
            this.ctdcSize.hide();
            this.ctdcSize.setDescriptionText("");
            this.ctdcSize.showHoverText("");
            this.ctdcSize.setShowHover(false);
        }
    }

    public DialogData getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public void setInput(DialogData input) {
        this.input = input;
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
        private CloudResourceProvider provider;
        private Combo cmbRegion;
        private Combo cmbAvailabilityZone;
        private Combo cmbSnapshot;

        @Override
        public void setProvider(CloudResourceProvider provider) {
            this.provider = provider;
        }

        @Override
        public void setupVolumeName(Text txtVolumeName) {
        }

        @Override
        public void setupSize(Text txtSize, Combo txtUnit) {
        }

        @Override
        public void setupRegion(final Combo cmbRegion) {
            this.cmbRegion = cmbRegion;
            cmbRegion.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String region = (String)cmbRegion.getData(cmbRegion.getText());
                    if (DialogBehavior.this.cmbAvailabilityZone != null) {
                        List<AvailabilityZone> avs = DialogBehavior.this.provider.getAvailabilityZones(region);
                        DialogBehavior.this.cmbAvailabilityZone.removeAll();
                        for (AvailabilityZone name : avs) {
                            DialogBehavior.this.cmbAvailabilityZone.add(name.getZoneName());
                        }
                        if (!avs.isEmpty()) {
                            DialogBehavior.this.cmbAvailabilityZone.select(0);
                        }
                    }
                    if (DialogBehavior.this.cmbSnapshot != null) {
                        DialogBehavior.this.cmbSnapshot.removeAll();
                        DialogBehavior.this.cmbSnapshot.add("--- No Snapshot ---");
                        DialogBehavior.this.cmbSnapshot.select(0);
                    }
                }
            });
            for (String regionName : this.provider.getAllRegion()) {
                String regionLocaleName = this.messages.getString(regionName);
                cmbRegion.add(regionLocaleName);
                cmbRegion.setData(regionLocaleName, (Object)regionName);
            }
            if (cmbRegion.getItemCount() > 0) {
                cmbRegion.select(0);
            }
        }

        @Override
        public void setupAvailabilityZone(Combo cmbAvailabilityZone) {
            this.cmbAvailabilityZone = cmbAvailabilityZone;
            if (this.cmbRegion != null) {
                String region = (String)this.cmbRegion.getData(this.cmbRegion.getText());
                List<AvailabilityZone> avs = this.provider.getAvailabilityZones(region);
                cmbAvailabilityZone.removeAll();
                for (AvailabilityZone name : avs) {
                    cmbAvailabilityZone.add(name.getZoneName());
                }
                if (!avs.isEmpty()) {
                    cmbAvailabilityZone.select(0);
                }
            }
        }

        @Override
        public void setupSnapshot(final Combo cmbSnapshot) {
            this.cmbSnapshot = cmbSnapshot;
            cmbSnapshot.add("--- No Snapshot ---");
            cmbSnapshot.select(0);
            cmbSnapshot.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (cmbSnapshot.getItemCount() <= 1) {
                        List<Snapshot> snapshots = DialogBehavior.this.provider.getSnapshots((String)DialogBehavior.this.cmbRegion.getData(DialogBehavior.this.cmbRegion.getText()), Arrays.asList(new Filter[0]));
                        for (Snapshot s : snapshots) {
                            String snapshotName = s.getSnapshotId() + " -- " + s.getDescription();
                            cmbSnapshot.add(snapshotName);
                            cmbSnapshot.setData(snapshotName, (Object)s);
                        }
                    }
                }
            });
        }

        @Override
        public void setupVolumeType(Combo volumeType) {
            for (String volumeTypeName : this.provider.getAllVolumeType()) {
                String volumeTypeLocaleName = this.messages.getString(volumeTypeName);
                volumeType.add(volumeTypeLocaleName);
                volumeType.setData(volumeTypeLocaleName, (Object)volumeTypeName);
            }
            volumeType.select(0);
        }

        @Override
        public void setupIops(Combo Iops) {
        }
    }

    public static interface IDialogBehavior {
        public void setProvider(CloudResourceProvider var1);

        public void setupVolumeName(Text var1);

        public void setupSize(Text var1, Combo var2);

        public void setupRegion(Combo var1);

        public void setupAvailabilityZone(Combo var1);

        public void setupSnapshot(Combo var1);

        public void setupVolumeType(Combo var1);

        public void setupIops(Combo var1);
    }

    public static class DialogData
    extends CreateStorageRequest {
        private String region;
        private Integer iops;

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public Integer getIops() {
            return this.iops;
        }

        public void setIops(Integer iops) {
            this.iops = iops;
        }
    }

    public static class StorageDetail {
        public Integer iops;
    }

    public static class Decorator {
        private Combo control;
        private static ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Combo)e.getSource()).getText().equals("")) {
                    ((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    ((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
            }
        };

        public Decorator(Combo control) {
            this.control = control;
            this.setEnabled(false);
        }

        public void setEnabled(boolean enable) {
            if (enable) {
                if (this.control.getText().equals("")) {
                    this.control.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    this.control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
                this.control.addModifyListener(modifyListener);
            } else {
                this.control.removeModifyListener(modifyListener);
                this.control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        }
    }
}

