/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.ui.views.AbstractCloudViewPart;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class AsyncUpdateViewPart
extends AbstractCloudViewPart {
    protected <T, S> void update(final DataHolder<T, S> item, final boolean force) {
        Object targetState = null;
        try {
            if (!item.prepare()) {
                return;
            }
            targetState = item.getTargetState();
            if (targetState == null || !force && item.isInitialized(targetState)) {
                item.success();
                return;
            }
            item.startAsyncCall(targetState);
        }
        catch (Exception e) {
            item.failPrepareAsyncCall(e);
            return;
        }
        final Object fTargetState = targetState;
        this.getExecutor().getQueue().clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object data = null;
                Exception exception = null;
                if (!item.isInitialized(fTargetState) || force) {
                    try {
                        data = item.asyncGetData(fTargetState);
                    }
                    catch (Exception e) {
                        exception = e;
                        e.printStackTrace();
                    }
                }
                final Object fData = data;
                final Exception fException = exception;
                AsyncUpdateViewPart.this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Exception exception = fException;
                        if (exception == null) {
                            try {
                                if (fData == null) {
                                    throw new NullPointerException();
                                }
                                item.syncSetData(fTargetState, fData);
                            }
                            catch (Exception e) {
                                exception = e;
                                item.failAsyncCall(fTargetState, exception);
                            }
                        } else {
                            item.failAsyncCall(fTargetState, exception);
                        }
                        if (item.getTargetState() == fTargetState) {
                            if (exception == null) {
                                item.success();
                            } else {
                                item.error(exception);
                            }
                        }
                    }
                });
            }
        };
        this.getExecutor().execute(runnable);
    }

    public abstract void update();

    protected abstract ThreadPoolExecutor getExecutor();

    static interface DataHolder<T, S> {
        public S getTargetState();

        public S getCurrentState();

        public T asyncGetData(S var1) throws Exception;

        public boolean isInitialized(S var1);

        public boolean prepare();

        public void startAsyncCall(S var1);

        public void failAsyncCall(S var1, Exception var2);

        public void failPrepareAsyncCall(Exception var1);

        public void syncSetData(S var1, T var2);

        public void success();

        public void error(Exception var1);
    }
}

