/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.util;

import com.clustercontrol.snmptrap.bean.SnmpTrapV1;

/**
 * snmptrapを受信した際の処理を定義するクラス
 * @author takahatat
 */
public interface SnmpTrapHandler {

	/**
	 * SnmpTrapReceiverがsnmptrapを受信する度、そのsnmptrapを引数としてこのAPIが呼ばれる。
	 * なお、非同期で呼ばれないため、この処理が終了するまで次のsnmptrapは処理されない。
	 * @param snmptrap SnmpTrapReceiverが受信したsnmptrap
	 */
	public void snmptrapReceived(SnmpTrapV1 snmptrap);

	/**
	 * SnmpTrapReceiverのstartが呼ばれた際に呼ばれるAPI。
	 * snmptrapReceivedが呼ばれる前に初期化処理が必要な場合に実装する。
	 */
	public void start();

	/**
	 * SnmpTrapReceiverのshutdownが呼ばれた際に呼ばれるAPI。
	 * 各種リソースの解放処理などで終了処理が必要な場合に実装する。
	 */
	public void shutdown();

}
