/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import javax.xml.bind.annotation.XmlType;



/**
 * 一括制御のコマンドパラメータを保持するクラスです。<BR>
 * 一括制御[作成・変更]ダイアログから設定します。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class CommandParameterInfo extends ItemInfo {
	private static final long serialVersionUID = -3103296281401828154L;

	/** パラメータID */
	private String id;

	/** 接頭語 */
	private String prefix;

	private ParameterInfo paramMst = null;

	/**
	 * @return
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return
	 */
	public String getPrefix() {
		return prefix;
	}

	/**
	 * @param command
	 */
	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	/**
	 * @return
	 */
	public ParameterInfo getParamMst() {
		return paramMst;
	}

	/**
	 * @param command
	 */
	public void setParamMst(ParameterInfo paramMst) {
		this.paramMst = paramMst;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 * @since 2.1.0
	 */
	@Override
	public Object clone() {
		CommandParameterInfo clone = (CommandParameterInfo)super.clone();

		clone.setId(this.getId());
		clone.setPrefix(this.getPrefix());

		return clone;
	}
}