/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.swtcalendar;

import com.clustercontrol.ws.calendar.Ymd;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.vafada.swtcalendar.SWTCalendarEvent;
import org.vafada.swtcalendar.SWTCalendarListener;

public class SWTDayChooser
extends Composite
implements MouseListener,
FocusListener,
TraverseListener,
KeyListener {
    public static final int RED_SUNDAY = 0x1000000;
    public static final int RED_SATURDAY = 0x10000000;
    public static final int RED_WEEKEND = 0x11000000;
    private Label[] dayTitles;
    private DayControl[] days;
    private int dayOffset;
    private Color activeSelectionBackground;
    private Color inactiveSelectionBackground;
    private Color activeSelectionForeground;
    private Color inactiveSelectionForeground;
    private Color otherMonthColor;
    private Calendar calendar;
    private Calendar today;
    private Locale locale;
    private List listeners;
    private int style;
    private ArrayList<Ymd> dateList;

    public SWTDayChooser(Composite parent, int style) {
        super(parent, style & 0xEEFFFFFF);
        this.style = style;
        this.listeners = new ArrayList(3);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.otherMonthColor = new Color((Device)this.getDisplay(), 128, 128, 128);
        this.activeSelectionBackground = this.getDisplay().getSystemColor(26);
        this.inactiveSelectionBackground = this.getDisplay().getSystemColor(15);
        this.activeSelectionForeground = this.getDisplay().getSystemColor(27);
        this.inactiveSelectionForeground = this.getForeground();
        this.locale = Locale.getDefault();
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 7;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.dayTitles = new Label[7];
        int i = 0;
        while (i < this.dayTitles.length) {
            Label label;
            this.dayTitles[i] = label = new Label((Composite)this, 0x1000000);
            label.setLayoutData((Object)new GridData(256));
            label.addMouseListener((MouseListener)this);
            ++i;
        }
        Composite spacer = new Composite((Composite)this, 524288);
        spacer.setBackground(this.getBackground());
        GridData gridData = new GridData(768);
        gridData.heightHint = 2;
        gridData.horizontalSpan = 7;
        spacer.setLayoutData((Object)gridData);
        spacer.setLayout((Layout)new GridLayout());
        spacer.addMouseListener((MouseListener)this);
        Label label = new Label((Composite)this, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 7;
        label.setLayoutData((Object)gridData);
        this.days = new DayControl[42];
        i = 0;
        while (i < this.days.length) {
            DayControl day;
            this.days[i] = day = new DayControl(this);
            day.setLayoutData(new GridData(272));
            day.addMouseListener(this);
            ++i;
        }
        this.setTabList(new Control[0]);
        this.setFont(parent.getFont());
        this.init();
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addTraverseListener(this);
        this.addKeyListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SWTDayChooser.this.otherMonthColor.dispose();
            }
        });
    }

    protected void init() {
        this.calendar = Calendar.getInstance(this.locale);
        this.calendar.setLenient(true);
        this.today = (Calendar)this.calendar.clone();
        int firstDayOfWeek = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] dayNames = dateFormatSymbols.getShortWeekdays();
        int minLength = Integer.MAX_VALUE;
        int i = 0;
        while (i < dayNames.length) {
            int len = dayNames[i].length();
            if (len > 0 && len < minLength) {
                minLength = len;
            }
            ++i;
        }
        if (minLength > 2) {
            i = 0;
            while (i < dayNames.length) {
                if (dayNames[i].length() > 0) {
                    dayNames[i] = dayNames[i].substring(0, 1);
                }
                ++i;
            }
        }
        int d = firstDayOfWeek;
        int i2 = 0;
        while (i2 < this.dayTitles.length) {
            Label label = this.dayTitles[i2];
            label.setText(dayNames[d]);
            label.setBackground(this.getBackground());
            if (d == 1 && (this.style & 0x1000000) != 0 || d == 7 && (this.style & 0x10000000) != 0) {
                label.setForeground(this.getDisplay().getSystemColor(4));
            } else {
                label.setForeground(this.getForeground());
            }
            if (++d > this.dayTitles.length) {
                d -= this.dayTitles.length;
            }
            ++i2;
        }
        this.drawDays();
    }

    protected void drawDays() {
        this.calendar.get(6);
        Calendar cal = (Calendar)this.calendar.clone();
        int firstDayOfWeek = cal.getFirstDayOfWeek();
        cal.set(5, 1);
        this.dayOffset = firstDayOfWeek - cal.get(7);
        if (this.dayOffset >= 0) {
            this.dayOffset -= 7;
        }
        cal.add(5, this.dayOffset);
        Color foregroundColor = this.getForeground();
        int i = 0;
        while (i < this.days.length) {
            DayControl dayControl = this.days[i++];
            dayControl.setText(Integer.toString(cal.get(5)));
            if (SWTDayChooser.isSameDay(cal, this.today)) {
                dayControl.setBorderColor(this.getDisplay().getSystemColor(2));
            } else {
                dayControl.setBorderColor(this.getBackground());
            }
            if (SWTDayChooser.isSameMonth(cal, this.calendar)) {
                int d = cal.get(7);
                if (d == 1 && (this.style & 0x1000000) != 0 || d == 7 && (this.style & 0x10000000) != 0) {
                    dayControl.setForeground(this.getDisplay().getSystemColor(4));
                } else {
                    dayControl.setForeground(foregroundColor);
                }
            } else {
                dayControl.setForeground(this.otherMonthColor);
            }
            if (SWTDayChooser.isSameDay(cal, this.calendar)) {
                dayControl.setBackground(this.getSelectionBackgroundColor());
                dayControl.setForeground(this.getSelectionForegroundColor());
            } else {
                dayControl.setBackground(this.getBackground());
            }
            cal.add(5, 1);
        }
    }

    protected void drawMultipleDays() {
        this.calendar.get(6);
        Calendar cal = (Calendar)this.calendar.clone();
        int firstDayOfWeek = cal.getFirstDayOfWeek();
        cal.set(5, 1);
        this.dayOffset = firstDayOfWeek - cal.get(7);
        if (this.dayOffset >= 0) {
            this.dayOffset -= 7;
        }
        cal.add(5, this.dayOffset);
        Color foregroundColor = this.getForeground();
        int i = 0;
        while (i < this.days.length) {
            DayControl dayControl = this.days[i++];
            dayControl.setText(Integer.toString(cal.get(5)));
            if (SWTDayChooser.isSameDay(cal, this.today)) {
                dayControl.setBorderColor(this.getDisplay().getSystemColor(2));
            } else {
                dayControl.setBorderColor(this.getBackground());
            }
            if (SWTDayChooser.isSameMonth(cal, this.calendar)) {
                int d = cal.get(7);
                if (d == 1 && (this.style & 0x1000000) != 0 || d == 7 && (this.style & 0x10000000) != 0) {
                    dayControl.setForeground(this.getDisplay().getSystemColor(4));
                } else {
                    dayControl.setForeground(foregroundColor);
                }
            } else {
                dayControl.setForeground(this.otherMonthColor);
            }
            dayControl.setBackground(this.getBackground());
            if (this.dateList != null) {
                for (Ymd ymd : this.dateList) {
                    String ymdYMD;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/M");
                    String selectYMD = String.valueOf(sdf.format(this.calendar.getTime())) + "/" + dayControl.getText();
                    if (!selectYMD.equals(ymdYMD = this.yyyyMMdd(ymd)) || dayControl.label.getForeground().equals((Object)this.otherMonthColor)) continue;
                    dayControl.setBackground(ColorConstants.lightBlue);
                    dayControl.setForeground(this.getSelectionForegroundColor());
                    break;
                }
            }
            cal.add(5, 1);
        }
    }

    private String yyyyMMdd(Ymd ymd) {
        return ymd.getYear() + "/" + ymd.getMonth() + "/" + ymd.getDay();
    }

    protected void update(ArrayList<Ymd> dateList) {
        this.dateList = new ArrayList();
        this.dateList = dateList;
        this.drawMultipleDays();
    }

    protected static boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1);
    }

    private static boolean isSameMonth(Calendar cal1, Calendar cal2) {
        return cal1.get(2) == cal2.get(2) && cal1.get(1) == cal2.get(1);
    }

    public void setMonth(int month) {
        this.calendar.set(2, month);
        if (this.dateList == null) {
            this.drawDays();
            this.dateChanged();
        } else {
            this.drawMultipleDays();
        }
    }

    public void setYear(int year) {
        this.calendar.set(1, year);
        if (this.dateList == null) {
            this.drawDays();
            this.dateChanged();
        } else {
            this.drawMultipleDays();
        }
    }

    public void setCalendar(Calendar cal) {
        this.calendar = (Calendar)cal.clone();
        this.calendar.setLenient(true);
        if (this.dateList == null) {
            this.drawDays();
            this.dateChanged();
        } else {
            this.drawMultipleDays();
        }
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1) {
            this.setFocus();
            if (event.widget instanceof DayControl) {
                int index = this.findDay(event.widget);
                this.selectDay(index + 1 + this.dayOffset);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseUp(MouseEvent event) {
    }

    public void focusGained(FocusEvent event) {
        DayControl selectedDay = this.getSelectedDayControl();
        selectedDay.setBackground(this.getSelectionBackgroundColor());
        selectedDay.setForeground(this.getSelectionForegroundColor());
    }

    public void focusLost(FocusEvent event) {
        DayControl selectedDay = this.getSelectedDayControl();
        selectedDay.setBackground(this.getSelectionBackgroundColor());
        selectedDay.setForeground(this.getSelectionForegroundColor());
    }

    public void keyTraversed(TraverseEvent event) {
        switch (event.detail) {
            case 32: 
            case 64: 
            case 256: 
            case 512: {
                event.doit = false;
                break;
            }
            case 8: 
            case 16: {
                event.doit = true;
            }
        }
    }

    public void keyPressed(KeyEvent event) {
        switch (event.keyCode) {
            case 0x1000003: {
                this.selectDay(this.calendar.get(5) - 1);
                break;
            }
            case 0x1000004: {
                this.selectDay(this.calendar.get(5) + 1);
                break;
            }
            case 0x1000001: {
                this.selectDay(this.calendar.get(5) - 7);
                break;
            }
            case 0x1000002: {
                this.selectDay(this.calendar.get(5) + 7);
                break;
            }
            case 0x1000005: {
                this.setMonth(this.calendar.get(2) - 1);
                break;
            }
            case 0x1000006: {
                this.setMonth(this.calendar.get(2) + 1);
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    private int findDay(Widget dayControl) {
        int i = 0;
        while (i < this.days.length) {
            if (this.days[i] == dayControl) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void selectDay(int day) {
        this.calendar.get(6);
        if (day >= this.calendar.getActualMinimum(5) && day <= this.calendar.getActualMaximum(5)) {
            int dayOfWeek = this.calendar.get(7);
            DayControl selectedDay = this.getSelectedDayControl();
            selectedDay.setBackground(this.getBackground());
            if (dayOfWeek == 1) {
                selectedDay.setForeground(this.getDisplay().getSystemColor(4));
            } else {
                selectedDay.setForeground(this.getForeground());
            }
            this.calendar.set(5, day);
            selectedDay = this.getSelectedDayControl();
            selectedDay.setBackground(this.getSelectionBackgroundColor());
            selectedDay.setForeground(this.getSelectionForegroundColor());
        } else {
            this.calendar.set(5, day);
            this.drawDays();
        }
        this.dateChanged();
    }

    private DayControl getSelectedDayControl() {
        return this.days[this.calendar.get(5) - 1 - this.dayOffset];
    }

    private Color getSelectionBackgroundColor() {
        return this.isFocusControl() ? this.activeSelectionBackground : this.inactiveSelectionBackground;
    }

    private Color getSelectionForegroundColor() {
        return this.isFocusControl() ? this.activeSelectionForeground : this.inactiveSelectionForeground;
    }

    public boolean isFocusControl() {
        Control control = this.getDisplay().getFocusControl();
        while (control != null) {
            if (control == this) {
                return true;
            }
            control = control.getParent();
        }
        return false;
    }

    public void addSWTCalendarListener(SWTCalendarListener listener) {
        this.listeners.add(listener);
    }

    public void removeSWTCalendarListener(SWTCalendarListener listener) {
        this.listeners.remove(listener);
    }

    private void dateChanged() {
        if (!this.listeners.isEmpty()) {
            SWTCalendarListener[] listenersArray = new SWTCalendarListener[this.listeners.size()];
            this.listeners.toArray(listenersArray);
            int i = 0;
            while (i < listenersArray.length) {
                Event event = new Event();
                event.widget = this;
                event.display = this.getDisplay();
                event.time = (int)System.currentTimeMillis();
                event.data = this.calendar.clone();
                listenersArray[i].dateChanged(new SWTCalendarEvent(event));
                ++i;
            }
        }
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendar.clone();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.init();
    }

    public void setFont(Font font) {
        super.setFont(font);
        int i = 0;
        while (i < this.dayTitles.length) {
            this.dayTitles[i].setFont(font);
            ++i;
        }
        i = 0;
        while (i < this.days.length) {
            this.days[i].setFont(font);
            ++i;
        }
    }

    private static class DayControl
    extends Composite
    implements Listener {
        private Composite filler;
        private Label label;

        public DayControl(Composite parent) {
            super(parent, 524288);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 1;
            gridLayout.marginHeight = 1;
            this.setLayout((Layout)gridLayout);
            this.filler = new Composite((Composite)this, 524288);
            this.filler.setLayoutData((Object)new GridData(1808));
            gridLayout = new GridLayout();
            gridLayout.marginWidth = 2;
            gridLayout.marginHeight = 0;
            this.filler.setLayout((Layout)gridLayout);
            this.filler.addListener(3, (Listener)this);
            this.filler.addListener(4, (Listener)this);
            this.filler.addListener(8, (Listener)this);
            this.label = new DayLabel(this.filler, 655360);
            this.label.setLayoutData((Object)new GridData(576));
            this.label.addListener(3, (Listener)this);
            this.label.addListener(4, (Listener)this);
            this.label.addListener(8, (Listener)this);
            this.setBorderColor(parent.getBackground());
            this.setBackground(parent.getBackground());
            this.setFont(parent.getFont());
        }

        public void setText(String text) {
            this.label.setText(text);
        }

        public String getText() {
            return this.label.getText();
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.filler.setFont(font);
            this.label.setFont(font);
        }

        public void setBackground(Color color) {
            this.filler.setBackground(color);
            this.label.setBackground(color);
        }

        public void setForeground(Color color) {
            this.label.setForeground(color);
        }

        public void setBorderColor(Color color) {
            super.setBackground(color);
        }

        public void handleEvent(Event event) {
            this.notifyListeners(event.type, event);
        }
    }

    private static class DayLabel
    extends Label {
        public DayLabel(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (wHint == -1) {
                GC gc = new GC((Drawable)this);
                wHint = gc.textExtent((String)"22").x;
                gc.dispose();
            }
            return super.computeSize(wHint, hHint, changed);
        }

        protected void checkSubclass() {
        }
    }
}

