/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmp.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.monitor.run.dialog.CommonMonitorNumericDialog;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.snmp.action.AddSnmp;
import com.clustercontrol.snmp.action.GetSnmp;
import com.clustercontrol.snmp.action.ModifySnmp;
import com.clustercontrol.snmp.bean.ConvertValueConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.SnmpCheckInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SnmpNumericCreateDialog
extends CommonMonitorNumericDialog {
    private Text m_textOid = null;
    private Combo m_comboConvertValue = null;

    public SnmpNumericCreateDialog(Shell parent) {
        super(parent);
    }

    public SnmpNumericCreateDialog(Shell parent, int monitorType) {
        super(parent);
        this.m_monitorType = monitorType;
    }

    public SnmpNumericCreateDialog(Shell parent, String monitorId, boolean updateFlg) {
        super(parent);
        this.monitorId = monitorId;
        this.updateFlg = updateFlg;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.item1 = Messages.getString((String)"select.value");
        this.item2 = Messages.getString((String)"select.value");
        super.customizeDialog(parent);
        this.shell.setText(Messages.getString((String)"dialog.snmp.create.modify"));
        Label label = null;
        GridData gridData = null;
        Group groupCheckRule = new Group((Composite)this.groupRule, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        groupCheckRule.setText(Messages.getString((String)"check.rule"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"oid")) + " : ");
        this.m_textOid = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textOid.setLayoutData((Object)gridData);
        this.m_textOid.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SnmpNumericCreateDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"convert.value")) + " : ");
        this.m_comboConvertValue = new Combo((Composite)groupCheckRule, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboConvertValue.setLayoutData((Object)gridData);
        this.m_comboConvertValue.add(ConvertValueConstant.STRING_NO);
        this.m_comboConvertValue.add(ConvertValueConstant.STRING_DELTA);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.itemName.setText(Messages.getString((String)"select.value"));
        this.measure.setText("");
        this.adjustDialog();
        MonitorInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorInfo();
            this.setInfoInitialValue(info);
        } else {
            info = new GetSnmp().getSnmp(this.monitorId);
        }
        this.setInputData(info);
    }

    @Override
    public void update() {
        super.update();
        if ("".equals(this.m_textOid.getText())) {
            this.m_textOid.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textOid.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    protected void setInputData(MonitorInfo monitor) {
        super.setInputData(monitor);
        this.inputData = monitor;
        SnmpCheckInfo snmpInfo = monitor.getSnmpCheckInfo();
        if (snmpInfo == null) {
            snmpInfo = new SnmpCheckInfo();
            snmpInfo.setConvertFlg(Integer.valueOf(1));
            snmpInfo.setSnmpVersion(SnmpVersionConstant.STRING_V1);
        }
        if (snmpInfo != null) {
            if (snmpInfo.getSnmpOid() != null) {
                this.m_textOid.setText(snmpInfo.getSnmpOid());
            }
            if (snmpInfo.getConvertFlg() != null) {
                this.m_comboConvertValue.setText(ConvertValueConstant.typeToString((int)snmpInfo.getConvertFlg()));
            }
            this.update();
        }
        this.m_numericValueInfo.setInputData(monitor);
    }

    @Override
    protected MonitorInfo createInputData() {
        super.createInputData();
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setMonitorTypeId("MON_SNMP");
        SnmpCheckInfo snmpInfo = new SnmpCheckInfo();
        snmpInfo.setConvertFlg(Integer.valueOf(1));
        snmpInfo.setSnmpVersion(SnmpVersionConstant.STRING_V1);
        snmpInfo.setMonitorTypeId("MON_SNMP");
        snmpInfo.setMonitorId(this.monitorInfo.getMonitorId());
        if (this.m_textOid.getText() != null && !"".equals(this.m_textOid.getText().trim())) {
            snmpInfo.setSnmpOid(this.m_textOid.getText());
        }
        if (this.m_comboConvertValue.getText() != null && !"".equals(this.m_comboConvertValue.getText().trim())) {
            snmpInfo.setConvertFlg(Integer.valueOf(ConvertValueConstant.stringToType((String)this.m_comboConvertValue.getText())));
        }
        this.monitorInfo.setSnmpCheckInfo(snmpInfo);
        this.monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_SNMP", (String)this.monitorInfo.getMonitorId()));
        this.validateResult = this.m_notifyInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            if (this.validateResult.getID() == null) {
                if (!this.displayQuestion(this.validateResult)) {
                    this.validateResult = null;
                    return null;
                }
            } else {
                return null;
            }
        }
        this.validateResult = this.m_numericValueInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            return null;
        }
        return this.monitorInfo;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        MonitorInfo info = this.inputData;
        if (info != null) {
            result = !this.updateFlg ? new AddSnmp().add(info) : new ModifySnmp().modify(info);
        }
        return result;
    }

    @Override
    protected void setInfoInitialValue(MonitorInfo monitor) {
        super.setInfoInitialValue(monitor);
        SnmpCheckInfo snmpCheckInfo = new SnmpCheckInfo();
        snmpCheckInfo.setConvertFlg(Integer.valueOf(1));
        snmpCheckInfo.setSnmpVersion(SnmpVersionConstant.STRING_V1);
        monitor.setSnmpCheckInfo(snmpCheckInfo);
    }
}

