/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dialog;

import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.repository.action.GetNodeProperty;
import com.clustercontrol.repository.util.NodePropertyUtil;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.PropertySheet;
import com.clustercontrol.ws.repository.FacilityDuplicate_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.NodeInfo;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NodeCreateDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(NodeCreateDialog.class);
    private final int sizeX = 500;
    private final int sizeY = 800;
    private String facilityId = "";
    private String scopeId = "";
    private Property propertyOld = null;
    private NodeInfo nodeInfoOld = null;
    private boolean isModifyDialog = false;
    private PropertySheet propertySheet = null;
    private boolean isClearDone = false;
    private Button clearButtonScope = null;
    private RoleIdListComposite m_ownerRoleId = null;
    private Button buttonAuto = null;
    private Label ipAddressText = null;
    private Text ipAddressBox = null;
    private Label communityText = null;
    private Text communityBox = null;
    private Label portText = null;
    private Text portBox = null;
    private Label versionText = null;
    private Combo versionBox = null;
    private TableTree table = null;
    private NodeInfo nodeInfo = null;

    public NodeCreateDialog(Shell parent, String facilityId, boolean isModifyDialog) {
        super(parent);
        this.facilityId = facilityId;
        this.isModifyDialog = isModifyDialog;
    }

    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        GetNodeProperty getNodeProperty;
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.repository.node.create.modify"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        Group groupAuto = new Group(parent, 131072);
        layout = new GridLayout(5, false);
        groupAuto.setLayout((Layout)layout);
        if (this.isModifyDialog) {
            groupAuto.setText("Find By SNMP " + Messages.getString((String)"repository.find.by.snmp.modify"));
        } else {
            groupAuto.setText("Find By SNMP");
        }
        this.ipAddressText = new Label((Composite)groupAuto, 0);
        this.ipAddressText.setText(String.valueOf(Messages.getString((String)"ip.address")) + " : ");
        this.ipAddressBox = new Text((Composite)groupAuto, 2052);
        GridData grid = new GridData(768);
        grid.minimumWidth = 120;
        this.ipAddressBox.setLayoutData((Object)grid);
        if (this.isModifyDialog) {
            getNodeProperty = new GetNodeProperty(this.facilityId, 1);
            this.propertyOld = getNodeProperty.getProperty();
            this.nodeInfoOld = getNodeProperty.getNodeInfo();
        } else {
            getNodeProperty = new GetNodeProperty(this.facilityId, 0);
            this.propertyOld = getNodeProperty.getProperty();
            this.nodeInfoOld = getNodeProperty.getNodeInfo();
        }
        Property propertyChild = null;
        propertyChild = PropertyUtil.getProperty(this.propertyOld, "ipAddressVersion").get(0);
        String ipAddressVersion = propertyChild.getValue().toString();
        String ipAddress = null;
        if ("6".equals(ipAddressVersion)) {
            propertyChild = PropertyUtil.getProperty(this.propertyOld, "ipAddressV6").get(0);
            ipAddress = propertyChild.getValue().toString();
        } else {
            propertyChild = PropertyUtil.getProperty(this.propertyOld, "ipAddressV4").get(0);
            ipAddress = propertyChild.getValue().toString();
        }
        if ("".equals(ipAddress)) {
            this.ipAddressBox.setText("192.168.0.1");
        } else {
            this.ipAddressBox.setText(ipAddress);
        }
        this.portText = new Label((Composite)groupAuto, 0);
        this.portText.setText(String.valueOf(Messages.getString((String)"port.number")) + " : ");
        this.portBox = new Text((Composite)groupAuto, 2052);
        grid = new GridData(768);
        grid.minimumWidth = 50;
        this.portBox.setLayoutData((Object)grid);
        propertyChild = PropertyUtil.getProperty(this.propertyOld, "snmpPort").get(0);
        String snmpPort = propertyChild.getValue().toString();
        if ("".equals(snmpPort)) {
            this.portBox.setText("161");
        } else {
            this.portBox.setText(snmpPort);
        }
        new Label((Composite)groupAuto, 0);
        this.communityText = new Label((Composite)groupAuto, 0);
        this.communityText.setText(String.valueOf(Messages.getString((String)"community.name")) + " : ");
        this.communityBox = new Text((Composite)groupAuto, 2052);
        this.communityBox.setLayoutData((Object)new GridData(768));
        propertyChild = PropertyUtil.getProperty(this.propertyOld, "snmpCommunity").get(0);
        String snmpCommunity = propertyChild.getValue().toString();
        if ("".equals(snmpCommunity)) {
            this.communityBox.setText("public");
        } else {
            this.communityBox.setText(snmpCommunity);
        }
        this.versionText = new Label((Composite)groupAuto, 0);
        this.versionText.setText(String.valueOf(Messages.getString((String)"snmp.version")) + " : ");
        this.versionBox = new Combo((Composite)groupAuto, 12);
        this.versionBox.setLayoutData((Object)new GridData(768));
        this.versionBox.add("1", 0);
        this.versionBox.add("2c", 1);
        propertyChild = PropertyUtil.getProperty(this.propertyOld, "snmpVersion").get(0);
        String snmpVersion = propertyChild.getValue().toString();
        if ("1".equals(snmpVersion)) {
            this.versionBox.select(0);
        } else {
            this.versionBox.select(1);
        }
        if (this.isModifyDialog) {
            this.ipAddressBox.setEditable(false);
            this.portBox.setEditable(false);
            this.communityBox.setEditable(false);
            this.versionBox.setTouchEnabled(false);
        }
        this.buttonAuto = new Button((Composite)groupAuto, 131080);
        this.buttonAuto.setText(" Find ");
        gridData = new GridData();
        gridData.horizontalIndent = 30;
        this.buttonAuto.setLayoutData((Object)gridData);
        this.buttonAuto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String ipAddressString = NodeCreateDialog.this.ipAddressBox.getText();
                    InetAddress address = InetAddress.getByName(ipAddressString);
                    if (address instanceof Inet4Address) {
                        if (!ipAddressString.matches(".{1,3}?\\..{1,3}?\\..{1,3}?\\..{1,3}?")) {
                            MessageDialog.openWarning((Shell)NodeCreateDialog.this.getShell(), (String)"Warning", (String)Messages.getString((String)"message.repository.37"));
                            return;
                        }
                    } else if (!(address instanceof Inet6Address)) {
                        MessageDialog.openWarning((Shell)NodeCreateDialog.this.getShell(), (String)"Warning", (String)Messages.getString((String)"message.repository.37"));
                        return;
                    }
                    String ipAddress = NodeCreateDialog.this.ipAddressBox.getText();
                    Integer port = Integer.parseInt(NodeCreateDialog.this.portBox.getText());
                    String community = NodeCreateDialog.this.communityBox.getText();
                    String version = SnmpVersionConstant.typeToString((Integer)new Integer(NodeCreateDialog.this.versionBox.getSelectionIndex()));
                    Property propertySNMP = null;
                    NodeInfo nodeInfo = null;
                    if (NodeCreateDialog.this.isModifyDialog) {
                        Property p;
                        Property propertyObj;
                        nodeInfo = NodeCreateDialog.GetNodeInfoBySNMP(ipAddress, port, community, version, 1);
                        propertySNMP = NodePropertyUtil.node2property(nodeInfo, 1, Locale.getDefault());
                        Iterator<Property> iterator = PropertyUtil.getProperty(NodeCreateDialog.this.propertyOld, "device").iterator();
                        while (iterator.hasNext()) {
                            p = propertyObj = iterator.next();
                            p.getParent().removeChildren(p);
                        }
                        iterator = PropertyUtil.getProperty(propertySNMP, "device").iterator();
                        while (iterator.hasNext()) {
                            p = propertyObj = iterator.next();
                            NodeCreateDialog.this.propertyOld.addChildren(p);
                        }
                        Property p2 = null;
                        p2 = PropertyUtil.getProperty(NodeCreateDialog.this.propertyOld, "serverVirtualization").get(0);
                        NodeCreateDialog.this.propertyOld.removeChildren(p2);
                        NodeCreateDialog.this.propertyOld.addChildren(p2);
                        p2 = PropertyUtil.getProperty(NodeCreateDialog.this.propertyOld, "networkVirtualization").get(0);
                        NodeCreateDialog.this.propertyOld.removeChildren(p2);
                        NodeCreateDialog.this.propertyOld.addChildren(p2);
                        p2 = PropertyUtil.getProperty(NodeCreateDialog.this.propertyOld, "nodeVariable").get(0);
                        NodeCreateDialog.this.propertyOld.removeChildren(p2);
                        NodeCreateDialog.this.propertyOld.addChildren(p2);
                        p2 = PropertyUtil.getProperty(NodeCreateDialog.this.propertyOld, "maintenance").get(0);
                        NodeCreateDialog.this.propertyOld.removeChildren(p2);
                        NodeCreateDialog.this.propertyOld.addChildren(p2);
                        p2 = PropertyUtil.getProperty(NodeCreateDialog.this.propertyOld, "createTimestamp").get(0);
                        NodeCreateDialog.this.propertyOld.removeChildren(p2);
                        NodeCreateDialog.this.propertyOld.addChildren(p2);
                        p2 = PropertyUtil.getProperty(NodeCreateDialog.this.propertyOld, "creatorName").get(0);
                        NodeCreateDialog.this.propertyOld.removeChildren(p2);
                        NodeCreateDialog.this.propertyOld.addChildren(p2);
                        p2 = PropertyUtil.getProperty(NodeCreateDialog.this.propertyOld, "ModifyTime").get(0);
                        NodeCreateDialog.this.propertyOld.removeChildren(p2);
                        NodeCreateDialog.this.propertyOld.addChildren(p2);
                        p2 = PropertyUtil.getProperty(NodeCreateDialog.this.propertyOld, "ModifierName").get(0);
                        NodeCreateDialog.this.propertyOld.removeChildren(p2);
                        NodeCreateDialog.this.propertyOld.addChildren(p2);
                        ArrayList<Property> oArray = PropertyUtil.getProperty(NodeCreateDialog.this.propertyOld, "note");
                        for (Property o : oArray) {
                            NodeCreateDialog.this.propertyOld.removeChildren(o);
                            NodeCreateDialog.this.propertyOld.addChildren(o);
                        }
                        NodeCreateDialog.this.propertySheet.setInput(NodeCreateDialog.this.propertyOld);
                    } else {
                        nodeInfo = NodeCreateDialog.GetNodeInfoBySNMP(ipAddress, port, community, version, 0);
                        propertySNMP = NodePropertyUtil.node2property(nodeInfo, 0, Locale.getDefault());
                        NodeCreateDialog.this.propertySheet.setInput(propertySNMP);
                    }
                    NodeCreateDialog.this.update();
                    NodeCreateDialog.this.expand();
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openWarning((Shell)NodeCreateDialog.this.getShell(), (String)"Warning", (String)Messages.getString((String)"message.repository.38"));
                }
                catch (UnknownHostException unknownHostException) {
                    MessageDialog.openWarning((Shell)NodeCreateDialog.this.getShell(), (String)"Warning", (String)Messages.getString((String)"message.repository.37"));
                }
            }
        });
        Label labelRoleId = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelRoleId.setLayoutData((Object)gridData);
        labelRoleId.setText(String.valueOf(Messages.getString((String)"owner.role.id")) + " : ");
        this.m_ownerRoleId = !this.isModifyDialog() ? new RoleIdListComposite(parent, 0, true, RoleIdListComposite.Mode.OWNER_ROLE) : new RoleIdListComposite(parent, 0, false, RoleIdListComposite.Mode.OWNER_ROLE);
        if (this.nodeInfoOld != null && this.nodeInfoOld.getOwnerRoleId() != null) {
            this.m_ownerRoleId.setText(this.nodeInfoOld.getOwnerRoleId());
        }
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_ownerRoleId.setLayoutData(gridData);
        Label label = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"attribute")) + " : ");
        this.table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 128;
        gridData.horizontalSpan = 1;
        this.table.setLayoutData((Object)gridData);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeCreateDialog.this.update();
            }
        });
        this.propertySheet = new PropertySheet(this.table);
        this.propertySheet.setSize(230, 300);
        this.propertySheet.setInput(this.propertyOld);
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        shell.pack();
        shell.setSize(new Point(shell.getSize().x, 800));
        this.update();
        this.expand();
    }

    private void expand() {
        m_log.debug((Object)"expand");
        this.propertySheet.expandToLevel(1);
        Object element = this.propertySheet.getElementAt(4);
        this.propertySheet.expandToLevel(element, 2);
        element = this.propertySheet.getElementAt(6);
        this.propertySheet.expandToLevel(element, 1);
        element = this.propertySheet.getElementAt(7);
        this.propertySheet.expandToLevel(element, 1);
    }

    public void update() {
        m_log.debug((Object)"update");
        this.setColor(this.table.getItem(0));
        this.setColor(this.table.getItem(1));
        if (this.table.getItem(4).getItemCount() > 0 && this.table.getItem(4).getItem(0).getItemCount() > 0) {
            this.setColor(this.table.getItem(4).getItem(0).getItem(0));
        }
        if (this.table.getItem(4).getItemCount() > 1 && this.table.getItem(4).getItem(1).getItemCount() > 0) {
            if ("4".equals(this.table.getItem(4).getItem(1).getItem(0).getText(1))) {
                this.table.getItem(4).getItem(1).getItem(0).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.setColor(this.table.getItem(4).getItem(1).getItem(1));
                this.table.getItem(4).getItem(1).getItem(2).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            } else if ("6".equals(this.table.getItem(4).getItem(1).getItem(0).getText(1))) {
                this.table.getItem(4).getItem(1).getItem(0).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(4).getItem(1).getItem(1).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.setColor(this.table.getItem(4).getItem(1).getItem(2));
            } else {
                this.table.getItem(4).getItem(1).getItem(0).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                this.table.getItem(4).getItem(1).getItem(1).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(4).getItem(1).getItem(2).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        }
        if (this.table.getItem(4).getItemCount() > 2 && this.table.getItem(4).getItem(2).getItemCount() > 0) {
            this.setColor(this.table.getItem(4).getItem(2).getItem(0));
        }
        if (this.table.getItem(8).getItemCount() > 6) {
            if ("controller".equals(this.table.getItem(8).getItem(0).getText(1)) || "host".equals(this.table.getItem(8).getItem(0).getText(1))) {
                this.table.getItem(8).getItem(1).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(8).getItem(2).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(8).getItem(3).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.setColor(this.table.getItem(8).getItem(4));
                this.setColor(this.table.getItem(8).getItem(5));
                this.setColor(this.table.getItem(8).getItem(6));
            } else if ("guest".equals(this.table.getItem(8).getItem(0).getText(1))) {
                this.setColor(this.table.getItem(8).getItem(1));
                this.setColor(this.table.getItem(8).getItem(2));
                this.setColor(this.table.getItem(8).getItem(3));
                this.table.getItem(8).getItem(4).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(8).getItem(5).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(8).getItem(6).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            } else {
                this.table.getItem(8).getItem(1).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(8).getItem(3).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(8).getItem(2).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(8).getItem(4).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(8).getItem(5).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                this.table.getItem(8).getItem(6).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        }
    }

    private void setColor(TableTreeItem item) {
        if ("".equals(item.getText(1))) {
            item.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            item.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.clearButtonScope = this.createButton(parent, 11, Messages.getString((String)"clear"), false);
        this.getButton(11).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Property property = null;
                if (NodeCreateDialog.this.isModifyDialog()) {
                    GetNodeProperty getNodeProperty = new GetNodeProperty(null, 1);
                    property = getNodeProperty.getProperty();
                    getNodeProperty.getNodeInfo();
                    ArrayList<Property> list = PropertyUtil.getProperty(property, "facilityId");
                    list.get(0).setValue(NodeCreateDialog.this.getFacilityId());
                } else {
                    GetNodeProperty getNodeProperty = new GetNodeProperty(null, 0);
                    property = getNodeProperty.getProperty();
                    getNodeProperty.getNodeInfo();
                }
                PropertyUtil.setPropertyValue(property, PropertyDefineConstant.EDITOR_BOOL, null);
                NodeCreateDialog.this.setInputData(property);
                NodeCreateDialog.this.ipAddressBox.setEditable(true);
                NodeCreateDialog.this.portBox.setEditable(true);
                NodeCreateDialog.this.communityBox.setEditable(true);
                NodeCreateDialog.this.versionBox.setTouchEnabled(true);
                NodeCreateDialog.this.isClearDone = true;
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    @Override
    protected ValidateResult validate() {
        ValidateResult result = null;
        return result;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        Property property = this.getInputData();
        if (property != null) {
            String errMessage = "";
            if (!this.isModifyDialog()) {
                Property copy = PropertyUtil.copy(property);
                PropertyUtil.deletePropertyDefine(copy);
                try {
                    this.nodeInfo = NodePropertyUtil.property2node(copy);
                    if (this.m_ownerRoleId.getText().length() > 0) {
                        this.nodeInfo.setOwnerRoleId(this.m_ownerRoleId.getText());
                    }
                    RepositoryEndpointWrapper.addNode(this.nodeInfo);
                    LocalSession.doCheck();
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.repository.4"));
                    result = true;
                }
                catch (FacilityDuplicate_Exception facilityDuplicate_Exception) {
                    ArrayList values = PropertyUtil.getPropertyValue(copy, "facilityId");
                    Object[] args = new String[]{(String)values.get(0)};
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.repository.26", (Object[])args));
                }
                catch (Exception e) {
                    if (e instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else {
                        errMessage = ", " + e.getMessage();
                        m_log.warn((Object)"action()", (Throwable)e);
                    }
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.repository.5")) + errMessage));
                }
            } else {
                Property copy = PropertyUtil.copy(property);
                PropertyUtil.deletePropertyDefine(copy);
                try {
                    this.nodeInfo = NodePropertyUtil.property2node(copy);
                    if (this.m_ownerRoleId.getText().length() > 0) {
                        this.nodeInfo.setOwnerRoleId(this.m_ownerRoleId.getText());
                    }
                    RepositoryEndpointWrapper.modifyNode(this.nodeInfo);
                    LocalSession.doCheck();
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.repository.10"));
                    result = true;
                }
                catch (Exception e) {
                    if (e instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else {
                        errMessage = ", " + e.getMessage();
                    }
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.repository.11")) + errMessage));
                }
            }
        }
        return result;
    }

    public boolean isModifyDialog() {
        return this.isModifyDialog;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public boolean isClearDone() {
        return this.isClearDone;
    }

    public Property getInputData() {
        return (Property)this.propertySheet.getInput();
    }

    public void setInputData(Property property) {
        this.propertySheet.setInput(property);
        this.update();
    }

    public String getFacilityId() {
        return this.facilityId;
    }

    @Override
    protected String getOkButtonText() {
        if (this.isModifyDialog()) {
            return Messages.getString((String)"modify");
        }
        return Messages.getString((String)"register");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    private static NodeInfo GetNodeInfoBySNMP(String ipAddress, int port, String community, String version, int mode) {
        try {
            NodeInfo nodeInfo = RepositoryEndpointWrapper.getNodePropertyBySNMP(ipAddress, port, community, version);
            m_log.info((Object)("snmp2 " + nodeInfo.getNodeFilesystemInfo().size()));
            NodePropertyUtil.setDefaultNode(nodeInfo);
            return nodeInfo;
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("GetNodePropertyBySNMP(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return null;
    }
}

