/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.composite;

import com.clustercontrol.repository.action.GetScopeListTableDefine;
import com.clustercontrol.repository.composite.action.ScopeDoubleClickListener;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ScopeListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(ScopeListComposite.class);
    private FacilityTreeItem m_facilityTreeItem = null;
    private FacilityTreeItem m_selectFacilityTreeItem = null;
    private CommonTableViewer tableViewer = null;
    private Label totalLabel = null;

    public ScopeListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.totalLabel = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.totalLabel.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetScopeListTableDefine.get(), 4, 0, 1);
        this.tableViewer.addDoubleClickListener(new ScopeDoubleClickListener(this));
    }

    public void update(FacilityTreeItem item) {
        ArrayList listInput = new ArrayList();
        if (item instanceof FacilityTreeItem) {
            this.m_facilityTreeItem = item;
            int type = item.getData().getFacilityType();
            if (type != 1 && item.getChildren() != null) {
                for (FacilityTreeItem child : item.getChildren()) {
                    FacilityInfo scope = child.getData();
                    ArrayList<Object> a = new ArrayList<Object>();
                    a.add(scope.getFacilityId());
                    a.add(scope.getFacilityName());
                    a.add(scope.getDescription());
                    a.add(scope.getOwnerRoleId());
                    a.add(scope.getDisplaySortOrder());
                    listInput.add(a);
                }
            }
        }
        this.tableViewer.setInput(listInput);
        Object[] args = new Object[]{String.valueOf(listInput.size())};
        this.totalLabel.setText(Messages.getString((String)"records", (Object[])args));
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void setSelectFacilityTreeItem(FacilityTreeItem facilityTreeItem) {
        this.m_selectFacilityTreeItem = facilityTreeItem;
    }

    public FacilityTreeItem getSelectItem() {
        return this.m_selectFacilityTreeItem;
    }

    public FacilityTreeItem getFacilityTreeItem() {
        return this.m_facilityTreeItem;
    }
}

