/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ping.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.monitor.run.dialog.CommonMonitorNumericDialog;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.ping.bean.PingRunCountConstant;
import com.clustercontrol.ping.bean.PingRunIntervalConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorDuplicate_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.PingCheckInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PingCreateDialog
extends CommonMonitorNumericDialog {
    private static Log m_log = LogFactory.getLog(PingCreateDialog.class);
    private Text m_textTimeout = null;
    private Combo m_comboRunCount = null;
    private Combo m_comboRunInterval = null;

    public PingCreateDialog(Shell parent) {
        super(parent);
    }

    public PingCreateDialog(Shell parent, String monitorId, boolean updateFlg) {
        super(parent);
        this.monitorId = monitorId;
        this.updateFlg = updateFlg;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.item1 = Messages.getString((String)"response.time.milli.sec");
        this.item2 = Messages.getString((String)"ping.reach");
        this.criterion1 = Messages.getString((String)"less");
        this.criterion2 = Messages.getString((String)"less");
        super.customizeDialog(parent);
        this.m_numericValueInfo.setInfoWarnText("1000", "1", "3000", "51");
        this.shell.setText(Messages.getString((String)"dialog.ping.create.modify"));
        Label label = null;
        GridData gridData = null;
        Group groupCheckRule = new Group((Composite)this.groupRule, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        groupCheckRule.setText(Messages.getString((String)"check.rule"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"run.count")) + " : ");
        this.m_comboRunCount = new Combo((Composite)groupCheckRule, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunCount.setLayoutData((Object)gridData);
        this.m_comboRunCount.add(PingRunCountConstant.STRING_COUNT_01);
        this.m_comboRunCount.add(PingRunCountConstant.STRING_COUNT_02);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"run.interval")) + " : ");
        this.m_comboRunInterval = new Combo((Composite)groupCheckRule, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunInterval.setLayoutData((Object)gridData);
        this.m_comboRunInterval.add(PingRunIntervalConstant.STRING_SEC_01);
        this.m_comboRunInterval.add(PingRunIntervalConstant.STRING_SEC_02);
        this.m_comboRunInterval.add(PingRunIntervalConstant.STRING_SEC_05);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"time.out")) + " : ");
        this.m_textTimeout = new Text((Composite)groupCheckRule, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textTimeout.setLayoutData((Object)gridData);
        this.m_textTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                PingCreateDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"milli.sec"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.itemName.setText(Messages.getString((String)"response.time"));
        this.measure.setText(Messages.getString((String)"time.msec"));
        this.m_numericValueInfo.setRangeFlg(false);
        this.adjustDialog();
        MonitorInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorInfo();
            this.setInfoInitialValue(info);
        } else {
            try {
                info = MonitorSettingEndpointWrapper.getMonitor(this.monitorId, "MON_PNG");
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("customizeDialog(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        this.setInputData(info);
    }

    @Override
    public void update() {
        super.update();
        if (this.m_textTimeout.getEnabled() && "".equals(this.m_textTimeout.getText())) {
            this.m_textTimeout.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textTimeout.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    protected void setInputData(MonitorInfo monitor) {
        super.setInputData(monitor);
        this.inputData = monitor;
        PingCheckInfo pingInfo = monitor.getPingCheckInfo();
        if (pingInfo.getRunCount() != null) {
            this.m_comboRunCount.setText(PingRunCountConstant.typeToString((int)pingInfo.getRunCount()));
        }
        if (pingInfo.getRunInterval() != null) {
            this.m_comboRunInterval.setText(PingRunIntervalConstant.typeToString((int)pingInfo.getRunInterval()));
        }
        if (pingInfo.getTimeout() != null) {
            this.m_textTimeout.setText(pingInfo.getTimeout().toString());
        }
        this.m_numericValueInfo.setInputData(monitor);
    }

    @Override
    protected MonitorInfo createInputData() {
        super.createInputData();
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setMonitorTypeId("MON_PNG");
        PingCheckInfo pingInfo = new PingCheckInfo();
        pingInfo.setMonitorTypeId("MON_PNG");
        pingInfo.setMonitorId(this.monitorInfo.getMonitorId());
        if (this.m_comboRunCount.getText() != null && !"".equals(this.m_comboRunCount.getText().trim())) {
            pingInfo.setRunCount(Integer.valueOf(PingRunCountConstant.stringToType((String)this.m_comboRunCount.getText())));
        }
        if (this.m_comboRunInterval.getText() != null && !"".equals(this.m_comboRunInterval.getText().trim())) {
            pingInfo.setRunInterval(Integer.valueOf(PingRunIntervalConstant.stringToType((String)this.m_comboRunInterval.getText())));
        }
        if (!"".equals(this.m_textTimeout.getText().trim())) {
            try {
                Integer timeout = new Integer(this.m_textTimeout.getText().trim());
                pingInfo.setTimeout(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.ping.3"));
                return null;
            }
        }
        this.monitorInfo.setPingCheckInfo(pingInfo);
        this.validateResult = this.m_numericValueInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_PNG", (String)pingInfo.getMonitorId()));
        this.validateResult = this.m_notifyInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            if (this.validateResult.getID() == null) {
                if (!this.displayQuestion(this.validateResult)) {
                    this.validateResult = null;
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.monitorInfo;
    }

    @Override
    protected boolean action() {
        boolean result;
        block14: {
            result = false;
            MonitorInfo info = this.inputData;
            if (info != null) {
                Object[] args = new String[]{info.getMonitorId()};
                if (!this.updateFlg) {
                    try {
                        result = MonitorSettingEndpointWrapper.addMonitor(info);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.33", (Object[])args));
                            break block14;
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.34", (Object[])args));
                    }
                    catch (MonitorDuplicate_Exception monitorDuplicate_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.53", (Object[])args));
                    }
                    catch (Exception e) {
                        String errMessage = "";
                        if (e instanceof InvalidRole_Exception) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        } else {
                            errMessage = ", " + e.getMessage();
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.34", (Object[])args)) + errMessage));
                    }
                } else {
                    String errMessage = "";
                    try {
                        result = MonitorSettingEndpointWrapper.modifyMonitor(info);
                    }
                    catch (InvalidRole_Exception invalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    catch (Exception e) {
                        errMessage = ", " + e.getMessage();
                    }
                    if (result) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.35", (Object[])args));
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.36", (Object[])args)) + errMessage));
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected void setInfoInitialValue(MonitorInfo monitor) {
        super.setInfoInitialValue(monitor);
        PingCheckInfo pingCheckInfo = new PingCheckInfo();
        pingCheckInfo.setRunCount(Integer.valueOf(1));
        pingCheckInfo.setRunInterval(Integer.valueOf(1000));
        pingCheckInfo.setTimeout(Integer.valueOf(5000));
        monitor.setPingCheckInfo(pingCheckInfo);
    }
}

