/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.view;

import com.clustercontrol.bean.Property;
import com.clustercontrol.performance.composite.PerformanceListComposite;
import com.clustercontrol.performance.composite.action.PerformanceListSelectionChangedListener;
import com.clustercontrol.view.CommonViewPart;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class PerformanceListView
extends CommonViewPart {
    public static final String ID = "com.clustercontrol.performance.view.PerformanceListView";
    private PerformanceListComposite composite = null;
    private Property condition = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite = new PerformanceListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        this.createContextMenu();
        this.composite.getTableViewer().addSelectionChangedListener(new PerformanceListSelectionChangedListener());
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PerformanceListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.composite.getTable());
        this.composite.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem addGraph = (ActionContributionItem)toolbar.find("com.clustercontrol.performance.view.action.AddGraphAction");
        ActionContributionItem exportCollectedData = (ActionContributionItem)toolbar.find("com.clustercontrol.performance.view.action.ExportCollectedDataAction");
        manager.add(addGraph.getAction());
        manager.add(exportCollectedData.getAction());
    }

    public Composite getListComposite() {
        return this.composite;
    }

    public void update(Property condition) {
        this.condition = condition;
        this.update();
    }

    public void setCondition(Property condition) {
        this.condition = condition;
    }

    public void update() {
        this.composite.update(this.condition);
    }

    public String getSelectedMonitorId() {
        return this.composite.getSelectedMonitorId();
    }

    public String getSelectedMonitorTypeId() {
        return this.composite.getSelectedMonitorTypeId();
    }

    public void setEnabledAction(int eventNum) {
        if (eventNum == 0) {
            super.setEnabledAction("com.clustercontrol.performance.view.action.AddGraphAction", false);
            super.setEnabledAction("com.clustercontrol.performance.view.action.ExportCollectedDataAction", false);
        } else if (eventNum > 0) {
            super.setEnabledAction("com.clustercontrol.performance.view.action.AddGraphAction", true);
            super.setEnabledAction("com.clustercontrol.performance.view.action.ExportCollectedDataAction", true);
        }
        super.setEnabledAction("com.clustercontrol.performance.view.action.PerformanceListFilterAction", true);
        super.setEnabledAction("com.clustercontrol.performance.view.action.RefreshPerformanceListAction", true);
    }

    public void setEnabledAction(int status, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.performance.view.action.AddGraphAction", selection);
        super.setEnabledAction("com.clustercontrol.performance.view.action.ExportCollectedDataAction", selection);
        super.setEnabledAction("com.clustercontrol.performance.view.action.PerformanceListFilterAction", selection);
        super.setEnabledAction("com.clustercontrol.performance.view.action.RefreshPerformanceListAction", selection);
        if (status == 1) {
            super.setEnabledAction("com.clustercontrol.performance.view.action.AddGraphAction", true);
            super.setEnabledAction("com.clustercontrol.performance.view.action.ExportCollectedDataAction", true);
            super.setEnabledAction("com.clustercontrol.performance.view.action.PerformanceListFilterAction", true);
            super.setEnabledAction("com.clustercontrol.performance.view.action.RefreshPerformanceListAction", true);
        } else if (status == 0) {
            super.setEnabledAction("com.clustercontrol.performance.view.action.AddGraphAction", true);
            super.setEnabledAction("com.clustercontrol.performance.view.action.ExportCollectedDataAction", true);
            super.setEnabledAction("com.clustercontrol.performance.view.action.PerformanceListFilterAction", true);
            super.setEnabledAction("com.clustercontrol.performance.view.action.RefreshPerformanceListAction", true);
        }
    }
}

