/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.mail.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.notify.mail.action.GetMailTemplate;
import com.clustercontrol.notify.mail.action.GetMailTemplateListTableDefine;
import com.clustercontrol.notify.mail.composite.actioin.MailTemplateDoubleClickListener;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.mailtemplate.MailTemplateInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class MailTemplateListComposite
extends Composite {
    private CommonTableViewer tableViewer = null;
    private Label totalLabel = null;
    private Property condition = null;

    public MailTemplateListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetMailTemplateListTableDefine.get(), 0, 1);
        this.tableViewer.addDoubleClickListener(new MailTemplateDoubleClickListener(this));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void update() {
        List<MailTemplateInfo> list = new GetMailTemplate().getMailTemplateList();
        if (list == null) {
            list = new ArrayList<MailTemplateInfo>();
        }
        ArrayList listInput = new ArrayList();
        for (MailTemplateInfo mailTemplateInfo : list) {
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(mailTemplateInfo.getMailTemplateId());
            a.add(mailTemplateInfo.getDescription());
            a.add(mailTemplateInfo.getOwnerRoleId());
            a.add(mailTemplateInfo.getRegUser());
            if (mailTemplateInfo.getRegDate() == null) {
                a.add(null);
            } else {
                a.add(new Date(mailTemplateInfo.getRegDate()));
            }
            a.add(mailTemplateInfo.getUpdateUser());
            if (mailTemplateInfo.getUpdateDate() == null) {
                a.add(null);
            } else {
                a.add(new Date(mailTemplateInfo.getUpdateDate()));
            }
            listInput.add(a);
        }
        this.tableViewer.setInput(listInput);
        Object[] args = new String[]{String.valueOf(list.size())};
        String message = null;
        message = this.condition == null ? Messages.getString((String)"records", (Object[])args) : Messages.getString((String)"filtered.records", (Object[])args);
        this.totalLabel.setText(message);
    }
}

