/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.action;

import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.notify.util.NotifyEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;

public class DeleteNotify {
    private static Log m_log = LogFactory.getLog(DeleteNotify.class);

    public boolean delete(String notifyId) {
        boolean result = false;
        Object[] args = new String[]{notifyId};
        try {
            result = NotifyEndpointWrapper.deleteNotify(notifyId);
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.notify.5", (Object[])args));
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("delete(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return result;
    }

    public int useCheck(String notifyId) {
        int result = 0;
        List<String> notifyGroupIdList = null;
        try {
            notifyGroupIdList = NotifyEndpointWrapper.checkNotifyId(notifyId);
            if (notifyGroupIdList.size() != 0) {
                String message = null;
                String notifyGroupId = null;
                String[] strings = null;
                String moduleName = "";
                ArrayList<String> checkList = new ArrayList<String>();
                String id = this.toString();
                Iterator<String> itr = notifyGroupIdList.iterator();
                Object[] args = new String[]{notifyId};
                MultiStatus mStatus = new MultiStatus(this.toString(), 0, Messages.getString((String)"message.notify.26", (Object[])args), null);
                Status status = null;
                while (itr.hasNext()) {
                    notifyGroupId = itr.next();
                    strings = notifyGroupId.split("-");
                    if (!HinemosModuleConstant.isExist((String)strings[0]) || strings[0].equals("JOB_SES")) continue;
                    if (!moduleName.equals(strings[0])) {
                        if (!moduleName.equals("")) {
                            status = new Status(1, id, 0, "", null);
                            mStatus.add((IStatus)status);
                        }
                        moduleName = strings[0];
                        message = "[" + HinemosModuleConstant.nameToString((String)moduleName) + "]";
                        checkList.clear();
                        status = new Status(1, id, 0, message, null);
                        mStatus.add((IStatus)status);
                    }
                    String monitorId = strings[1];
                    int i = 2;
                    while (i < strings.length - 1) {
                        monitorId = String.valueOf(monitorId) + "-" + strings[i];
                        ++i;
                    }
                    if (checkList.contains(monitorId)) continue;
                    checkList.add(monitorId);
                    message = "  " + monitorId;
                    status = new Status(1, id, 0, message, null);
                    mStatus.add((IStatus)status);
                }
                result = ErrorDialog.openError(null, (String)Messages.getString((String)"info"), null, (IStatus)mStatus);
            }
        }
        catch (Exception e) {
            m_log.warn((Object)("useCheck(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return result;
    }
}

