/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.view.action;

import com.clustercontrol.monitor.composite.MonitorListComposite;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.monitor.view.MonitorListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class MonitorEnableAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(MonitorEnableAction.class);
    public static final String ID = "com.clustercontrol.monitor.view.action.MonitorEnableAction";
    private IViewPart viewPart;

    public void run(IAction action) {
        MonitorListView view = (MonitorListView)this.viewPart.getAdapter(MonitorListView.class);
        MonitorListComposite composite = (MonitorListComposite)view.getListComposite();
        StructuredSelection selection = (StructuredSelection)composite.getTableViewer().getSelection();
        Object[] objs = selection.toArray();
        if (objs.length == 0) {
            MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.monitor.1"));
            return;
        }
        String monitorId = null;
        String monitorTypeId = null;
        HashMap<String, String> targetIdList = new HashMap<String, String>();
        StringBuffer targetList = new StringBuffer();
        StringBuffer successList = new StringBuffer();
        StringBuffer failureList = new StringBuffer();
        int i = 0;
        while (i < objs.length) {
            monitorId = (String)((ArrayList)objs[i]).get(0);
            monitorTypeId = (String)((ArrayList)objs[i]).get(1);
            targetIdList.put(monitorId, monitorTypeId);
            if (targetList.length() > 0) {
                targetList.append(", ");
            }
            targetList.append(monitorId);
            ++i;
        }
        Object[] args = new String[]{targetList.toString()};
        if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.monitor.68", (Object[])args))) {
            return;
        }
        boolean hasRole = true;
        Iterator iterator = targetIdList.keySet().iterator();
        while (iterator.hasNext()) {
            String targetId;
            monitorId = targetId = (String)iterator.next();
            monitorTypeId = (String)targetIdList.get(targetId);
            try {
                MonitorSettingEndpointWrapper.setStatusMonitor(monitorId, monitorTypeId, true);
                if (successList.length() > 0) {
                    successList.append(", ");
                }
                successList.append(targetId);
            }
            catch (InvalidRole_Exception e) {
                if (failureList.length() > 0) {
                    failureList.append(", ");
                }
                failureList.append(String.valueOf(targetId) + "(" + e.getMessage() + ")");
                m_log.warn((Object)("run() setStatusMonitor monitorId=" + monitorId + ", " + e.getMessage()), (Throwable)e);
                hasRole = false;
            }
            catch (Exception e) {
                if (failureList.length() > 0) {
                    failureList.append(", ");
                }
                failureList.append(String.valueOf(targetId) + "(" + e.getMessage() + ")");
                m_log.warn((Object)("run() setStatusMonitor monitorId=" + monitorId + ", " + e.getMessage()), (Throwable)e);
            }
        }
        if (!hasRole) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        if (successList.length() != 0) {
            args = new String[]{successList.toString()};
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.69", (Object[])args));
        }
        if (failureList.length() != 0) {
            args = new String[]{failureList.toString()};
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.70", (Object[])args));
        }
        composite.update();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        this.viewPart = view;
    }
}

