/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.view.action;

import com.clustercontrol.custom.action.MonitorCustomModifier;
import com.clustercontrol.hinemosagent.action.DeleteAgent;
import com.clustercontrol.http.action.DeleteHttp;
import com.clustercontrol.logfile.action.DeleteLogfile;
import com.clustercontrol.monitor.action.DeleteInterface;
import com.clustercontrol.monitor.composite.MonitorListComposite;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.view.MonitorListView;
import com.clustercontrol.performance.monitor.action.DeletePerformance;
import com.clustercontrol.ping.action.DeletePing;
import com.clustercontrol.plugin.monitor.IMonitorPlugin;
import com.clustercontrol.plugin.monitor.LoadMonitorPlugin;
import com.clustercontrol.port.action.DeletePort;
import com.clustercontrol.process.action.DeleteProcess;
import com.clustercontrol.snmp.action.DeleteSnmp;
import com.clustercontrol.snmptrap.action.DeleteSnmpTrap;
import com.clustercontrol.sql.action.DeleteSql;
import com.clustercontrol.systemlog.action.DeleteSystemlog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.winevent.action.DeleteWinEvent;
import com.clustercontrol.winservice.action.DeleteWinService;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class MonitorDeleteAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(MonitorDeleteAction.class);
    public static final String ID = "com.clustercontrol.monitor.view.action.MonitorDeleteAction";
    private IViewPart viewPart;

    public void run(IAction action) {
        MonitorListView view = (MonitorListView)this.viewPart.getAdapter(MonitorListView.class);
        MonitorListComposite composite = (MonitorListComposite)view.getListComposite();
        StructuredSelection selection = (StructuredSelection)composite.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String pluginId = null;
        String monitorId = null;
        if (list != null && list.size() > 0) {
            pluginId = (String)list.get(1);
            monitorId = (String)list.get(0);
            MonitorTypeConstant.stringToType((String)((String)list.get(2)));
        }
        if (pluginId != null && monitorId != null) {
            Object[] args = new String[]{monitorId};
            if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.monitor.39", (Object[])args))) {
                return;
            }
            DeleteInterface deleteInterface = null;
            if (pluginId.equals("MON_AGT")) {
                deleteInterface = new DeleteAgent();
            } else if (pluginId.equals("MON_HTP")) {
                deleteInterface = new DeleteHttp();
            } else if (pluginId.equals("MON_PRF")) {
                deleteInterface = new DeletePerformance();
            } else if (pluginId.equals("MON_PNG")) {
                deleteInterface = new DeletePing();
            } else if (pluginId.equals("MON_PRT")) {
                deleteInterface = new DeletePort();
            } else if (pluginId.equals("MON_PRC")) {
                deleteInterface = new DeleteProcess();
            } else if (pluginId.equals("MON_SNMP")) {
                deleteInterface = new DeleteSnmp();
            } else if (pluginId.equals("MON_SQL")) {
                deleteInterface = new DeleteSql();
            } else if (pluginId.equals("MON_SYSLOG")) {
                deleteInterface = new DeleteSystemlog();
            } else if (pluginId.equals("MON_LOGFILE")) {
                deleteInterface = new DeleteLogfile();
            } else if (pluginId.equals("MON_CUSTOM")) {
                deleteInterface = new MonitorCustomModifier();
            } else if (pluginId.equals("MON_SNMP_TRP")) {
                deleteInterface = new DeleteSnmpTrap();
            } else if (pluginId.equals("MON_WINSERVICE")) {
                deleteInterface = new DeleteWinService();
            } else if (pluginId.equals("MON_WINEVENT")) {
                deleteInterface = new DeleteWinEvent();
            } else {
                for (IMonitorPlugin extensionMonitor : LoadMonitorPlugin.getExtensionMonitorList()) {
                    if (!pluginId.equals(extensionMonitor.getMonitorPluginId())) continue;
                    deleteInterface = extensionMonitor.getDeleteMonitorClassObject();
                }
                if (deleteInterface == null) {
                    m_log.warn((Object)("unknown pluginId " + pluginId));
                    return;
                }
            }
            String errMessage = "";
            boolean result = false;
            try {
                result = deleteInterface.delete(monitorId);
            }
            catch (Exception e) {
                if (e instanceof InvalidRole_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
                errMessage = ", " + e.getMessage();
            }
            if (result) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.37", (Object[])args));
                view.update();
            } else {
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.38", (Object[])args)) + errMessage));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }
}

