/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.view;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.composite.EventListComposite;
import com.clustercontrol.monitor.composite.action.EventListSelectionChangedListener;
import com.clustercontrol.util.Messages;
import com.clustercontrol.view.ScopeListBaseView;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class EventView
extends ScopeListBaseView {
    public static final String ID = "com.clustercontrol.monitor.view.EventView";
    private EventListComposite tableComposite = null;
    private Property condition = null;

    @Override
    protected Composite createListContents(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.tableComposite = new EventListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tableComposite.setLayoutData(gridData);
        this.createContextMenu();
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        this.setInterval(store.getInt("eventUpdateCycle"));
        if (store.getBoolean("eventUpdateFlg")) {
            this.startAutoReload();
        }
        this.tableComposite.getTableViewer().addSelectionChangedListener(new EventListSelectionChangedListener());
        return this.tableComposite;
    }

    @Override
    protected void doSelectTreeItem(FacilityTreeItem item) {
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EventView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.tableComposite.getTable());
        this.tableComposite.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem confirmAction = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.EventConfirmAction");
        ActionContributionItem unconfirmAction = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.EventUnconfirmAction");
        ActionContributionItem detailAction = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.EventDetailAction");
        manager.add(detailAction.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(confirmAction.getAction());
        manager.add(unconfirmAction.getAction());
    }

    @Override
    public void update() {
        FacilityTreeItem item = this.getScopeTreeComposite().getSelectItem();
        String facilityId = null;
        if (item != null) {
            facilityId = item.getData().getFacilityId();
        }
        if (this.condition == null) {
            if (facilityId == null) {
                this.getPathLabel().setText(String.valueOf(Messages.getString((String)"scope")) + " : ");
                this.getPathLabel().pack();
            }
            this.tableComposite.update(facilityId);
        } else {
            this.getPathLabel().setText(Messages.getString((String)"filtered.list"));
            this.getPathLabel().pack();
            this.tableComposite.update(facilityId, this.condition);
        }
    }

    public void setCondition(Property condition) {
        this.condition = condition;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.setCondition(null);
    }

    public void setEnabledAction(int eventNum) {
        if (eventNum == 0) {
            super.setEnabledAction("com.clustercontrol.monitor.view.action.EventConfirmAction", false);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.EventUnconfirmAction", false);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.EventDetailAction", false);
        }
    }

    public void setEnabledAction(int confirmType, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.monitor.view.action.EventConfirmAction", selection);
        super.setEnabledAction("com.clustercontrol.monitor.view.action.EventUnconfirmAction", selection);
        super.setEnabledAction("com.clustercontrol.monitor.view.action.EventDetailAction", selection);
        if (confirmType == 1) {
            super.setEnabledAction("com.clustercontrol.monitor.view.action.EventConfirmAction", false);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.EventUnconfirmAction", true);
        } else if (confirmType == 0) {
            super.setEnabledAction("com.clustercontrol.monitor.view.action.EventConfirmAction", true);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.EventUnconfirmAction", false);
        } else {
            super.setEnabledAction("com.clustercontrol.monitor.view.action.EventConfirmAction", true);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.EventUnconfirmAction", true);
        }
    }
}

