/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.dialog;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.util.StringValueInfoManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.MonitorStringValueInfo;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StringValueInfoCreateDialog
extends CommonDialog {
    public static final int WIDTH_TITLE = 4;
    public static final int WIDTH_VALUE = 2;
    private MonitorStringValueInfo m_inputData = null;
    private ValidateResult m_validateResult = null;
    private String m_identifier = null;
    private int m_order = Integer.MAX_VALUE;
    private Text m_textDescription = null;
    private Text m_textPattern = null;
    private Button m_radioNotProcess = null;
    private Button m_radioProcess = null;
    private Button m_checkCaseSensitive = null;
    private Combo m_comboPriority = null;
    private Text m_textMessage = null;
    private Button m_buttonValid = null;
    private boolean logLineFlag = false;

    public StringValueInfoCreateDialog(Shell parent, boolean logLineFlag) {
        super(parent);
        this.logLineFlag = logLineFlag;
    }

    public StringValueInfoCreateDialog(Shell parent, String identifier) {
        super(parent);
        this.m_identifier = identifier;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.monitor.run.create.modify.string"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.m_textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDescription.setLayoutData((Object)gridData);
        this.m_textDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                StringValueInfoCreateDialog.this.update();
            }
        });
        Group monitorRuleGroup = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        monitorRuleGroup.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        monitorRuleGroup.setLayoutData((Object)gridData);
        monitorRuleGroup.setText(Messages.getString((String)"monitor.rule"));
        label = new Label((Composite)monitorRuleGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"pattern.matching.expression")) + " : ");
        this.m_textPattern = new Text((Composite)monitorRuleGroup, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textPattern.setLayoutData((Object)gridData);
        this.m_textPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                StringValueInfoCreateDialog.this.update();
            }
        });
        this.m_radioProcess = new Button((Composite)monitorRuleGroup, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioProcess.setLayoutData((Object)gridData);
        this.m_radioProcess.setText(Messages.getString((String)"process.if.matched"));
        this.m_radioProcess.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringValueInfoCreateDialog.this.setEnabled(StringValueInfoCreateDialog.this.m_radioProcess.getSelection());
                StringValueInfoCreateDialog.this.update();
            }
        });
        label = new Label((Composite)monitorRuleGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_checkCaseSensitive = new Button((Composite)monitorRuleGroup, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_checkCaseSensitive.setLayoutData((Object)gridData);
        this.m_checkCaseSensitive.setText(Messages.getString((String)"case.sensitive"));
        this.m_radioNotProcess = new Button((Composite)monitorRuleGroup, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioNotProcess.setLayoutData((Object)gridData);
        this.m_radioNotProcess.setText(Messages.getString((String)"don't.process.if.matched"));
        this.m_radioNotProcess.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringValueInfoCreateDialog.this.setEnabled(!StringValueInfoCreateDialog.this.m_radioNotProcess.getSelection());
                StringValueInfoCreateDialog.this.update();
            }
        });
        label = new Label((Composite)monitorRuleGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Group executeGroup = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        executeGroup.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        executeGroup.setLayoutData((Object)gridData);
        executeGroup.setText(Messages.getString((String)"process"));
        label = new Label((Composite)executeGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"priority")) + " : ");
        this.m_comboPriority = new Combo((Composite)executeGroup, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboPriority.setLayoutData((Object)gridData);
        this.m_comboPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboPriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboPriority.add(PriorityConstant.STRING_INFO);
        this.m_comboPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboPriority.setText(PriorityConstant.STRING_CRITICAL);
        label = new Label((Composite)executeGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)executeGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"message")) + " : ");
        this.m_textMessage = new Text((Composite)executeGroup, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textMessage.setLayoutData((Object)gridData);
        this.m_textMessage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                StringValueInfoCreateDialog.this.update();
            }
        });
        if (this.logLineFlag) {
            this.m_textMessage.setText("#[LOG_LINE]");
        }
        this.m_buttonValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonValid.setLayoutData((Object)gridData);
        this.m_buttonValid.setText(Messages.getString((String)"setting.valid.confirmed"));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        Collection<NotifyRelationInfo> modifyNotify = null;
        MonitorStringValueInfo info = StringValueInfoManager.getInstance().get(this.m_identifier);
        if (info == null) {
            info = new MonitorStringValueInfo();
            info.setOrderNo(Integer.MAX_VALUE);
            info.setProcessType(1);
            info.setValidFlg(true);
        }
        this.setInputData(info, modifyNotify);
    }

    public void update() {
        if ("".equals(this.m_textPattern.getText())) {
            this.m_textPattern.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textPattern.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_radioProcess.getSelection() && "".equals(this.m_textMessage.getText())) {
            this.m_textMessage.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textMessage.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public MonitorStringValueInfo getInputData() {
        return this.m_inputData;
    }

    protected void setInputData(MonitorStringValueInfo info, Collection<NotifyRelationInfo> modifyNotify) {
        this.m_inputData = info;
        this.m_identifier = info.getIdentifier();
        this.m_order = info.getOrderNo();
        if (info.getDescription() != null) {
            this.m_textDescription.setText(info.getDescription());
        }
        if (info.getPattern() != null) {
            this.m_textPattern.setText(info.getPattern());
        }
        if (info.getProcessType() == 1) {
            this.m_radioProcess.setSelection(true);
        } else {
            this.m_radioNotProcess.setSelection(true);
        }
        if (info.isCaseSensitivityFlg()) {
            this.m_checkCaseSensitive.setSelection(true);
        }
        this.m_comboPriority.setText(PriorityConstant.typeToString((int)info.getPriority()));
        if (info.getMessage() != null) {
            this.m_textMessage.setText(info.getMessage());
        }
        if (info.isValidFlg()) {
            this.m_buttonValid.setSelection(true);
        }
        this.setEnabled(this.m_radioProcess.getSelection());
        this.update();
    }

    private MonitorStringValueInfo createInputData() {
        MonitorStringValueInfo info = new MonitorStringValueInfo();
        info.setIdentifier(this.m_identifier);
        info.setOrderNo(this.m_order);
        if (this.m_textDescription.getText() != null && !"".equals(this.m_textDescription.getText().trim())) {
            info.setDescription(this.m_textDescription.getText());
        }
        if (this.m_textPattern.getText() != null && !"".equals(this.m_textPattern.getText().trim())) {
            try {
                Pattern.compile(this.m_textPattern.getText());
                info.setPattern(this.m_textPattern.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.27"));
                return null;
            }
        } else {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.27"));
            return null;
        }
        if (this.m_radioProcess.getSelection()) {
            info.setProcessType(1);
        } else {
            info.setProcessType(0);
        }
        if (this.m_checkCaseSensitive.getSelection()) {
            info.setCaseSensitivityFlg(true);
        } else {
            info.setCaseSensitivityFlg(false);
        }
        String priorityText = this.m_comboPriority.getText();
        info.setPriority(PriorityConstant.stringToType((String)priorityText));
        if (this.m_textMessage.getText() != null && !"".equals(this.m_textMessage.getText().trim())) {
            info.setMessage(this.m_textMessage.getText());
        } else if (this.m_radioProcess.getSelection()) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.29"));
            return null;
        }
        if (this.m_buttonValid.getSelection()) {
            info.setValidFlg(true);
        } else {
            info.setValidFlg(false);
        }
        return info;
    }

    @Override
    protected ValidateResult validate() {
        this.m_inputData = this.createInputData();
        if (this.m_inputData != null) {
            return super.validate();
        }
        return this.m_validateResult;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    protected void setEnabled(boolean enable) {
        this.m_comboPriority.setEnabled(enable);
        this.m_textMessage.setEnabled(enable);
    }

    protected void setValidateResult(String id, String message) {
        this.m_validateResult = new ValidateResult();
        this.m_validateResult.setValid(false);
        this.m_validateResult.setID(id);
        this.m_validateResult.setMessage(message);
    }

    @Override
    protected boolean action() {
        boolean result = false;
        MonitorStringValueInfo info = this.m_inputData;
        if (info != null) {
            result = true;
        }
        return result;
    }
}

