/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view.action;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.jobmanagement.action.OperationJob;
import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.composite.NodeDetailComposite;
import com.clustercontrol.jobmanagement.dialog.JobOperationDialog;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobDetailView;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.jobmanagement.view.JobNodeDetailView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class StartJobAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(StartJobAction.class);
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.StartJobAction";
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void run(IAction action) {
        CommonViewPart view;
        String sessionId = null;
        String jobunitId = null;
        String jobId = null;
        String facilityId = null;
        if (this.m_view instanceof JobHistoryView) {
            view = (JobHistoryView)((Object)this.m_view.getAdapter(JobHistoryView.class));
            HistoryComposite historyComposite = ((JobHistoryView)view).getComposite();
            sessionId = historyComposite.getSessionId();
            jobunitId = historyComposite.getJobunitId();
            jobId = historyComposite.getJobId();
        } else if (this.m_view instanceof JobDetailView) {
            view = (JobDetailView)((Object)this.m_view.getAdapter(JobDetailView.class));
            DetailComposite detailComposite = ((JobDetailView)view).getComposite();
            sessionId = detailComposite.getSessionId();
            jobunitId = detailComposite.getJobunitId();
            jobId = detailComposite.getJobId();
        } else if (this.m_view instanceof JobNodeDetailView) {
            view = (JobNodeDetailView)((Object)this.m_view.getAdapter(JobNodeDetailView.class));
            NodeDetailComposite nodeDetailComposite = ((JobNodeDetailView)view).getComposite();
            sessionId = nodeDetailComposite.getSessionId();
            jobunitId = nodeDetailComposite.getJobunitId();
            jobId = nodeDetailComposite.getJobId();
            facilityId = nodeDetailComposite.getFacilityId();
            if (facilityId == null) {
                sessionId = null;
                jobunitId = null;
                jobId = null;
            }
        }
        if (sessionId != null && sessionId.length() > 0 && jobunitId != null && jobunitId.length() > 0 && jobId != null && jobId.length() > 0) {
            JobOperationDialog dialog = new JobOperationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.setProperty(this.getStartProperty(sessionId, jobunitId, jobId, facilityId));
            dialog.setTitleText(String.valueOf(Messages.getString((String)"job")) + "[" + Messages.getString((String)"start") + "]");
            if (dialog.open() == 0) {
                OperationJob operation = new OperationJob();
                operation.operationJob(dialog.getProperty());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private Property getStartProperty(String sessionId, String jobunitId, String jobId, String facilityId) {
        Locale locale = Locale.getDefault();
        Property session = new Property("session", Messages.getString((String)"session.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        Property jobUnit = new Property("jobUnit", Messages.getString((String)"jobunit.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        Property job = new Property("job", Messages.getString((String)"job.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        Property facility = new Property("facility", Messages.getString((String)"facility.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        Property control = new Property("control", Messages.getString((String)"control", (Locale)locale), PropertyDefineConstant.EDITOR_SELECT);
        List<String> values = null;
        try {
            values = JobEndpointWrapper.getAvailableStartOperation(sessionId, jobunitId, jobId, facilityId);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("getStartProperty(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        Object[][] controlValues = new Object[][]{values.toArray(), values.toArray()};
        control.setSelectValues(controlValues);
        if (values.size() >= 1) {
            control.setValue(values.get(0));
        } else {
            control.setValue("");
        }
        session.setValue(sessionId);
        jobUnit.setValue(jobunitId);
        job.setValue(jobId);
        if (facilityId != null && facilityId.length() > 0) {
            facility.setValue(facilityId);
        } else {
            facility.setValue("");
        }
        session.setModify(0);
        jobUnit.setModify(0);
        job.setModify(0);
        facility.setModify(0);
        control.setModify(1);
        Property property = new Property(null, null, "");
        property.removeChildren();
        property.addChildren(session);
        property.addChildren(jobUnit);
        property.addChildren(job);
        if (facilityId != null && facilityId.length() > 0) {
            property.addChildren(facility);
        }
        property.addChildren(control);
        return property;
    }
}

