/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view.action;

import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobTriggerInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class RunJobAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(RunJobAction.class);
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.RunJobAction";
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void run(IAction action) {
        JobTreeItem item = null;
        if (this.m_view instanceof JobListView) {
            JobListView view = (JobListView)this.m_view.getAdapter(JobListView.class);
            if (JobEditStateUtil.isEdit()) {
                MessageDialog.openWarning(null, (String)Messages.getString((String)"confirmed"), (String)(String.valueOf(Messages.getString((String)"message.job.43")) + "\n" + Messages.getString((String)"message.job.44")));
                return;
            }
            item = view.getSelectJobTreeItem();
            if (item instanceof JobTreeItem) {
                Object[] args1 = new Object[]{item.getData().getName(), item.getData().getId(), item.getData().getJobunitId()};
                if (MessageDialog.openQuestion(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)Messages.getString((String)"message.job.32"), (Object[])args1))) {
                    try {
                        JobTriggerInfo triggerInfo = new JobTriggerInfo();
                        triggerInfo.setTriggerType(Integer.valueOf(2));
                        JobEndpointWrapper.runJob(item.getData().getJobunitId(), item.getData().getId(), null, triggerInfo);
                    }
                    catch (InvalidRole_Exception invalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    catch (Exception e) {
                        m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                    }
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

