/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite.action;

import com.clustercontrol.accesscontrol.action.CheckPermission;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.jobmanagement.dialog.JobTreeDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class JobIdSelectionListener
extends SelectionAdapter {
    private Text m_textJobunitId = null;
    private Text m_textJobId = null;
    private RoleIdListComposite m_ownerRoleId = null;

    public JobIdSelectionListener(Text jobunitId, Text jobId, RoleIdListComposite ownerRoleId) {
        this.m_textJobunitId = jobunitId;
        this.m_textJobId = jobId;
        this.m_ownerRoleId = ownerRoleId;
    }

    public void widgetSelected(SelectionEvent e) {
        boolean permission = new CheckPermission().check("JobManagement", PrivilegeConstant.SystemPrivilegeMode.EXEC);
        if (!permission) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        JobTreeDialog dialog = new JobTreeDialog(shell, this.m_ownerRoleId.getText());
        if (dialog.open() == 0) {
            JobTreeItem selectItem = dialog.getSelectItem();
            if (selectItem.getData().getType() != -1) {
                this.m_textJobId.setText(selectItem.getData().getId());
                this.m_textJobunitId.setText(selectItem.getData().getJobunitId());
            } else {
                this.m_textJobId.setText("");
                this.m_textJobunitId.setText("");
            }
        }
    }
}

