/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite.action;

import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.view.JobDetailView;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.jobmanagement.view.JobMapViewIF;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ErrorViewPart;

public class HistorySelectionChangedListener
implements ISelectionChangedListener {
    private static Log m_log = LogFactory.getLog(HistorySelectionChangedListener.class);
    private HistoryComposite m_composite;

    public HistorySelectionChangedListener(HistoryComposite composite) {
        this.m_composite = composite;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String sessionId = null;
        String jobunitId = null;
        String jobId = null;
        if (((StructuredSelection)event.getSelection()).getFirstElement() != null) {
            ArrayList info = (ArrayList)((StructuredSelection)event.getSelection()).getFirstElement();
            sessionId = (String)info.get(3);
            jobunitId = (String)info.get(6);
            jobId = (String)info.get(4);
            this.m_composite.setSessionId(sessionId);
            this.m_composite.setJobId(jobId);
            this.m_composite.setJobunitId(jobunitId);
        }
        String viewClass = ((Object)((Object)this.m_composite.getView())).getClass().getSimpleName();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (JobHistoryView.class.getSimpleName().equals(viewClass)) {
            m_log.debug((Object)"selectionChanged() : job detail update");
            IViewPart viewPartDetail = page.findView("com.clustercontrol.jobmanagement.view.JobDetailView");
            if (viewPartDetail != null) {
                JobDetailView view = (JobDetailView)((Object)viewPartDetail.getAdapter(JobDetailView.class));
                view.update(sessionId, jobunitId);
            }
        } else {
            m_log.debug((Object)"selectionChanged() : jobmap detail update");
            IViewReference viewReference = page.findViewReference("com.clustercontrol.jobmap.view.JobMapHistoryView");
            if (viewReference == null) {
                return;
            }
            IViewPart viewPart = viewReference.getView(false);
            if (viewPart != null && !(viewPart instanceof ErrorViewPart)) {
                m_log.debug((Object)("viewPart " + viewPart.getClass().getName()));
                JobMapViewIF view = (JobMapViewIF)viewPart;
                view.update(sessionId, null);
            }
        }
    }
}

