/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.action.NumberVerifyListener;
import com.clustercontrol.composite.action.PositiveNumberVerifyListener;
import com.clustercontrol.composite.action.TimeVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.TimeTo48hConverter;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StartDelayComposite
extends Composite {
    private Button m_sessionCondition = null;
    private Text m_sessionValue = null;
    private Button m_timeCondition = null;
    private Text m_timeValue = null;
    private Button m_andCondition = null;
    private Button m_orCondition = null;
    private Button m_notifyCondition = null;
    private Combo m_notifyPriority = null;
    private Button m_operationCondition = null;
    private Group m_operationConditionGroup = null;
    private Combo m_operationType = null;
    private Combo m_operationStatus = null;
    private Text m_operationValue = null;
    private Button m_startDelayCondition = null;
    private Group m_startDelayConditionGroup = null;
    private JobWaitRuleInfo m_waitRule = null;

    public StartDelayComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        Label label = null;
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        this.m_startDelayCondition = new Button(composite, 32);
        this.m_startDelayCondition.setText(Messages.getString((String)"start.delay"));
        this.m_startDelayCondition.setLayoutData((Object)new RowData(200, 22));
        this.m_startDelayCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                StartDelayComposite.this.setStartDelayEnabled(check.getSelection());
                StartDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_startDelayConditionGroup = new Group(composite, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_startDelayConditionGroup.setLayout((Layout)rowLayout);
        Group group = new Group((Composite)this.m_startDelayConditionGroup, 0);
        group.setText(Messages.getString((String)"object.list"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_sessionCondition = new Button(composite, 32);
        this.m_sessionCondition.setText(String.valueOf(Messages.getString((String)"time.after.session.start")) + " : ");
        this.m_sessionCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_sessionCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    StartDelayComposite.this.m_sessionValue.setEnabled(true);
                } else {
                    StartDelayComposite.this.m_sessionValue.setEnabled(false);
                }
                StartDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_sessionValue = new Text(composite, 2048);
        this.m_sessionValue.setLayoutData((Object)new RowData(100, 15));
        this.m_sessionValue.addVerifyListener((VerifyListener)new PositiveNumberVerifyListener(0, Short.MAX_VALUE));
        this.m_sessionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                StartDelayComposite.this.update();
            }
        });
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_timeCondition = new Button(composite, 32);
        this.m_timeCondition.setText(String.valueOf(Messages.getString((String)"wait.rule.time.example")) + " : ");
        this.m_timeCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_timeCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    StartDelayComposite.this.m_timeValue.setEnabled(true);
                } else {
                    StartDelayComposite.this.m_timeValue.setEnabled(false);
                }
                StartDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_timeValue = new Text(composite, 2048);
        this.m_timeValue.setLayoutData((Object)new RowData(100, 15));
        this.m_timeValue.addVerifyListener((VerifyListener)new TimeVerifyListener());
        this.m_timeValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                StartDelayComposite.this.update();
            }
        });
        group = new Group((Composite)this.m_startDelayConditionGroup, 0);
        group.setText(Messages.getString((String)"condition.between.objects"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_andCondition = new Button(composite, 16);
        this.m_andCondition.setText(Messages.getString((String)"and"));
        this.m_andCondition.setLayoutData((Object)new RowData(100, 22));
        this.m_orCondition = new Button(composite, 16);
        this.m_orCondition.setText(Messages.getString((String)"or"));
        this.m_orCondition.setLayoutData((Object)new RowData(100, 22));
        label = new Label(composite, 0);
        label.setLayoutData((Object)new RowData(77, 15));
        composite = new Composite((Composite)this.m_startDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new RowData(5, 15));
        composite = new Composite((Composite)this.m_startDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_notifyCondition = new Button(composite, 32);
        this.m_notifyCondition.setText(String.valueOf(Messages.getString((String)"notify.attribute")) + " : ");
        this.m_notifyCondition.setLayoutData((Object)new RowData(100, 22));
        this.m_notifyCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    StartDelayComposite.this.m_notifyPriority.setEnabled(true);
                } else {
                    StartDelayComposite.this.m_notifyPriority.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_notifyPriority = new Combo(composite, 0x1000008);
        this.m_notifyPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_notifyPriority.add(PriorityConstant.STRING_INFO);
        this.m_notifyPriority.add(PriorityConstant.STRING_WARNING);
        this.m_notifyPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_notifyPriority.add(PriorityConstant.STRING_UNKNOWN);
        composite = new Composite((Composite)this.m_startDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_operationCondition = new Button(composite, 32);
        this.m_operationCondition.setText(Messages.getString((String)"operations"));
        this.m_operationCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_operationCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    StartDelayComposite.this.m_operationType.setEnabled(true);
                    int type = StartDelayComposite.this.getSelectOperationName(StartDelayComposite.this.m_operationType);
                    if (type == 4) {
                        StartDelayComposite.this.m_operationStatus.setEnabled(true);
                        StartDelayComposite.this.m_operationValue.setEnabled(true);
                    } else if (type == 6) {
                        StartDelayComposite.this.m_operationStatus.setEnabled(false);
                        StartDelayComposite.this.m_operationValue.setEnabled(false);
                    }
                    StartDelayComposite.this.m_operationConditionGroup.setEnabled(true);
                } else {
                    StartDelayComposite.this.m_operationType.setEnabled(false);
                    StartDelayComposite.this.m_operationStatus.setEnabled(false);
                    StartDelayComposite.this.m_operationValue.setEnabled(false);
                    StartDelayComposite.this.m_operationConditionGroup.setEnabled(false);
                }
                StartDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_operationConditionGroup = new Group((Composite)this.m_startDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_operationConditionGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_operationConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"name")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_operationType = new Combo(composite, 0x1000008);
        this.m_operationType.setLayoutData((Object)new RowData(100, 20));
        this.m_operationType.add(OperationConstant.STRING_STOP_SKIP);
        this.m_operationType.add(OperationConstant.STRING_STOP_WAIT);
        this.m_operationType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo check = (Combo)e.getSource();
                int type = StartDelayComposite.this.getSelectOperationName(check);
                if (type == 4) {
                    StartDelayComposite.this.m_operationStatus.setEnabled(true);
                    StartDelayComposite.this.m_operationValue.setEnabled(true);
                } else if (type == 6) {
                    StartDelayComposite.this.m_operationStatus.setEnabled(false);
                    StartDelayComposite.this.m_operationValue.setEnabled(false);
                }
                StartDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        composite = new Composite((Composite)this.m_operationConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"end.status")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_operationStatus = new Combo(composite, 0x1000008);
        this.m_operationStatus.setLayoutData((Object)new RowData(100, 20));
        this.m_operationStatus.add(EndStatusConstant.STRING_NORMAL);
        this.m_operationStatus.add(EndStatusConstant.STRING_WARNING);
        this.m_operationStatus.add(EndStatusConstant.STRING_ABNORMAL);
        composite = new Composite((Composite)this.m_operationConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_operationValue = new Text(composite, 2048);
        this.m_operationValue.setLayoutData((Object)new RowData(100, 15));
        this.m_operationValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_operationValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                StartDelayComposite.this.update();
            }
        });
        label = new Label(composite, 0);
        label.setLayoutData((Object)new RowData(70, 15));
    }

    public void update() {
        if (this.m_startDelayCondition.getSelection() && this.m_sessionCondition.getSelection() && "".equals(this.m_sessionValue.getText())) {
            this.m_sessionValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_sessionValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_startDelayCondition.getSelection() && this.m_timeCondition.getSelection() && "".equals(this.m_timeValue.getText())) {
            this.m_timeValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_timeValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_startDelayCondition.getSelection() && this.m_operationCondition.getSelection() && this.getSelectOperationName(this.m_operationType) == 4 && "".equals(this.m_operationValue.getText())) {
            this.m_operationValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_operationValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public void reflectWaitRuleInfo() {
        if (this.m_waitRule != null) {
            this.m_startDelayCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getStartDelay()));
            this.m_sessionCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getStartDelaySession()));
            this.m_sessionValue.setText(String.valueOf(this.m_waitRule.getStartDelaySessionValue()));
            this.m_timeCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getStartDelayTime()));
            if (this.m_waitRule.getStartDelayTimeValue() != null) {
                this.m_timeValue.setText(TimeTo48hConverter.dateTo48hms(new Date(this.m_waitRule.getStartDelayTimeValue())));
            } else {
                this.m_timeValue.setText("");
            }
            if (this.m_waitRule.getStartDelayConditionType() == 0) {
                this.m_andCondition.setSelection(true);
                this.m_orCondition.setSelection(false);
            } else {
                this.m_andCondition.setSelection(false);
                this.m_orCondition.setSelection(true);
            }
            this.m_notifyCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getStartDelayNotify()));
            this.setSelectPriority(this.m_notifyPriority, this.m_waitRule.getStartDelayNotifyPriority());
            this.m_operationCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getStartDelayOperation()));
            this.setSelectOperationName(this.m_operationType, this.m_waitRule.getStartDelayOperationType());
            this.setSelectOperationEndStatus(this.m_operationStatus, this.m_waitRule.getStartDelayOperationEndStatus());
            this.m_operationValue.setText(String.valueOf(this.m_waitRule.getStartDelayOperationEndValue()));
        }
        this.setStartDelayEnabled(this.m_startDelayCondition.getSelection());
    }

    public void setWaitRuleInfo(JobWaitRuleInfo start) {
        this.m_waitRule = start;
    }

    public JobWaitRuleInfo getWaitRuleInfo() {
        return this.m_waitRule;
    }

    public ValidateResult createWaitRuleInfo() {
        ValidateResult result;
        block14: {
            result = null;
            this.m_waitRule.setStartDelay(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_startDelayCondition.getSelection())));
            this.m_waitRule.setStartDelaySession(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_sessionCondition.getSelection())));
            try {
                this.m_waitRule.setStartDelaySessionValue(Integer.valueOf(Integer.parseInt(this.m_sessionValue.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.m_waitRule.getStartDelaySession() != 1) break block14;
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.52"));
                return result;
            }
        }
        this.m_waitRule.setStartDelayTime(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_timeCondition.getSelection())));
        if (this.m_waitRule.getStartDelayTime() == 1) {
            boolean check = false;
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Date from = null;
            Date to = null;
            Date date = null;
            try {
                from = formatter.parse("00:00:00");
                to = formatter.parse("48:00:00");
                date = formatter.parse(this.m_timeValue.getText());
                check = true;
            }
            catch (ParseException parseException) {
                formatter = new SimpleDateFormat("HH:mm");
                try {
                    date = formatter.parse(this.m_timeValue.getText());
                    check = true;
                }
                catch (ParseException parseException2) {}
            }
            if (check) {
                if (date.before(from) || date.after(to)) {
                    Object[] args = new String[]{formatter.format(from), TimeTo48hConverter.dateTo48hms(to)};
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.hinemos.8", (Object[])args));
                    return result;
                }
                this.m_waitRule.setStartDelayTimeValue(Long.valueOf(date.getTime()));
            } else {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.hinemos.6"));
                return result;
            }
        }
        if (this.m_andCondition.getSelection()) {
            this.m_waitRule.setStartDelayConditionType(Integer.valueOf(0));
        } else {
            this.m_waitRule.setStartDelayConditionType(Integer.valueOf(1));
        }
        this.m_waitRule.setStartDelayNotify(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_notifyCondition.getSelection())));
        this.m_waitRule.setStartDelayNotifyPriority(Integer.valueOf(this.getSelectPriority(this.m_notifyPriority)));
        this.m_waitRule.setStartDelayOperation(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_operationCondition.getSelection())));
        this.m_waitRule.setStartDelayOperationType(Integer.valueOf(this.getSelectOperationName(this.m_operationType)));
        try {
            this.m_waitRule.setStartDelayOperationEndStatus(Integer.valueOf(this.getSelectOperationEndStatus(this.m_operationStatus)));
            this.m_waitRule.setStartDelayOperationEndValue(Integer.valueOf(Integer.parseInt(this.m_operationValue.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.21"));
            return result;
        }
        return null;
    }

    private void setStartDelayEnabled(boolean enabled) {
        if (enabled) {
            this.m_startDelayConditionGroup.setEnabled(true);
            this.m_sessionCondition.setEnabled(true);
            if (this.m_sessionCondition.getSelection()) {
                this.m_sessionValue.setEnabled(true);
            } else {
                this.m_sessionValue.setEnabled(false);
            }
            this.m_timeCondition.setEnabled(true);
            if (this.m_timeCondition.getSelection()) {
                this.m_timeValue.setEnabled(true);
            } else {
                this.m_timeValue.setEnabled(false);
            }
            this.m_andCondition.setEnabled(true);
            this.m_orCondition.setEnabled(true);
            this.m_notifyCondition.setEnabled(true);
            if (this.m_notifyCondition.getSelection()) {
                this.m_notifyPriority.setEnabled(true);
            } else {
                this.m_notifyPriority.setEnabled(false);
            }
            this.m_operationConditionGroup.setEnabled(true);
            this.m_operationCondition.setEnabled(true);
            if (this.m_operationCondition.getSelection()) {
                this.m_operationType.setEnabled(true);
                this.m_operationStatus.setEnabled(false);
                this.m_operationValue.setEnabled(false);
                int type = this.getSelectOperationName(this.m_operationType);
                if (type == 4) {
                    this.m_operationStatus.setEnabled(true);
                    this.m_operationValue.setEnabled(true);
                } else if (type == 6) {
                    this.m_operationStatus.setEnabled(false);
                    this.m_operationValue.setEnabled(false);
                }
            } else {
                this.m_operationType.setEnabled(false);
                this.m_operationStatus.setEnabled(false);
                this.m_operationValue.setEnabled(false);
            }
        } else {
            this.m_startDelayConditionGroup.setEnabled(false);
            this.m_sessionCondition.setEnabled(false);
            this.m_sessionValue.setEnabled(false);
            this.m_timeCondition.setEnabled(false);
            this.m_timeValue.setEnabled(false);
            this.m_andCondition.setEnabled(false);
            this.m_orCondition.setEnabled(false);
            this.m_notifyCondition.setEnabled(false);
            this.m_notifyPriority.setEnabled(false);
            this.m_operationCondition.setEnabled(false);
            this.m_operationType.setEnabled(false);
            this.m_operationStatus.setEnabled(false);
            this.m_operationValue.setEnabled(false);
            this.m_operationConditionGroup.setEnabled(false);
        }
    }

    private void setSelectPriority(Combo combo, int priority) {
        String select = "";
        if (priority == 0) {
            select = PriorityConstant.STRING_CRITICAL;
        } else if (priority == 2) {
            select = PriorityConstant.STRING_WARNING;
        } else if (priority == 3) {
            select = PriorityConstant.STRING_INFO;
        } else if (priority == 1) {
            select = PriorityConstant.STRING_UNKNOWN;
        } else if (priority == 4) {
            select = "";
        }
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    private int getSelectPriority(Combo combo) {
        String select = combo.getText();
        if (select.equals(PriorityConstant.STRING_CRITICAL)) {
            return 0;
        }
        if (select.equals(PriorityConstant.STRING_WARNING)) {
            return 2;
        }
        if (select.equals(PriorityConstant.STRING_INFO)) {
            return 3;
        }
        if (select.equals(PriorityConstant.STRING_UNKNOWN)) {
            return 1;
        }
        if (select.equals("")) {
            return 4;
        }
        return -1;
    }

    private void setSelectOperationName(Combo combo, int operation) {
        String select = "";
        if (operation == 4) {
            select = OperationConstant.STRING_STOP_SKIP;
        } else if (operation == 6) {
            select = OperationConstant.STRING_STOP_WAIT;
        }
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    private int getSelectOperationName(Combo combo) {
        String select = combo.getText();
        if (select.equals(OperationConstant.STRING_STOP_SKIP)) {
            return 4;
        }
        if (select.equals(OperationConstant.STRING_STOP_WAIT)) {
            return 6;
        }
        return -1;
    }

    private void setSelectOperationEndStatus(Combo combo, int status) {
        String select = "";
        select = EndStatusConstant.typeToString((int)status);
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    private int getSelectOperationEndStatus(Combo combo) {
        String select = combo.getText();
        return EndStatusConstant.stringToType((String)select);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_sessionCondition.setEnabled(enabled);
        this.m_sessionValue.setEnabled(enabled);
        this.m_timeCondition.setEnabled(enabled);
        this.m_timeValue.setEnabled(enabled);
        this.m_andCondition.setEnabled(enabled);
        this.m_orCondition.setEnabled(enabled);
        this.m_notifyCondition.setEnabled(enabled);
        this.m_notifyPriority.setEnabled(enabled);
        this.m_operationCondition.setEnabled(enabled);
        this.m_operationType.setEnabled(enabled);
        this.m_operationStatus.setEnabled(enabled);
        this.m_operationValue.setEnabled(enabled);
        this.m_startDelayCondition.setEnabled(enabled);
    }
}

