/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.action.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MultiplicityComposite
extends Composite {
    private Button m_waitCondition = null;
    private Button m_endCondition = null;
    private Text m_endValue = null;
    private Button m_notifyCondition = null;
    private Combo m_notifyPriority = null;
    private JobWaitRuleInfo m_waitRule = null;
    private Composite topComposite = null;

    public MultiplicityComposite(Composite parent, int style, boolean isFileJob) {
        super(parent, style);
        this.initialize(isFileJob);
    }

    private void initialize(boolean isFileJob) {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        this.topComposite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        this.topComposite.setLayout((Layout)rowLayout);
        Group group = new Group(this.topComposite, 0);
        group.setText(Messages.getString((String)"job.multiplicity.action"));
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_notifyCondition = new Button(composite, 32);
        this.m_notifyCondition.setText(String.valueOf(Messages.getString((String)"notify")) + " : ");
        this.m_notifyCondition.setLayoutData((Object)new RowData(150, 22));
        this.m_notifyCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    MultiplicityComposite.this.m_notifyPriority.setEnabled(true);
                } else {
                    MultiplicityComposite.this.m_notifyPriority.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_notifyPriority = new Combo(composite, 0x1000008);
        this.m_notifyPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_notifyPriority.add(PriorityConstant.STRING_INFO);
        this.m_notifyPriority.add(PriorityConstant.STRING_WARNING);
        this.m_notifyPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_notifyPriority.add(PriorityConstant.STRING_UNKNOWN);
        Group actionGroup = new Group((Composite)group, 0);
        actionGroup.setText(Messages.getString((String)"operations"));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.numColumns = 5;
        actionGroup.setLayout((Layout)gridLayout);
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.horizontalSpan = 1;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalSpan = 4;
        this.m_waitCondition = new Button((Composite)actionGroup, 16);
        this.m_waitCondition.setText(Messages.getString((String)"wait"));
        this.m_waitCondition.setLayoutData((Object)gridData1);
        this.m_waitCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MultiplicityComposite.this.setMultiplicityOperation(0);
                MultiplicityComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label spaceLabel = null;
        spaceLabel = new Label((Composite)actionGroup, 0);
        spaceLabel.setLayoutData((Object)gridData2);
        this.m_endCondition = new Button((Composite)actionGroup, 16);
        this.m_endCondition.setText(Messages.getString((String)"end"));
        this.m_endCondition.setLayoutData((Object)gridData1);
        this.m_endCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MultiplicityComposite.this.setMultiplicityOperation(300);
                MultiplicityComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group endGroup = new Group((Composite)actionGroup, 16384);
        endGroup.setLayoutData((Object)gridData2);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 3;
        rowLayout.spacing = 1;
        endGroup.setLayout((Layout)rowLayout);
        Label endLabel = new Label((Composite)endGroup, 16384);
        endLabel.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        endLabel.setLayoutData((Object)new RowData(80, 15));
        this.m_endValue = new Text((Composite)endGroup, 2048);
        this.m_endValue.setLayoutData((Object)new RowData(100, 15));
        this.m_endValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_endValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MultiplicityComposite.this.update();
            }
        });
    }

    public void update() {
        if (this.m_endCondition.getSelection() && "".equals(this.m_endValue.getText())) {
            this.m_endValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_endValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public void reflectWaitRuleInfo() {
        if (this.m_waitRule != null) {
            this.m_notifyCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getMultiplicityNotify()));
            this.setSelectPriority(this.m_notifyPriority, this.m_waitRule.getMultiplicityNotifyPriority());
            this.setMultiplicityOperation(this.m_waitRule.getMultiplicityOperation());
            this.m_endValue.setText(String.valueOf(this.m_waitRule.getMultiplicityEndValue()));
        }
    }

    private void setMultiplicityOperation(Integer status) {
        this.m_waitCondition.setSelection(false);
        this.m_endCondition.setSelection(false);
        if (status == 300) {
            this.m_endCondition.setSelection(true);
            this.m_endValue.setEnabled(true);
        } else if (status == 100) {
            this.m_endValue.setEnabled(false);
        } else {
            this.m_waitCondition.setSelection(true);
            this.m_endValue.setEnabled(false);
        }
    }

    public void setWaitRuleInfo(JobWaitRuleInfo start) {
        this.m_waitRule = start;
    }

    public JobWaitRuleInfo getWaitRuleInfo() {
        return this.m_waitRule;
    }

    public ValidateResult createWaitRuleInfo() {
        block5: {
            if (this.m_waitCondition.getSelection()) {
                this.m_waitRule.setMultiplicityOperation(Integer.valueOf(0));
            } else if (this.m_endCondition.getSelection()) {
                this.m_waitRule.setMultiplicityOperation(Integer.valueOf(300));
            }
            this.m_waitRule.setMultiplicityNotify(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_notifyCondition.getSelection())));
            this.m_waitRule.setMultiplicityNotifyPriority(Integer.valueOf(this.getSelectPriority(this.m_notifyPriority)));
            try {
                this.m_waitRule.setMultiplicityEndValue(Integer.valueOf(Integer.parseInt(this.m_endValue.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.m_waitRule.getMultiplicityOperation() != 300) break block5;
                ValidateResult result = null;
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.21"));
                return result;
            }
        }
        return null;
    }

    public void setSelectPriority(Combo combo, int priority) {
        String select = "";
        if (priority == 0) {
            select = PriorityConstant.STRING_CRITICAL;
        } else if (priority == 2) {
            select = PriorityConstant.STRING_WARNING;
        } else if (priority == 3) {
            select = PriorityConstant.STRING_INFO;
        } else if (priority == 1) {
            select = PriorityConstant.STRING_UNKNOWN;
        } else if (priority == 4) {
            select = "";
        }
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    public int getSelectPriority(Combo combo) {
        String select = combo.getText();
        if (select.equals(PriorityConstant.STRING_CRITICAL)) {
            return 0;
        }
        if (select.equals(PriorityConstant.STRING_WARNING)) {
            return 2;
        }
        if (select.equals(PriorityConstant.STRING_INFO)) {
            return 3;
        }
        if (select.equals(PriorityConstant.STRING_UNKNOWN)) {
            return 1;
        }
        if (select.equals("")) {
            return 4;
        }
        return -1;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_waitCondition.setEnabled(enabled);
        this.m_endCondition.setEnabled(enabled);
        this.m_endValue.setEnabled(enabled);
        this.m_notifyCondition.setEnabled(enabled);
        this.m_notifyPriority.setEnabled(enabled);
    }
}

