/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.action.GetHistoryTableDefine;
import com.clustercontrol.jobmanagement.composite.action.HistorySelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.SessionJobDoubleClickListener;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.util.JobPropertyUtil;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobHistory;
import com.clustercontrol.ws.jobmanagement.JobHistoryList;
import com.sun.xml.internal.ws.client.ClientTransportException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class HistoryComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(HistoryComposite.class);
    private CommonTableViewer m_viewer = null;
    private Label m_labelType = null;
    private Label m_labelCount = null;
    private String m_sessionId = null;
    private String m_jobunitId = null;
    private String m_jobId = null;
    private JobHistoryView m_view = null;

    public HistoryComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void setView(JobHistoryView view) {
        this.m_view = view;
    }

    public JobHistoryView getView() {
        return this.m_view;
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_labelType = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelType.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetHistoryTableDefine.get(), 3, -1);
        this.m_viewer.addSelectionChangedListener(new HistorySelectionChangedListener(this));
        this.m_viewer.addDoubleClickListener(new SessionJobDoubleClickListener(this));
    }

    public void update() {
        this.update(null);
    }

    public void update(Property condition) {
        Object[] args;
        JobHistoryList historyInfo;
        block17: {
            historyInfo = null;
            try {
                int histories = ClusterControlPlugin.getDefault().getPreferenceStore().getInt("historyMaxHistories");
                historyInfo = condition == null ? JobEndpointWrapper.getJobHistoryList(null, histories) : JobEndpointWrapper.getJobHistoryList(JobPropertyUtil.property2jobHistoryFilter(condition), histories);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                if (LocalSession.isDialogFlag()) {
                    LocalSession.setDialogFlag(false);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    LocalSession.setDialogFlag(true);
                }
            }
            catch (Exception e) {
                if (!LocalSession.isDialogFlag()) break block17;
                LocalSession.setDialogFlag(false);
                if (e instanceof ClientTransportException) {
                    m_log.warn((Object)("update() getJobHistoryList, " + e.getMessage()));
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.transfer")) + ", " + e.getMessage()));
                } else {
                    m_log.warn((Object)("update() getJobHistoryList, " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
                LocalSession.setDialogFlag(true);
            }
        }
        if (historyInfo == null) {
            historyInfo = new JobHistoryList();
            historyInfo.setTotal(Integer.valueOf(0));
        }
        if (ClusterControlPlugin.getDefault().getPreferenceStore().getBoolean("historyMessageFlg") && historyInfo.getTotal() > historyInfo.getList().size() && LocalSession.isDialogFlag()) {
            LocalSession.setDialogFlag(false);
            MessageDialogWithToggle.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.job.33"), (String)Messages.getString((String)"message.will.not.be.displayed"), (boolean)false, (IPreferenceStore)ClusterControlPlugin.getDefault().getPreferenceStore(), (String)"historyMessageFlg");
            LocalSession.setDialogFlag(true);
        }
        ArrayList<Object> listInput = new ArrayList<Object>();
        for (JobHistory history : historyInfo.getList()) {
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(history.getStatus());
            a.add(history.getEndStatus());
            a.add(history.getEndValue());
            a.add(history.getSessionId());
            a.add(history.getJobId());
            a.add(history.getJobName());
            a.add(history.getJobunitId());
            a.add(history.getJobType());
            a.add(history.getFacilityId());
            a.add(history.getScope());
            a.add(history.getOwnerRoleId());
            if (history.getScheduleDate() != null) {
                a.add(new Date(history.getScheduleDate()));
            } else {
                a.add("");
            }
            if (history.getStartDate() != null) {
                a.add(new Date(history.getStartDate()));
            } else {
                a.add("");
            }
            if (history.getEndDate() != null) {
                a.add(new Date(history.getEndDate()));
            } else {
                a.add("");
            }
            a.add(history.getJobTriggerType());
            a.add(history.getTriggerInfo());
            listInput.add(a);
        }
        this.m_viewer.setInput(listInput);
        this.selectHistory(listInput);
        if (condition != null) {
            this.m_labelType.setText(Messages.getString((String)"filtered.list"));
            args = new Object[]{new Integer(historyInfo.getTotal())};
            this.m_labelCount.setText(Messages.getString((String)"filtered.records", (Object[])args));
        } else {
            this.m_labelType.setText("");
            args = null;
            args = historyInfo.getTotal() > historyInfo.getList().size() ? new Object[]{historyInfo.getList().size()} : new Object[]{historyInfo.getTotal()};
            this.m_labelCount.setText(Messages.getString((String)"records", (Object[])args));
        }
    }

    public void selectHistory(ArrayList<Object> historyInfo) {
        if (this.m_sessionId != null && this.m_sessionId.length() > 0) {
            int index = -1;
            int i = 0;
            while (i < historyInfo.size()) {
                ArrayList line = (ArrayList)historyInfo.get(i);
                String sessionId = (String)line.get(3);
                if (this.m_sessionId.compareTo(sessionId) == 0) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                this.m_sessionId = null;
                this.m_jobId = null;
            } else {
                this.m_viewer.setSelection((ISelection)new StructuredSelection(historyInfo.get(index)), true);
            }
        }
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }

    public String getJobId() {
        return this.m_jobId;
    }

    public void setJobId(String jobId) {
        this.m_jobId = jobId;
    }

    public String getJobunitId() {
        return this.m_jobunitId;
    }

    public void setJobunitId(String jobunitId) {
        this.m_jobunitId = jobunitId;
    }
}

