/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.EndStatusColorConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.composite.action.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobEndStatusInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EndStatusComposite
extends Composite {
    private Text m_normalValue = null;
    private Text m_normalStartRange = null;
    private Text m_normalEndRange = null;
    private Text m_warningValue = null;
    private Text m_warningStartRange = null;
    private Text m_warningEndRange = null;
    private Text m_abnormalValue = null;
    private List<JobEndStatusInfo> m_end = null;

    public EndStatusComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label dummy1 = new Label(composite, 0);
        dummy1.setLayoutData((Object)new RowData(60, 15));
        Label endValueTitle = new Label(composite, 0x1000000);
        endValueTitle.setText(Messages.getString((String)"end.value"));
        endValueTitle.setLayoutData((Object)new RowData(100, 15));
        Label rangeTitle = new Label(composite, 0x1000000);
        rangeTitle.setText(Messages.getString((String)"range.end.value"));
        rangeTitle.setLayoutData((Object)new RowData(240, 15));
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label normalTitle = new Label(composite, 0x1000000);
        normalTitle.setText(String.valueOf(EndStatusConstant.STRING_NORMAL) + " : ");
        normalTitle.setLayoutData((Object)new RowData(60, 15));
        normalTitle.setBackground(EndStatusColorConstant.COLOR_NORMAL);
        this.m_normalValue = new Text(composite, 2048);
        this.m_normalValue.setLayoutData((Object)new RowData(100, 15));
        this.m_normalValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_normalValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndStatusComposite.this.update();
            }
        });
        this.m_normalStartRange = new Text(composite, 2048);
        this.m_normalStartRange.setText("");
        this.m_normalStartRange.setLayoutData((Object)new RowData(100, 15));
        this.m_normalStartRange.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_normalStartRange.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndStatusComposite.this.update();
            }
        });
        Label normalTo = new Label(composite, 0x1000000);
        normalTo.setText("-");
        normalTo.setLayoutData((Object)new RowData(20, 15));
        this.m_normalEndRange = new Text(composite, 2048);
        this.m_normalEndRange.setText("");
        this.m_normalEndRange.setLayoutData((Object)new RowData(100, 15));
        this.m_normalEndRange.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_normalEndRange.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndStatusComposite.this.update();
            }
        });
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label warningTitle = new Label(composite, 0x1000000);
        warningTitle.setText(String.valueOf(EndStatusConstant.STRING_WARNING) + " : ");
        warningTitle.setLayoutData((Object)new RowData(60, 15));
        warningTitle.setBackground(EndStatusColorConstant.COLOR_WARNING);
        this.m_warningValue = new Text(composite, 2048);
        this.m_warningValue.setLayoutData((Object)new RowData(100, 15));
        this.m_warningValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_warningValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndStatusComposite.this.update();
            }
        });
        this.m_warningStartRange = new Text(composite, 2048);
        this.m_warningStartRange.setText("");
        this.m_warningStartRange.setLayoutData((Object)new RowData(100, 15));
        this.m_warningStartRange.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_warningStartRange.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndStatusComposite.this.update();
            }
        });
        Label warningTo = new Label(composite, 0x1000000);
        warningTo.setText("-");
        warningTo.setLayoutData((Object)new RowData(20, 15));
        this.m_warningEndRange = new Text(composite, 2048);
        this.m_warningEndRange.setText("");
        this.m_warningEndRange.setLayoutData((Object)new RowData(100, 15));
        this.m_warningEndRange.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_warningEndRange.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndStatusComposite.this.update();
            }
        });
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label abnormalTitle = new Label(composite, 0x1000000);
        abnormalTitle.setText(String.valueOf(EndStatusConstant.STRING_ABNORMAL) + " : ");
        abnormalTitle.setLayoutData((Object)new RowData(60, 15));
        abnormalTitle.setBackground(EndStatusColorConstant.COLOR_ABNORMAL);
        this.m_abnormalValue = new Text(composite, 2048);
        this.m_abnormalValue.setLayoutData((Object)new RowData(100, 15));
        this.m_abnormalValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_abnormalValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndStatusComposite.this.update();
            }
        });
        Label abnormalMessage = new Label(composite, 0x1000000);
        abnormalMessage.setText(Messages.getString((String)"other"));
        abnormalMessage.setLayoutData((Object)new RowData(240, 15));
    }

    public void update() {
        if ("".equals(this.m_normalValue.getText())) {
            this.m_normalValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_normalValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_normalStartRange.getText())) {
            this.m_normalStartRange.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_normalStartRange.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_normalEndRange.getText())) {
            this.m_normalEndRange.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_normalEndRange.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_warningValue.getText())) {
            this.m_warningValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_warningValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_warningStartRange.getText())) {
            this.m_warningStartRange.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_warningStartRange.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_warningEndRange.getText())) {
            this.m_warningEndRange.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_warningEndRange.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_abnormalValue.getText())) {
            this.m_abnormalValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_abnormalValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public void reflectEndInfo() {
        this.m_normalValue.setText(String.valueOf(0));
        this.m_normalStartRange.setText("0");
        this.m_normalEndRange.setText("0");
        this.m_warningValue.setText(String.valueOf(1));
        this.m_warningStartRange.setText("1");
        this.m_warningEndRange.setText("1");
        this.m_abnormalValue.setText(String.valueOf(-1));
        if (this.m_end != null) {
            JobEndStatusInfo infoNormal = null;
            JobEndStatusInfo infoWarning = null;
            JobEndStatusInfo infoAbnormal = null;
            int i = 0;
            while (i < this.m_end.size()) {
                if (this.m_end.get(i).getType() == 0) {
                    infoNormal = this.m_end.get(i);
                } else if (this.m_end.get(i).getType() == 1) {
                    infoWarning = this.m_end.get(i);
                } else if (this.m_end.get(i).getType() == 2) {
                    infoAbnormal = this.m_end.get(i);
                }
                ++i;
            }
            if (infoNormal instanceof JobEndStatusInfo) {
                this.m_normalValue.setText(String.valueOf(infoNormal.getValue()));
                this.m_normalStartRange.setText(String.valueOf(infoNormal.getStartRangeValue()));
                this.m_normalEndRange.setText(String.valueOf(infoNormal.getEndRangeValue()));
            }
            if (infoWarning instanceof JobEndStatusInfo) {
                this.m_warningValue.setText(String.valueOf(infoWarning.getValue()));
                this.m_warningStartRange.setText(String.valueOf(infoWarning.getStartRangeValue()));
                this.m_warningEndRange.setText(String.valueOf(infoWarning.getEndRangeValue()));
            }
            if (infoAbnormal instanceof JobEndStatusInfo) {
                this.m_abnormalValue.setText(String.valueOf(infoAbnormal.getValue()));
            }
        }
    }

    public void setEndInfo(List<JobEndStatusInfo> end) {
        this.m_end = end;
    }

    public List<JobEndStatusInfo> getEndInfo() {
        return this.m_end;
    }

    public ValidateResult createEndInfo() {
        ValidateResult result = null;
        JobEndStatusInfo infoNormal = null;
        JobEndStatusInfo infoWarning = null;
        JobEndStatusInfo infoAbnormal = null;
        this.m_end = new ArrayList<JobEndStatusInfo>();
        infoNormal = new JobEndStatusInfo();
        infoNormal.setType(Integer.valueOf(0));
        this.m_end.add(infoNormal);
        infoWarning = new JobEndStatusInfo();
        infoWarning.setType(Integer.valueOf(1));
        this.m_end.add(infoWarning);
        infoAbnormal = new JobEndStatusInfo();
        infoAbnormal.setType(Integer.valueOf(2));
        this.m_end.add(infoAbnormal);
        try {
            infoNormal.setValue(Integer.valueOf(Integer.parseInt(this.m_normalValue.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.7"));
            return result;
        }
        try {
            infoNormal.setStartRangeValue(Integer.valueOf(Integer.parseInt(this.m_normalStartRange.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.8"));
            return result;
        }
        try {
            infoNormal.setEndRangeValue(Integer.valueOf(Integer.parseInt(this.m_normalEndRange.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.9"));
            return result;
        }
        try {
            infoWarning.setValue(Integer.valueOf(Integer.parseInt(this.m_warningValue.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.10"));
            return result;
        }
        try {
            infoWarning.setStartRangeValue(Integer.valueOf(Integer.parseInt(this.m_warningStartRange.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.11"));
            return result;
        }
        try {
            infoWarning.setEndRangeValue(Integer.valueOf(Integer.parseInt(this.m_warningEndRange.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.12"));
            return result;
        }
        try {
            infoAbnormal.setValue(Integer.valueOf(Integer.parseInt(this.m_abnormalValue.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.13"));
            return result;
        }
        if (infoNormal.getStartRangeValue() > infoNormal.getEndRangeValue()) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.14"));
            return result;
        }
        if (infoWarning.getStartRangeValue() > infoWarning.getEndRangeValue()) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.15"));
            return result;
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_normalValue.setEnabled(enabled);
        this.m_normalStartRange.setEnabled(enabled);
        this.m_normalEndRange.setEnabled(enabled);
        this.m_warningValue.setEnabled(enabled);
        this.m_warningStartRange.setEnabled(enabled);
        this.m_warningEndRange.setEnabled(enabled);
        this.m_abnormalValue.setEnabled(enabled);
    }
}

